/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.identifier.site.SiteIdentifier;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRLsn;
import io.github.dsheirer.module.decode.dmr.identifier.DMRNetwork;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraAdjacentSiteInformation;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraAnnouncement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityMaxAloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusNeighborReport;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Aloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.AdjacentSiteInformation;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ConnectPlusControlChannel;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ConnectPlusTrafficChannel;
import io.github.dsheirer.module.decode.dmr.message.type.Model;
import io.github.dsheirer.module.decode.dmr.message.type.SystemIdentityCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRNetworkConfigurationMonitor {
    private static final Logger mLog = LoggerFactory.getLogger(DMRNetworkConfigurationMonitor.class);
    private static final String BRAND_HYTERA = "Hytera";
    private static final String BRAND_MOTOROLA_CAPACITY_PLUS = "Motorola Capacity+";
    private static final String BRAND_MOTOROLA_CONNECT_PLUS = "Motorola Connect+";
    private static final String BRAND_STANDARD = "Standard";
    private static final String BRAND_TIER_3_TRUNKING = "Tier III Trunking";
    private static final String BRAND_MOTOROLA_CAPACITY_MAX_TIER_3_TRUNKING = "Capacity Max Tier III Trunking";
    private static final String BRAND_HYTERA_TIER_3_TRUNKING = "Hytera Tier III Trunking";
    private List<SiteIdentifier> mNeighborSites = new ArrayList<SiteIdentifier>();
    private Map<Integer, AdjacentSiteInformation> mTier3NeighborSites = new HashMap<Integer, AdjacentSiteInformation>();
    private Map<Integer, DMRChannel> mObservedChannelMap = new HashMap<Integer, DMRChannel>();
    private DMRNetwork mDMRNetwork;
    private DMRSite mDMRSite;
    private Model mTier3Model;
    private String mBrand;
    private Integer mColorCode;
    private DMRChannel mCurrentChannel;
    private Channel mChannel;

    public DMRNetworkConfigurationMonitor(Channel channel) {
        this.mChannel = channel;
    }

    public void setCurrentChannel(DMRChannel channel) {
        this.mCurrentChannel = channel;
    }

    public void process(DMRMessage message) {
        if (message instanceof CSBKMessage) {
            this.process((CSBKMessage)message);
        } else if (message instanceof LCMessage) {
            this.process((LCMessage)message);
        }
    }

    public void process(LCMessage linkControl) {
        switch (linkControl.getOpcode()) {
            case SHORT_CONNECT_PLUS_CONTROL_CHANNEL: {
                if ((this.mDMRNetwork == null || this.mDMRSite == null) && linkControl instanceof ConnectPlusControlChannel) {
                    ConnectPlusControlChannel cpcc = (ConnectPlusControlChannel)linkControl;
                    this.mDMRNetwork = cpcc.getNetwork();
                    this.mDMRSite = cpcc.getSite();
                }
                if (this.mBrand != null) break;
                this.mBrand = BRAND_MOTOROLA_CONNECT_PLUS;
                break;
            }
            case SHORT_CONNECT_PLUS_TRAFFIC_CHANNEL: {
                if ((this.mDMRNetwork == null || this.mDMRSite == null) && linkControl instanceof ConnectPlusTrafficChannel) {
                    ConnectPlusTrafficChannel cptc = (ConnectPlusTrafficChannel)linkControl;
                    this.mDMRNetwork = cptc.getNetwork();
                    this.mDMRSite = cptc.getSite();
                }
                if (this.mBrand != null) break;
                this.mBrand = BRAND_MOTOROLA_CONNECT_PLUS;
            }
        }
    }

    public void process(CSBKMessage csbk) {
        switch (csbk.getOpcode()) {
            case STANDARD_ALOHA: {
                if (!(csbk instanceof Aloha)) break;
                if (this.mDMRNetwork == null || this.mDMRSite == null) {
                    SystemIdentityCode sic = ((Aloha)csbk).getSystemIdentityCode();
                    if (this.mDMRNetwork == null) {
                        this.mDMRNetwork = sic.getNetwork();
                    }
                    if (this.mDMRSite == null) {
                        this.mDMRSite = sic.getSite();
                    }
                    if (this.mTier3Model == null) {
                        this.mTier3Model = sic.getModel();
                    }
                }
                if (this.mBrand != null) break;
                this.mBrand = BRAND_TIER_3_TRUNKING;
                break;
            }
            case HYTERA_08_ANNOUNCEMENT: 
            case HYTERA_68_ANNOUNCEMENT: {
                HyteraAdjacentSiteInformation hasi;
                int site;
                if (csbk instanceof HyteraAnnouncement) {
                    HyteraAnnouncement ha = (HyteraAnnouncement)csbk;
                    if (this.mBrand == null) {
                        this.mBrand = BRAND_HYTERA_TIER_3_TRUNKING;
                    }
                    if (this.mDMRNetwork == null) {
                        this.mDMRNetwork = ha.getSystemIdentityCode().getNetwork();
                    }
                    if (this.mDMRSite == null) {
                        this.mDMRSite = ha.getSystemIdentityCode().getSite();
                    }
                    if (this.mTier3Model == null) {
                        this.mTier3Model = ha.getSystemIdentityCode().getModel();
                    }
                    if (this.mBrand == null || this.mBrand != BRAND_HYTERA_TIER_3_TRUNKING) {
                        this.mBrand = BRAND_HYTERA_TIER_3_TRUNKING;
                    }
                }
                if (!(csbk instanceof HyteraAdjacentSiteInformation) || this.mTier3NeighborSites.containsKey(site = ((Integer)(hasi = (HyteraAdjacentSiteInformation)csbk).getNeighborSystemIdentityCode().getSite().getValue()).intValue())) break;
                this.mTier3NeighborSites.put(site, hasi);
                break;
            }
            case MOTOROLA_CAPMAX_ALOHA: {
                if (!(csbk instanceof CapacityMaxAloha)) break;
                if (this.mDMRNetwork == null || this.mDMRSite == null) {
                    SystemIdentityCode sic = ((CapacityMaxAloha)csbk).getSystemIdentityCode();
                    if (this.mDMRNetwork == null) {
                        this.mDMRNetwork = sic.getNetwork();
                    }
                    if (this.mDMRSite == null) {
                        this.mDMRSite = sic.getSite();
                    }
                    if (this.mTier3Model == null) {
                        this.mTier3Model = sic.getModel();
                    }
                }
                if (this.mBrand != null && this.mBrand == BRAND_MOTOROLA_CAPACITY_MAX_TIER_3_TRUNKING) break;
                this.mBrand = BRAND_MOTOROLA_CAPACITY_MAX_TIER_3_TRUNKING;
                break;
            }
            case MOTOROLA_CONPLUS_NEIGHBOR_REPORT: {
                if (this.mNeighborSites.isEmpty() && csbk instanceof ConnectPlusNeighborReport) {
                    ConnectPlusNeighborReport cpnr = (ConnectPlusNeighborReport)csbk;
                    this.mNeighborSites.addAll(cpnr.getNeighbors());
                }
                if (this.mBrand != null && this.mBrand == BRAND_MOTOROLA_CONNECT_PLUS) break;
                this.mBrand = BRAND_MOTOROLA_CONNECT_PLUS;
                break;
            }
            case MOTOROLA_CONPLUS_VOICE_CHANNEL_USER: {
                if (csbk instanceof ConnectPlusVoiceChannelUser) {
                    DMRLsn channel = ((ConnectPlusVoiceChannelUser)csbk).getChannel();
                    this.addDmrChannel(channel);
                }
                if (this.mBrand != null) break;
                this.mBrand = BRAND_MOTOROLA_CONNECT_PLUS;
            }
        }
        if (this.mColorCode == null) {
            this.mColorCode = csbk.getSlotType().getColorCode();
        }
    }

    private void addDmrChannel(DMRChannel dmrChannel) {
        this.mObservedChannelMap.put((Integer)dmrChannel.getValue(), dmrChannel);
    }

    public void reset() {
        this.mColorCode = null;
        this.mDMRNetwork = null;
        this.mDMRSite = null;
        this.mNeighborSites.clear();
        this.mTier3NeighborSites.clear();
        this.mObservedChannelMap.clear();
    }

    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary - Decoder: DMR ");
        sb.append("\n\nBrand:").append(this.mBrand == null ? BRAND_STANDARD : this.mBrand);
        if (this.mDMRNetwork != null) {
            sb.append("\nNetwork:").append(this.mDMRNetwork);
        }
        if (this.mDMRSite != null) {
            sb.append("\nSite:").append(this.mDMRSite);
        }
        if (this.mTier3Model != null) {
            sb.append("\nNetwork Model: ").append((Object)this.mTier3Model);
        }
        if (!this.mObservedChannelMap.isEmpty()) {
            sb.append("\nObserved Logical Slot Numbers (LSN):");
            ArrayList<Integer> lsns = new ArrayList<Integer>(this.mObservedChannelMap.keySet());
            Collections.sort(lsns);
            for (Integer lsn : lsns) {
                DMRChannel channel = this.mObservedChannelMap.get(lsn);
                if (channel == null) continue;
                sb.append("\n\t").append(channel);
                double frequency = channel.getDownlinkFrequency();
                if (frequency != 0.0) {
                    frequency /= 1000000.0;
                }
                sb.append(" ").append(frequency).append(" MHz");
            }
        }
        if (!this.mNeighborSites.isEmpty()) {
            sb.append("\nNeighbor Sites\n");
            for (SiteIdentifier siteIdentifier : this.mNeighborSites) {
                sb.append("\tNeighbor: ").append(siteIdentifier).append("\n");
            }
            for (Map.Entry entry : this.mTier3NeighborSites.entrySet()) {
                AdjacentSiteInformation site = (AdjacentSiteInformation)entry.getValue();
                sb.append("\tNeighbor: ").append("Network:").append(site.getNeighborSystemIdentityCode().getNetwork());
                sb.append(" Site:").append(site.getNeighborSystemIdentityCode().getSite());
                sb.append(" ").append((Object)site.getNeighborSystemIdentityCode().getModel());
                sb.append(" ").append(site.getNeighborChannel()).append("\n");
            }
        }
        sb.append("\n\n");
        return sb.toString();
    }
}

