/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.DmrCrcMaskManager;
import io.github.dsheirer.module.decode.dmr.channel.ITimeslotFrequencyReceiver;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.DMRBurst;
import io.github.dsheirer.module.decode.dmr.message.data.IDLEMessage;
import io.github.dsheirer.module.decode.dmr.message.data.block.DataBlock;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Aloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Preamble;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.header.MBCHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.PacketSequenceHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.ProprietaryDataHeader;
import io.github.dsheirer.module.decode.dmr.message.data.header.UDTHeader;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FLCAssembler;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasAssembler;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.SLCAssembler;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.ShortLCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCAssembler;
import io.github.dsheirer.module.decode.dmr.message.data.mbc.MBCContinuationBlock;
import io.github.dsheirer.module.decode.dmr.message.data.packet.PacketSequenceAssembler;
import io.github.dsheirer.module.decode.dmr.message.data.terminator.Terminator;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceEMBMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceSuperFrameProcessor;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRMessageProcessor
implements Listener<IMessage> {
    private static final Logger mLog = LoggerFactory.getLogger(DMRMessageProcessor.class);
    private DecodeConfigDMR mConfigDMR;
    private VoiceSuperFrameProcessor mSuperFrameProcessor1 = new VoiceSuperFrameProcessor();
    private VoiceSuperFrameProcessor mSuperFrameProcessor2 = new VoiceSuperFrameProcessor();
    private FLCAssembler mFLCAssemblerTimeslot1 = new FLCAssembler(1);
    private FLCAssembler mFLCAssemblerTimeslot2 = new FLCAssembler(2);
    private MBCAssembler mMBCAssembler = new MBCAssembler();
    private PacketSequenceAssembler mPacketSequenceAssembler;
    private SLCAssembler mSLCAssembler = new SLCAssembler();
    private TalkerAliasAssembler mTalkerAliasAssembler = new TalkerAliasAssembler();
    private Listener<IMessage> mMessageListener;
    private Map<Integer, TimeslotFrequency> mTimeslotFrequencyMap = new TreeMap<Integer, TimeslotFrequency>();
    private DmrCrcMaskManager mCrcMaskManager = new DmrCrcMaskManager();

    public DMRMessageProcessor(DecodeConfigDMR config) {
        this.mConfigDMR = config;
        for (TimeslotFrequency timeslotFrequency : config.getTimeslotMap()) {
            this.mTimeslotFrequencyMap.put(timeslotFrequency.getNumber(), timeslotFrequency);
        }
        this.mPacketSequenceAssembler = new PacketSequenceAssembler();
    }

    @Override
    public void receive(IMessage message) {
        DMRBurst dmrBurst;
        FullLCMessage flc;
        if (message == null) {
            return;
        }
        if (!message.isValid() && message instanceof CSBKMessage) {
            CSBKMessage csbk = (CSBKMessage)message;
            this.mCrcMaskManager.check(csbk);
        }
        if (message instanceof FullLCMessage) {
            flc = (FullLCMessage)message;
            if (flc.getTimeslot() == 1) {
                this.mSuperFrameProcessor1.process(flc);
            } else {
                this.mSuperFrameProcessor2.process(flc);
            }
        } else if (message instanceof VoiceMessage) {
            VoiceMessage voiceMessage = (VoiceMessage)message;
            if (voiceMessage.getTimeslot() == 1) {
                this.mSuperFrameProcessor1.process(voiceMessage);
            } else {
                this.mSuperFrameProcessor2.process(voiceMessage);
            }
        } else if (message instanceof DMRBurst && (dmrBurst = (DMRBurst)message).isValid()) {
            if (dmrBurst.getTimeslot() == 1) {
                this.mSuperFrameProcessor1.reset();
            } else {
                this.mSuperFrameProcessor2.reset();
            }
        }
        if (message instanceof ITimeslotFrequencyReceiver) {
            ITimeslotFrequencyReceiver receiver = (ITimeslotFrequencyReceiver)((Object)message);
            int[] lcns = receiver.getLogicalChannelNumbers();
            ArrayList<TimeslotFrequency> timeslotFrequencies = new ArrayList<TimeslotFrequency>();
            for (int lcn : lcns) {
                if (!this.mTimeslotFrequencyMap.containsKey(lcn)) continue;
                timeslotFrequencies.add(this.mTimeslotFrequencyMap.get(lcn));
            }
            if (!timeslotFrequencies.isEmpty()) {
                receiver.apply(timeslotFrequencies);
            }
        }
        this.dispatch(message);
        if (message instanceof VoiceEMBMessage) {
            VoiceEMBMessage voice = (VoiceEMBMessage)message;
            if (message.getTimeslot() == 1) {
                flco = this.mFLCAssemblerTimeslot1.process(voice.getEMB().getLCSS(), voice.getFLCFragment(), message.getTimestamp());
                this.receive(flco);
            } else {
                flco = this.mFLCAssemblerTimeslot2.process(voice.getEMB().getLCSS(), voice.getFLCFragment(), message.getTimestamp());
                this.receive(flco);
            }
            if (voice.hasCACH()) {
                CACH cach = voice.getCACH();
                ShortLCMessage slco = this.mSLCAssembler.process(cach.getLCSS(), cach.getPayload(), message.getTimestamp());
                this.receive(slco);
            }
        } else if (message instanceof DMRBurst) {
            DMRBurst dmrBurst2 = (DMRBurst)message;
            if (dmrBurst2.hasCACH()) {
                CACH cach = dmrBurst2.getCACH();
                ShortLCMessage slco = this.mSLCAssembler.process(cach.getLCSS(), cach.getPayload(), message.getTimestamp());
                this.receive(slco);
            }
            if (message instanceof MBCHeader) {
                this.mMBCAssembler.process((MBCHeader)message);
            } else if (message instanceof MBCContinuationBlock) {
                this.receive(this.mMBCAssembler.process((MBCContinuationBlock)message));
            } else {
                this.mMBCAssembler.reset(message.getTimeslot());
            }
            if (message instanceof Preamble) {
                Preamble preamble = (Preamble)message;
                this.mPacketSequenceAssembler.process(preamble);
            } else if (message instanceof PacketSequenceHeader) {
                PacketSequenceHeader header = (PacketSequenceHeader)message;
                this.mPacketSequenceAssembler.process(header);
            } else if (message instanceof ProprietaryDataHeader) {
                ProprietaryDataHeader header = (ProprietaryDataHeader)message;
                this.mPacketSequenceAssembler.process(header);
            } else if (message instanceof DataBlock) {
                DataBlock dataBlock = (DataBlock)message;
                this.mPacketSequenceAssembler.process(dataBlock);
            } else if (message instanceof UDTHeader) {
                UDTHeader header = (UDTHeader)message;
                this.mPacketSequenceAssembler.process(header);
            } else if ((message instanceof IDLEMessage || message instanceof Aloha || message instanceof Announcement) && message.getTimeslot() != 0) {
                this.mPacketSequenceAssembler.dispatchPacketSequence(message.getTimeslot());
            }
            if (message.isValid() && (message instanceof IDLEMessage || message instanceof Terminator)) {
                this.mTalkerAliasAssembler.reset(message.getTimeslot());
            }
        }
        if (message instanceof FullLCMessage && (flc = (FullLCMessage)message).getOpcode().isTalkerAliasOpcode() && message.isValid()) {
            this.dispatch(this.mTalkerAliasAssembler.process(flc));
        }
    }

    private void dispatch(IMessage message) {
        if (this.mMessageListener != null && message != null) {
            if (this.mConfigDMR.isUseCompressedTalkgroups()) {
                try {
                    for (Identifier identifier : message.getIdentifiers()) {
                        if (!(identifier instanceof DMRTalkgroup)) continue;
                        DMRTalkgroup talkgroup = (DMRTalkgroup)identifier;
                        talkgroup.setCompressed(true);
                    }
                }
                catch (Exception e) {
                    mLog.error("Error applying compressed talkgroup setting to identifier in message: " + String.valueOf(message) + " [" + String.valueOf(message.getClass()) + "]");
                }
            }
            this.mMessageListener.receive(message);
        }
    }

    public void dispose() {
        this.mMessageListener = null;
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
        this.mPacketSequenceAssembler.setMessageListener(listener);
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
        this.mPacketSequenceAssembler.setMessageListener(null);
    }
}

