/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.SyncLossMessage;
import io.github.dsheirer.module.decode.dmr.DMRBurstFramer;
import io.github.dsheirer.module.decode.dmr.DMRMessageProcessor;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.IDMRBurstDetectListener;
import io.github.dsheirer.module.decode.dmr.audio.DMRCallSequenceRecorder;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.DMRBurst;
import io.github.dsheirer.module.decode.dmr.message.DMRMessageFactory;
import io.github.dsheirer.module.decode.dmr.message.data.packet.DMRPacketMessage;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Identity;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.record.binary.BinaryReader;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRMessageFramer
implements Listener<Dibit>,
IDMRBurstDetectListener {
    private static final Logger mLog = LoggerFactory.getLogger(DMRMessageFramer.class);
    private static final double DMR_BIT_RATE = 9600.0;
    private DMRBurstFramer mBurstFramer;
    private Listener<IMessage> mMessageListener;
    private ISyncDetectListener mSyncDetectListener;
    private long mCurrentTime = System.currentTimeMillis();

    public DMRMessageFramer(IPhaseLockedLoop phaseLockedLoop) {
        this.mBurstFramer = new DMRBurstFramer(this, phaseLockedLoop);
    }

    public DMRMessageFramer() {
        this(null);
    }

    public void setSyncDetectListener(ISyncDetectListener syncDetectListener) {
        this.mSyncDetectListener = syncDetectListener;
    }

    private long getTimestamp() {
        return this.mCurrentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.mCurrentTime = currentTime;
    }

    private void updateBitsProcessed(int bitsProcessed) {
        if (bitsProcessed > 0) {
            this.mCurrentTime += (long)((double)bitsProcessed / 9600.0 * 1000.0);
        }
    }

    public void setListener(Listener<IMessage> messageListener) {
        this.mMessageListener = messageListener;
    }

    @Override
    public void receive(Dibit dibit) {
        this.mBurstFramer.receive(dibit);
    }

    @Override
    public void receive(ByteBuffer buffer) {
        for (byte value : buffer.array()) {
            for (int x = 0; x <= 3; ++x) {
                this.receive(Dibit.parse(value, x));
            }
        }
    }

    @Override
    public void burstDetected(CorrectedBinaryMessage message, DMRSyncPattern syncPattern, int timeslot) {
        DMRBurst dmrMessage;
        this.updateBitsProcessed(288);
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncDetected(0);
        }
        CACH cach = null;
        if (syncPattern.hasCACH()) {
            cach = CACH.getCACH(message);
        }
        if (this.mMessageListener != null && (dmrMessage = DMRMessageFactory.create(syncPattern, message, cach, this.getTimestamp(), timeslot)) != null) {
            this.mMessageListener.receive(dmrMessage);
        }
    }

    @Override
    public void syncLost(int bitsProcessed, int timeslot) {
        this.updateBitsProcessed(bitsProcessed);
        this.dispatchSyncLoss(bitsProcessed, timeslot);
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncLost(bitsProcessed);
        }
    }

    private void dispatchSyncLoss(int bitsProcessed, int timeslot) {
        if (bitsProcessed > 0 && this.mMessageListener != null) {
            this.mMessageListener.receive(new SyncLossMessage(this.getTimestamp(), bitsProcessed, Protocol.DMR, timeslot));
        }
    }

    public static void main(String[] args) {
        String path = "/media/denny/T7 Shield/Recordings/DMR/";
        String file = path + "Texas_Dallas_Aerowave_Capacity_Plus_Multi_Site/20200716_210133_9600BPS_DMR_Aerowave_Technologies_Dallas_LCN_2.bits";
        final DecodeConfigDMR config = new DecodeConfigDMR();
        final Broadcaster<IMessage> messageBroadcaster = new Broadcaster<IMessage>();
        final MessageListener messageListener = new MessageListener();
        messageBroadcaster.addListener(messageListener);
        LrrpProcessor lrrpProcessor = new LrrpProcessor();
        messageBroadcaster.addListener(lrrpProcessor);
        DMRCallSequenceRecorder ambeRecorder = new DMRCallSequenceRecorder(new UserPreferences(), 123456789L, "Denny System", "Denny Site");
        messageBroadcaster.addListener(ambeRecorder);
        boolean multi = false;
        if (multi) {
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(path, new String[0]), "*.bits");
                stream.forEach(new Consumer<Path>(){

                    @Override
                    public void accept(Path path) {
                        mLog.info("Processing: " + path.toString());
                        DMRMessageFramer messageFramer = new DMRMessageFramer(null);
                        DMRMessageProcessor messageProcessor = new DMRMessageProcessor(config);
                        messageFramer.setListener(messageProcessor);
                        messageProcessor.setMessageListener(messageBroadcaster);
                        try (BinaryReader reader = new BinaryReader(path, 200);){
                            while (reader.hasNext()) {
                                ByteBuffer buffer = reader.next();
                                messageFramer.receive(buffer);
                            }
                        }
                        catch (Exception ioe) {
                            ioe.printStackTrace();
                        }
                        if (!messageListener.hasData()) {
                            // empty if block
                        }
                        messageListener.reset();
                        System.out.println("TS0 VOICE:" + messageListener.mTS0Count + " TS1 VOICE:" + messageListener.mTS1Count);
                        messageListener.mTS0Count = 0;
                        messageListener.mTS1Count = 0;
                    }
                });
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            lrrpProcessor.log();
        } else {
            DMRMessageFramer messageFramer = new DMRMessageFramer(null);
            DMRMessageProcessor messageProcessor = new DMRMessageProcessor(config);
            messageFramer.setListener(messageProcessor);
            messageProcessor.setMessageListener(messageBroadcaster);
            try (BinaryReader reader = new BinaryReader(Path.of(file, new String[0]), 200);){
                while (reader.hasNext()) {
                    ByteBuffer buffer = reader.next();
                    messageFramer.receive(buffer);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            System.out.println("TS0 VOICE:" + messageListener.mTS0Count + " TS1 VOICE:" + messageListener.mTS1Count);
            messageListener.mTS0Count = 0;
            messageListener.mTS1Count = 0;
        }
    }

    public static class MessageListener
    implements Listener<IMessage> {
        private boolean mHasDMRData = false;
        public int mTS0Count = 0;
        public int mTS1Count = 0;

        @Override
        public void receive(IMessage message) {
            DMRPacketMessage dpm;
            IPacket iPacket;
            if (message instanceof DMRBurst && ((DMRBurst)message).hasCACH()) {
                CACH cach = ((DMRBurst)message).getCACH();
                mLog.info(cach.toString() + " TS:" + message.getTimeslot() + " " + message.toString());
            } else {
                mLog.info("     TS:" + message.getTimeslot() + " " + message.toString());
            }
            if (message instanceof DMRPacketMessage && (iPacket = (dpm = (DMRPacketMessage)message).getPacket()) instanceof LRRPPacket) {
                LRRPPacket lrrp = (LRRPPacket)iPacket;
                mLog.info("LRRP: " + lrrp.toString());
                mLog.info("MESSAGE: " + lrrp.getMessage().toHexString());
            }
        }

        public boolean hasData() {
            return this.mHasDMRData;
        }

        public void reset() {
            this.mHasDMRData = true;
        }
    }

    public static class LrrpProcessor
    implements Listener<IMessage> {
        private Map<Integer, List<LRRPPacket>> mLrrpMap = new HashMap<Integer, List<LRRPPacket>>();

        @Override
        public void receive(IMessage message) {
            DMRPacketMessage dpm;
            IPacket iPacket;
            if (message instanceof DMRPacketMessage && (iPacket = (dpm = (DMRPacketMessage)message).getPacket()) instanceof LRRPPacket) {
                LRRPPacket lrrp = (LRRPPacket)iPacket;
                this.process(lrrp);
            }
        }

        public void process(LRRPPacket lrrpPacket) {
            Identity identity = LrrpProcessor.getIdentity(lrrpPacket);
            if (identity != null) {
                List<LRRPPacket> packets = this.mLrrpMap.get(identity.getID());
                if (packets == null) {
                    packets = new ArrayList<LRRPPacket>();
                }
                packets.add(lrrpPacket);
                this.mLrrpMap.put(identity.getID(), packets);
            }
        }

        public void log() {
            mLog.info("*************** DUMPING LRRP PACKETS****************************");
            ArrayList<Integer> ids = new ArrayList<Integer>(this.mLrrpMap.keySet());
            Collections.sort(ids);
            for (Integer id : ids) {
                mLog.info("");
                mLog.info("###################### ID: " + id + " ###################################");
                List<LRRPPacket> packets = this.mLrrpMap.get(id);
                for (LRRPPacket lrrp : packets) {
                    mLog.info("PACKET: " + lrrp.toString());
                    mLog.info("MESSAGE: " + lrrp.getMessage().toHexString());
                }
            }
        }

        private static Identity getIdentity(LRRPPacket packet) {
            for (Token token : packet.getTokens()) {
                if (!(token instanceof Identity)) continue;
                return (Identity)token;
            }
            return null;
        }
    }
}

