/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.state.ChangeChannelTimeoutEvent;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.channel.state.TimeslotDecoderState;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConfigurationChangeNotification;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.integer.IntegerIdentifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.dmr.DMRNetworkConfigurationMonitor;
import io.github.dsheirer.module.decode.dmr.DMRNetworkConfigurationPreloadData;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.DMRTrafficChannelManager;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.channel.DMRChannel;
import io.github.dsheirer.module.decode.dmr.channel.DMRLsn;
import io.github.dsheirer.module.decode.dmr.event.DMRDecodeEvent;
import io.github.dsheirer.module.decode.dmr.identifier.DMRTalkgroup;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import io.github.dsheirer.module.decode.dmr.message.data.DataMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.CSBKMessage;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.hytera.HyteraTrafficChannelTalkerStatus;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityMaxAloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusNeighbors;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.CapacityPlusSiteStatus;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusDataChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.motorola.ConnectPlusVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Aloha;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.Protect;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.acknowledge.Acknowledge;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.Ahoy;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.ServiceRadioCheck;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.ahoy.StunReviveKill;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.Announcement;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.announcement.VoteNowAdvice;
import io.github.dsheirer.module.decode.dmr.message.data.csbk.standard.grant.ChannelGrant;
import io.github.dsheirer.module.decode.dmr.message.data.header.HeaderMessage;
import io.github.dsheirer.module.decode.dmr.message.data.header.hytera.HyteraDataEncryptionHeader;
import io.github.dsheirer.module.decode.dmr.message.data.lc.LCMessage;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.EncryptionParameters;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.GPSInformation;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.GroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.TalkerAliasComplete;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.UnitToUnitVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera.HyteraGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.hytera.HyteraUnitToUnitVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.CapacityPlusEncryptedVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.CapacityPlusWideAreaVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.motorola.MotorolaGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.dmr.message.data.lc.shorty.CapacityPlusRestChannel;
import io.github.dsheirer.module.decode.dmr.message.data.packet.DMRPacketMessage;
import io.github.dsheirer.module.decode.dmr.message.data.packet.UDTShortMessageService;
import io.github.dsheirer.module.decode.dmr.message.data.terminator.Terminator;
import io.github.dsheirer.module.decode.dmr.message.type.CapacityPlusServiceOptions;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceOptions;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceEMBMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.EmbeddedParameters;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.ShortBurst;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.hytera.rrs.HyteraRrsPacket;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraUnknownPacket;
import io.github.dsheirer.module.decode.ip.hytera.shortdata.HyteraShortDataPacket;
import io.github.dsheirer.module.decode.ip.hytera.sms.HyteraSmsPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacket;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.source.tuner.channel.rotation.AddChannelRotationActiveStateRequest;
import io.github.dsheirer.util.PacketUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRDecoderState
extends TimeslotDecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(DMRDecoderState.class);
    private static final long MAX_VALID_CALL_DURATION_MS = 30000L;
    private Channel mChannel;
    private DMRNetworkConfigurationMonitor mNetworkConfigurationMonitor;
    private DMRTrafficChannelManager mTrafficChannelManager;
    private DecodeEvent mCurrentCallEvent;
    private long mCurrentFrequency;
    private boolean mIgnoreCRCChecksums;
    private Map<DMRChannel, DecodeEvent> mDetectedCallEventsMap = new HashMap<DMRChannel, DecodeEvent>();
    private static final AddChannelRotationActiveStateRequest CAPACITY_PLUS_ACTIVE_STATE_REQUEST = new AddChannelRotationActiveStateRequest(State.ACTIVE);

    public DMRDecoderState(Channel channel, int timeslot, DMRTrafficChannelManager trafficChannelManager) {
        super(timeslot);
        this.mChannel = channel;
        this.mTrafficChannelManager = trafficChannelManager;
        if (timeslot == 1) {
            this.mNetworkConfigurationMonitor = new DMRNetworkConfigurationMonitor(channel);
        }
        if (channel.getDecodeConfiguration() instanceof DecodeConfigDMR) {
            this.mIgnoreCRCChecksums = ((DecodeConfigDMR)channel.getDecodeConfiguration()).getIgnoreCRCChecksums();
        }
    }

    private boolean hasTrafficChannelManager() {
        return this.mTrafficChannelManager != null;
    }

    @Subscribe
    public void channelChanged(ChannelConfigurationChangeNotification notification) {
        if (notification.getChannel().isTrafficChannel()) {
            this.mTrafficChannelManager = null;
        }
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.DMR;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetState();
        this.mCurrentFrequency = 0L;
        this.mDetectedCallEventsMap.clear();
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.closeCurrentCallEvent(System.currentTimeMillis());
    }

    @Override
    public void receive(IMessage message) {
        if (message.getTimeslot() == this.getTimeslot()) {
            if (message instanceof VoiceMessage) {
                this.processVoice((VoiceMessage)message);
            } else if (message instanceof DataMessage) {
                this.processData((DataMessage)message);
            } else if ((message.isValid() || this.mIgnoreCRCChecksums) && message instanceof LCMessage) {
                this.processLinkControl((LCMessage)message, false);
            } else if (message.isValid() && message instanceof DMRPacketMessage) {
                this.processPacket((DMRPacketMessage)message);
            } else if (message instanceof UDTShortMessageService) {
                UDTShortMessageService sms = (UDTShortMessageService)message;
                this.processSMS(sms);
            } else if (message instanceof DMRMessage) {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
            }
        } else if ((message.isValid() || this.mIgnoreCRCChecksums) && message.getTimeslot() == 0 && message instanceof LCMessage) {
            this.processLinkControl((LCMessage)message, false);
        }
        if (this.mNetworkConfigurationMonitor != null && (message.isValid() || this.mIgnoreCRCChecksums) && message instanceof DMRMessage) {
            this.mNetworkConfigurationMonitor.process((DMRMessage)message);
        }
    }

    private void updateRestChannel(DMRChannel restChannel) {
        if (this.mChannel.isStandardChannel() && this.mCurrentFrequency > 0L && restChannel.getDownlinkFrequency() > 0L && restChannel.getDownlinkFrequency() != this.mCurrentFrequency && this.mTrafficChannelManager != null) {
            this.mTrafficChannelManager.convertToTrafficChannel(this.mChannel, this.mCurrentFrequency, restChannel, this.mNetworkConfigurationMonitor);
        }
    }

    @Subscribe
    public void preload(DMRNetworkConfigurationPreloadData preloadData) {
        if (this.getTimeslot() == 1 && preloadData.hasData()) {
            this.mNetworkConfigurationMonitor = (DMRNetworkConfigurationMonitor)preloadData.getData();
        }
    }

    private void processSMS(UDTShortMessageService sms) {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.DATA, this.getTimeslot()));
        DecodeEvent smsEvent = DMRDecodeEvent.builder(DecodeEventType.SMS, sms.getTimestamp()).details("MESSAGE: " + sms.getSMS()).identifiers(new IdentifierCollection(sms.getIdentifiers())).timeslot(this.getTimeslot()).build();
        this.broadcast(smsEvent);
    }

    private void processPacket(DMRPacketMessage packet) {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.DATA, this.getTimeslot()));
        IPacket iPacket = packet.getPacket();
        if (iPacket instanceof HyteraSmsPacket) {
            HyteraSmsPacket hyteraSmsPacket = (HyteraSmsPacket)iPacket;
            mic = new MutableIdentifierCollection(packet.getIdentifiers());
            ((MutableIdentifierCollection)mic).remove(Form.RADIO);
            ((MutableIdentifierCollection)mic).remove(Form.TALKGROUP);
            ((MutableIdentifierCollection)mic).update(hyteraSmsPacket.getSource());
            ((MutableIdentifierCollection)mic).update(hyteraSmsPacket.getDestination());
            DecodeEvent smsEvent = DMRDecodeEvent.builder(DecodeEventType.SMS, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details("SMS:" + hyteraSmsPacket.getSMS()).build();
            this.broadcast(smsEvent);
        } else {
            mic = packet.getPacket();
            if (mic instanceof HyteraRrsPacket) {
                HyteraRrsPacket rrs = (HyteraRrsPacket)mic;
                mic = new MutableIdentifierCollection(packet.getIdentifiers());
                StringBuilder sb = new StringBuilder();
                sb.append("HYTERA RRS REGISTER RADIO:");
                sb.append(rrs.getDestination());
                DecodeEvent shortDataEvent = DMRDecodeEvent.builder(DecodeEventType.RADIO_REGISTRATION_SERVICE, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details(sb.toString()).build();
                this.broadcast(shortDataEvent);
            } else {
                mic = packet.getPacket();
                if (mic instanceof HyteraShortDataPacket) {
                    HyteraShortDataPacket hsdp = (HyteraShortDataPacket)mic;
                    mic = new MutableIdentifierCollection(packet.getIdentifiers());
                    StringBuilder sb = new StringBuilder();
                    sb.append("HYTERA");
                    if (hsdp.getPacketSequence().isEncrypted()) {
                        HyteraDataEncryptionHeader hdeh = (HyteraDataEncryptionHeader)hsdp.getPacketSequence().getProprietaryDataHeader();
                        sb.append(" ENCRYPTED ALGORITHM:").append((Object)hdeh.getAlgorithm());
                        sb.append(" KEY:").append(hdeh.getKeyId());
                        sb.append(" IV:").append(hdeh.getIV());
                    }
                    sb.append(" SHORT DATA:").append(hsdp.getMessage().toHexString());
                    DecodeEvent shortDataEvent = DMRDecodeEvent.builder(DecodeEventType.RADIO_REGISTRATION_SERVICE, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details(sb.toString()).build();
                    this.broadcast(shortDataEvent);
                } else {
                    mic = packet.getPacket();
                    if (mic instanceof HyteraUnknownPacket) {
                        HyteraUnknownPacket hyteraUnknownPacket = (HyteraUnknownPacket)mic;
                        mic = new MutableIdentifierCollection(packet.getIdentifiers());
                        DecodeEvent unknownTokenEvent = DMRDecodeEvent.builder(DecodeEventType.UNKNOWN_PACKET, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details("HYTERA LONG DATA UNK TOKEN MSG:" + hyteraUnknownPacket.getHeader().toString()).build();
                        this.broadcast(unknownTokenEvent);
                    } else {
                        mic = packet.getPacket();
                        if (mic instanceof ARSPacket) {
                            ARSPacket ars = (ARSPacket)mic;
                            mic = new MutableIdentifierCollection(packet.getIdentifiers());
                            DecodeEvent shortDataEvent = DMRDecodeEvent.builder(DecodeEventType.RADIO_REGISTRATION_SERVICE, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details(ars.toString()).build();
                            this.broadcast(shortDataEvent);
                        } else {
                            mic = packet.getPacket();
                            if (mic instanceof LRRPPacket) {
                                LRRPPacket lrrp = (LRRPPacket)mic;
                                mic = new MutableIdentifierCollection(packet.getIdentifiers());
                                DecodeEvent shortDataEvent = DMRDecodeEvent.builder(DecodeEventType.LRRP, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details(lrrp.toString()).build();
                                this.broadcast(shortDataEvent);
                            } else {
                                mic = packet.getPacket();
                                if (mic instanceof XCMPPacket) {
                                    XCMPPacket xcmp = (XCMPPacket)mic;
                                    mic = new MutableIdentifierCollection(packet.getIdentifiers());
                                    DecodeEvent shortDataEvent = DMRDecodeEvent.builder(DecodeEventType.XCMP, packet.getTimestamp()).identifiers((IdentifierCollection)mic).timeslot(this.getTimeslot()).details(xcmp.toString()).build();
                                    this.broadcast(shortDataEvent);
                                } else {
                                    DecodeEvent packetEvent = DMRDecodeEvent.builder(DecodeEventType.DATA_PACKET, packet.getTimestamp()).identifiers(new IdentifierCollection(packet.getIdentifiers())).timeslot(this.getTimeslot()).details(packet.toString()).build();
                                    this.broadcast(packetEvent);
                                }
                            }
                        }
                    }
                }
            }
        }
        GeoPosition geoPosition = PacketUtil.extractGeoPosition(packet.getPacket());
        if (geoPosition != null) {
            PlottableDecodeEvent plottableDecodeEvent = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, packet.getTimestamp()).channel(this.getCurrentChannel()).identifiers(new IdentifierCollection(packet.getIdentifiers())).protocol(Protocol.LRRP).location(geoPosition).build();
            this.broadcast(plottableDecodeEvent);
        }
    }

    private void processVoice(VoiceMessage message) {
        EmbeddedParameters embedded;
        ShortBurst shortBurst;
        VoiceEMBMessage voiceEmb;
        if (message.getSyncPattern().isMobileSyncPattern()) {
            if (message.getSyncPattern().isDirectMode()) {
                this.updateCurrentCall(DecodeEventType.CALL, "DIRECT MODE", message.getTimestamp());
            } else {
                this.updateCurrentCall(DecodeEventType.CALL, "REPEATER", message.getTimestamp());
            }
            this.getIdentifierCollection().update(DMRTalkgroup.create(this.getTimeslot()));
        } else {
            this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CALL, this.getTimeslot()));
        }
        if (message.getSyncPattern() == DMRSyncPattern.BS_VOICE_FRAME_F && message instanceof VoiceEMBMessage && (voiceEmb = (VoiceEMBMessage)message).hasEmbeddedParameters() && (shortBurst = (embedded = voiceEmb.getEmbeddedParameters()).getShortBurst()) instanceof io.github.dsheirer.module.decode.dmr.message.voice.embedded.EncryptionParameters) {
            io.github.dsheirer.module.decode.dmr.message.voice.embedded.EncryptionParameters arc4 = (io.github.dsheirer.module.decode.dmr.message.voice.embedded.EncryptionParameters)shortBurst;
            this.updateEncryptedCall(arc4, true, voiceEmb.getTimestamp());
        }
    }

    private void processHeader(HeaderMessage header) {
        switch (header.getSlotType().getDataType()) {
            case VOICE_HEADER: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.CALL, this.getTimeslot()));
                break;
            }
            case PI_HEADER: 
            case MBC_HEADER: 
            case DATA_HEADER: 
            case USB_DATA: 
            case MBC_ENC_HEADER: 
            case DATA_ENC_HEADER: 
            case CHANNEL_CONTROL_ENC_HEADER: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.DATA, this.getTimeslot()));
            }
        }
        LCMessage lc = header.getLCMessage();
        if (lc.isValid()) {
            this.processLinkControl(lc, false);
        }
    }

    private void processData(DataMessage message) {
        switch (message.getSlotType().getDataType()) {
            case CSBK: {
                if (!message.isValid() && !this.mIgnoreCRCChecksums || !(message instanceof CSBKMessage)) break;
                this.processCSBK((CSBKMessage)message);
                break;
            }
            case VOICE_HEADER: {
                if (!(message instanceof HeaderMessage)) break;
                this.processVoiceHeader((HeaderMessage)message);
                break;
            }
            case USB_DATA: {
                break;
            }
            case PI_HEADER: 
            case MBC_HEADER: 
            case DATA_HEADER: 
            case MBC_ENC_HEADER: 
            case DATA_ENC_HEADER: 
            case CHANNEL_CONTROL_ENC_HEADER: {
                if (!(message instanceof HeaderMessage)) break;
                this.processHeader((HeaderMessage)message);
                break;
            }
            case SLOT_IDLE: {
                this.closeCurrentCallEvent(message.getTimestamp());
                this.getIdentifierCollection().remove(IdentifierClass.USER);
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
                break;
            }
            case TLC: {
                if (!(message instanceof Terminator)) break;
                this.processTerminator((Terminator)message);
                break;
            }
            case RATE_1_OF_2_DATA: 
            case RATE_3_OF_4_DATA: 
            case RATE_1_DATA: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.DATA, this.getTimeslot()));
                break;
            }
            default: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
            }
        }
    }

    private void processTerminator(Terminator terminator) {
        this.closeCurrentCallEvent(terminator.getTimestamp());
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
        LCMessage lcMessage = terminator.getLCMessage();
        if (lcMessage.isValid()) {
            this.processLinkControl(lcMessage, true);
        }
    }

    private void processVoiceHeader(HeaderMessage voiceHeader) {
        LCMessage lcMessage = voiceHeader.getLCMessage();
        if (lcMessage.isValid()) {
            this.processLinkControl(lcMessage, false);
        }
    }

    private void processCSBK(CSBKMessage csbk) {
        switch (csbk.getOpcode()) {
            case STANDARD_ACKNOWLEDGE_RESPONSE_INBOUND_PAYLOAD: 
            case STANDARD_ACKNOWLEDGE_RESPONSE_OUTBOUND_PAYLOAD: {
                if (csbk instanceof Acknowledge) {
                    this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.RESPONSE, ((Acknowledge)csbk).getReason().toString()));
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
                break;
            }
            case STANDARD_ACKNOWLEDGE_RESPONSE_INBOUND_TSCC: 
            case STANDARD_ACKNOWLEDGE_RESPONSE_OUTBOUND_TSCC: {
                if (csbk instanceof Acknowledge) {
                    this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.RESPONSE, ((Acknowledge)csbk).getReason().toString()));
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case STANDARD_AHOY: {
                if (csbk instanceof Ahoy) {
                    switch (((Ahoy)csbk).getServiceKind()) {
                        case AUTHENTICATE_REGISTER_RADIO_CHECK_SERVICE: {
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.COMMAND, DecodeEventType.REGISTER.toString()));
                            break;
                        }
                        case CANCEL_CALL_SERVICE: {
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.COMMAND, "CANCEL CALL"));
                            break;
                        }
                        case SUPPLEMENTARY_SERVICE: {
                            if (!(csbk instanceof StunReviveKill)) break;
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.COMMAND, ((StunReviveKill)csbk).getCommand() + " RADIO"));
                            break;
                        }
                        case FULL_DUPLEX_MS_TO_MS_PACKET_CALL_SERVICE: 
                        case FULL_DUPLEX_MS_TO_MS_VOICE_CALL_SERVICE: 
                        case INDIVIDUAL_VOICE_CALL_SERVICE: 
                        case INDIVIDUAL_PACKET_CALL_SERVICE: 
                        case INDIVIDUAL_UDT_SHORT_DATA_CALL_SERVICE: 
                        case TALKGROUP_PACKET_CALL_SERVICE: 
                        case TALKGROUP_UDT_SHORT_DATA_CALL_SERVICE: 
                        case TALKGROUP_VOICE_CALL_SERVICE: {
                            if (!(csbk instanceof ServiceRadioCheck)) break;
                            ServiceRadioCheck src = (ServiceRadioCheck)csbk;
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.RADIO_CHECK, src.getServiceDescription() + " SERVICE FOR " + (src.isTalkgroupTarget() ? "TALKGROUP" : "RADIO")));
                        }
                    }
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case STANDARD_ALOHA: {
                Aloha aloha;
                if (csbk instanceof Aloha && (aloha = (Aloha)csbk).hasRadioIdentifier()) {
                    this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.RESPONSE, "Aloha Acknowledge"));
                    this.resetState();
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case STANDARD_ANNOUNCEMENT: {
                if (csbk instanceof Announcement) {
                    switch (((Announcement)csbk).getAnnouncementType()) {
                        case MASS_REGISTRATION: {
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.REGISTER, "MASS REGISTRATION"));
                            break;
                        }
                        case VOTE_NOW_ADVICE: {
                            if (!(csbk instanceof VoteNowAdvice)) break;
                            this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.COMMAND, "VOTE NOW FOR " + String.valueOf(((VoteNowAdvice)csbk).getVotedSystemIdentityCode())));
                        }
                    }
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case STANDARD_CLEAR: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.END, State.CALL, this.getTimeslot()));
                this.resetState();
                break;
            }
            case STANDARD_PREAMBLE: {
                this.getIdentifierCollection().update(csbk.getIdentifiers());
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.DATA, this.getTimeslot()));
                break;
            }
            case STANDARD_PROTECT: {
                if (csbk instanceof Protect) {
                    this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.COMMAND, "PROTECT: " + String.valueOf((Object)((Protect)csbk).getProtectKind())));
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CALL, this.getTimeslot()));
                break;
            }
            case HYTERA_08_ANNOUNCEMENT: 
            case HYTERA_68_ANNOUNCEMENT: 
            case HYTERA_68_XPT_SITE_STATE: {
                break;
            }
            case HYTERA_08_TRAFFIC_CHANNEL_TALKER_STATUS: {
                if (!(csbk instanceof HyteraTrafficChannelTalkerStatus)) break;
                HyteraTrafficChannelTalkerStatus status = (HyteraTrafficChannelTalkerStatus)csbk;
                if (status.isChannelActive()) {
                    this.getIdentifierCollection().update(status.getIdentifiers());
                    this.updateCurrentCall(DecodeEventType.CALL_GROUP, "HYTERA TIER 3 CALL", status.getTimestamp());
                    break;
                }
                this.getIdentifierCollection().remove(Role.FROM);
                this.getIdentifierCollection().update(status.getDestinationRadio());
                break;
            }
            case MOTOROLA_CAPPLUS_NEIGHBOR_REPORT: {
                if (!(csbk instanceof CapacityPlusNeighbors)) break;
                this.updateRestChannel(((CapacityPlusNeighbors)csbk).getRestChannel());
                break;
            }
            case MOTOROLA_CAPPLUS_SITE_STATUS: {
                if (!(csbk instanceof CapacityPlusSiteStatus)) break;
                CapacityPlusSiteStatus cpss = (CapacityPlusSiteStatus)csbk;
                this.getInterModuleEventBus().post((Object)CAPACITY_PLUS_ACTIVE_STATE_REQUEST);
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
                this.updateRestChannel(cpss.getRestChannel());
                break;
            }
            case MOTOROLA_CONPLUS_NEIGHBOR_REPORT: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case STANDARD_DUPLEX_PRIVATE_DATA_CHANNEL_GRANT: 
            case STANDARD_PRIVATE_DATA_CHANNEL_GRANT_SINGLE_ITEM: 
            case STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_MULTI_ITEM: 
            case STANDARD_TALKGROUP_DATA_CHANNEL_GRANT_SINGLE_ITEM: {
                if (!(csbk instanceof ChannelGrant)) break;
                ChannelGrant dataGrant = (ChannelGrant)csbk;
                DMRChannel channel = dataGrant.getChannel();
                if (this.hasTrafficChannelManager()) {
                    IdentifierCollection mergedIdentifiers = this.getMergedIdentifierCollection(csbk.getIdentifiers());
                    this.mTrafficChannelManager.processChannelGrant(channel, mergedIdentifiers, csbk.getOpcode(), csbk.getTimestamp(), csbk.isEncrypted());
                    break;
                }
                DecodeEvent event = this.mDetectedCallEventsMap.get(channel);
                if (this.isStale(event, csbk.getTimestamp(), csbk.getIdentifiers())) {
                    event = this.getDecodeEvent(csbk, DecodeEventType.DATA_CALL, channel, new IdentifierCollection(csbk.getIdentifiers()));
                    this.mDetectedCallEventsMap.put(channel, event);
                } else {
                    event.end(csbk.getTimestamp());
                }
                this.broadcast(event);
                break;
            }
            case STANDARD_BROADCAST_TALKGROUP_VOICE_CHANNEL_GRANT: 
            case STANDARD_TALKGROUP_VOICE_CHANNEL_GRANT: {
                if (!(csbk instanceof ChannelGrant)) break;
                ChannelGrant tgGrant = (ChannelGrant)csbk;
                DMRChannel channel = tgGrant.getChannel();
                if (this.hasTrafficChannelManager()) {
                    IdentifierCollection mergedIdentifiers = this.getMergedIdentifierCollection(csbk.getIdentifiers());
                    this.mTrafficChannelManager.processChannelGrant(channel, mergedIdentifiers, csbk.getOpcode(), csbk.getTimestamp(), csbk.isEncrypted());
                    break;
                }
                DecodeEvent event = this.mDetectedCallEventsMap.get(channel);
                if (this.isStale(event, csbk.getTimestamp(), csbk.getIdentifiers())) {
                    event = this.getDecodeEvent(csbk, DecodeEventType.CALL_GROUP, channel, new IdentifierCollection(csbk.getIdentifiers()));
                    this.mDetectedCallEventsMap.put(channel, event);
                } else {
                    event.end(csbk.getTimestamp());
                }
                this.broadcast(event);
                break;
            }
            case STANDARD_DUPLEX_PRIVATE_VOICE_CHANNEL_GRANT: 
            case STANDARD_PRIVATE_VOICE_CHANNEL_GRANT: {
                if (!(csbk instanceof ChannelGrant)) break;
                ChannelGrant channelGrant = (ChannelGrant)csbk;
                DMRChannel channel = channelGrant.getChannel();
                if (this.hasTrafficChannelManager()) {
                    IdentifierCollection mergedIdentifiers = this.getMergedIdentifierCollection(csbk.getIdentifiers());
                    this.mTrafficChannelManager.processChannelGrant(channel, mergedIdentifiers, csbk.getOpcode(), csbk.getTimestamp(), csbk.isEncrypted());
                    break;
                }
                DecodeEvent event = this.mDetectedCallEventsMap.get(channel);
                if (this.isStale(event, csbk.getTimestamp(), csbk.getIdentifiers())) {
                    event = this.getDecodeEvent(csbk, DecodeEventType.CALL_UNIT_TO_UNIT, channel, new IdentifierCollection(csbk.getIdentifiers()));
                    this.mDetectedCallEventsMap.put(channel, event);
                } else {
                    event.end(csbk.getTimestamp());
                }
                this.broadcast(event);
                break;
            }
            case MOTOROLA_CAPMAX_ALOHA: {
                CapacityMaxAloha cmAloha;
                if (csbk instanceof CapacityMaxAloha && (cmAloha = (CapacityMaxAloha)csbk).hasRadioIdentifier()) {
                    this.broadcast(this.getDecodeEvent(csbk, DecodeEventType.RESPONSE, "Aloha Acknowledge"));
                    this.resetState();
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case MOTOROLA_CONPLUS_DATA_CHANNEL_GRANT: {
                if (csbk instanceof ConnectPlusDataChannelGrant) {
                    ConnectPlusDataChannelGrant cpdcg = (ConnectPlusDataChannelGrant)csbk;
                    DMRLsn channel = cpdcg.getChannel();
                    if (this.hasTrafficChannelManager()) {
                        IdentifierCollection mergedIdentifiers = this.getMergedIdentifierCollection(csbk.getIdentifiers());
                        this.mTrafficChannelManager.processChannelGrant(channel, mergedIdentifiers, csbk.getOpcode(), csbk.getTimestamp(), csbk.isEncrypted());
                    } else {
                        DecodeEvent event = this.mDetectedCallEventsMap.get(channel);
                        if (this.isStale(event, csbk.getTimestamp(), csbk.getIdentifiers())) {
                            event = this.getDecodeEvent(csbk, DecodeEventType.DATA_CALL, channel, new IdentifierCollection(csbk.getIdentifiers()));
                            this.mDetectedCallEventsMap.put(channel, event);
                        } else {
                            event.end(csbk.getTimestamp());
                        }
                        this.broadcast(event);
                    }
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case MOTOROLA_CONPLUS_REGISTRATION_REQUEST: {
                DecodeEvent event = DMRDecodeEvent.builder(DecodeEventType.REQUEST, csbk.getTimestamp()).details("Registration Request").identifiers(new IdentifierCollection(csbk.getIdentifiers())).timeslot(this.getTimeslot()).build();
                this.broadcast(event);
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case MOTOROLA_CONPLUS_REGISTRATION_RESPONSE: {
                DecodeEvent regRespEvent = DMRDecodeEvent.builder(DecodeEventType.RESPONSE, csbk.getTimestamp()).details("Registration Response").identifiers(new IdentifierCollection(csbk.getIdentifiers())).timeslot(this.getTimeslot()).build();
                this.broadcast(regRespEvent);
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case MOTOROLA_CONPLUS_VOICE_CHANNEL_USER: {
                if (csbk instanceof ConnectPlusVoiceChannelUser) {
                    ConnectPlusVoiceChannelUser cpvcu = (ConnectPlusVoiceChannelUser)csbk;
                    DMRLsn channel = cpvcu.getChannel();
                    if (this.hasTrafficChannelManager()) {
                        IdentifierCollection mergedIdentifiers = this.getMergedIdentifierCollection(csbk.getIdentifiers());
                        this.mTrafficChannelManager.processChannelGrant(channel, mergedIdentifiers, csbk.getOpcode(), csbk.getTimestamp(), csbk.isEncrypted());
                    } else {
                        DecodeEvent detectedEvent = this.mDetectedCallEventsMap.get(channel);
                        if (this.isStale(detectedEvent, csbk.getTimestamp(), csbk.getIdentifiers())) {
                            detectedEvent = this.getDecodeEvent(csbk, DecodeEventType.CALL_GROUP, channel, new IdentifierCollection(csbk.getIdentifiers()));
                            this.mDetectedCallEventsMap.put(channel, detectedEvent);
                        } else {
                            detectedEvent.end(csbk.getTimestamp());
                        }
                        this.broadcast(detectedEvent);
                    }
                }
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            case MOTOROLA_CONPLUS_TALKGROUP_AFFILIATION: {
                DecodeEvent affiliateEvent = DMRDecodeEvent.builder(DecodeEventType.AFFILIATE, csbk.getTimestamp()).details("TALKGROUP AFFILIATION").identifiers(new IdentifierCollection(csbk.getIdentifiers())).timeslot(this.getTimeslot()).build();
                this.broadcast(affiliateEvent);
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CONTROL, this.getTimeslot()));
                break;
            }
            default: {
                this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.ACTIVE, this.getTimeslot()));
            }
        }
    }

    private DecodeEvent getDecodeEvent(CSBKMessage csbk, DecodeEventType decodeEventType, DMRChannel channel, IdentifierCollection identifierCollection) {
        return DMRDecodeEvent.builder(decodeEventType, csbk.getTimestamp()).channel(channel).details(csbk.getOpcode().getLabel()).identifiers(identifierCollection).timeslot(this.getTimeslot()).build();
    }

    private DecodeEvent getDecodeEvent(CSBKMessage csbk, DecodeEventType decodeEventType, String details) {
        return DMRDecodeEvent.builder(decodeEventType, csbk.getTimestamp()).identifiers(new IdentifierCollection(csbk.getIdentifiers())).timeslot(this.getTimeslot()).details(details).build();
    }

    private IdentifierCollection getMergedIdentifierCollection(List<Identifier> identifiers) {
        MutableIdentifierCollection mic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
        mic.remove(IdentifierClass.USER);
        mic.update(identifiers);
        return mic;
    }

    private boolean isStale(DecodeEvent event, long timestamp, List<Identifier> currentIdentifiers) {
        if (event == null || timestamp - event.getTimeStart() > 30000L) {
            return true;
        }
        return !this.isSameCall(event.getIdentifierCollection(), currentIdentifiers);
    }

    private boolean isSameCall(IdentifierCollection identifierCollection, List<Identifier> identifiers) {
        IntegerIdentifier to = null;
        IntegerIdentifier from = null;
        for (Identifier identifier : identifierCollection.getIdentifiers(IdentifierClass.USER, Role.TO)) {
            if (!(identifier instanceof IntegerIdentifier)) continue;
            to = (IntegerIdentifier)identifier;
            break;
        }
        for (Identifier identifier : identifierCollection.getIdentifiers(IdentifierClass.USER, Role.FROM)) {
            if (!(identifier instanceof IntegerIdentifier)) continue;
            from = (IntegerIdentifier)identifier;
            break;
        }
        if (to == null || from == null) {
            return false;
        }
        boolean toMatch = false;
        boolean fromMatch = false;
        for (Identifier identifier : identifiers) {
            if (identifier.getRole() == Role.TO && identifier instanceof IntegerIdentifier && ((IntegerIdentifier)identifier).getValue() == to.getValue()) {
                toMatch = true;
                continue;
            }
            if (identifier.getRole() != Role.FROM || !(identifier instanceof IntegerIdentifier) || ((IntegerIdentifier)identifier).getValue() != from.getValue()) continue;
            fromMatch = true;
        }
        return toMatch & fromMatch;
    }

    private void processLinkControl(LCMessage message, boolean isTerminator) {
        switch (message.getOpcode()) {
            case FULL_ENCRYPTION_PARAMETERS: {
                if (!(message instanceof EncryptionParameters)) break;
                EncryptionParameters ep = (EncryptionParameters)message;
                if (this.mCurrentCallEvent == null) break;
                this.mCurrentCallEvent.setDetails(ep.getDetails());
                break;
            }
            case SHORT_CAPACITY_PLUS_REST_CHANNEL_NOTIFICATION: {
                if (!(message instanceof CapacityPlusRestChannel)) break;
                this.updateRestChannel(((CapacityPlusRestChannel)message).getRestChannel());
                break;
            }
            case FULL_CAPACITY_PLUS_ENCRYPTED_VOICE_CHANNEL_USER: {
                if (!(message instanceof CapacityPlusEncryptedVoiceChannelUser)) break;
                CapacityPlusEncryptedVoiceChannelUser cpgvcu = (CapacityPlusEncryptedVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(cpgvcu.getTalkgroup());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                CapacityPlusServiceOptions serviceOptions = cpgvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP, ((ServiceOptions)serviceOptions).toString(), message.getTimestamp());
                break;
            }
            case FULL_MOTOROLA_GROUP_VOICE_CHANNEL_USER: {
                if (!(message instanceof MotorolaGroupVoiceChannelUser)) break;
                MotorolaGroupVoiceChannelUser cpgvcu = (MotorolaGroupVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(cpgvcu.getTalkgroup());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                CapacityPlusServiceOptions serviceOptions = cpgvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP, ((ServiceOptions)serviceOptions).toString(), message.getTimestamp());
                break;
            }
            case FULL_CAPACITY_PLUS_WIDE_AREA_VOICE_CHANNEL_USER: {
                if (!(message instanceof CapacityPlusWideAreaVoiceChannelUser)) break;
                CapacityPlusWideAreaVoiceChannelUser cpuo4 = (CapacityPlusWideAreaVoiceChannelUser)message;
                this.updateRestChannel(cpuo4.getRestChannel());
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(cpuo4.getTalkgroup());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                break;
            }
            case FULL_HYTERA_GROUP_VOICE_CHANNEL_USER: {
                if (!(message instanceof HyteraGroupVoiceChannelUser)) break;
                HyteraGroupVoiceChannelUser hgvcu = (HyteraGroupVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(hgvcu.getTalkgroup());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                ServiceOptions serviceOptions = hgvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP, serviceOptions.toString(), message.getTimestamp());
                break;
            }
            case FULL_HYTERA_TERMINATOR: 
            case FULL_STANDARD_TERMINATOR_DATA: {
                this.getIdentifierCollection().update(message.getIdentifiers());
                break;
            }
            case FULL_HYTERA_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                if (!(message instanceof HyteraUnitToUnitVoiceChannelUser)) break;
                HyteraUnitToUnitVoiceChannelUser huuvcu = (HyteraUnitToUnitVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(huuvcu.getTargetRadio());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                ServiceOptions serviceOptions = huuvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED : DecodeEventType.CALL_UNIT_TO_UNIT, serviceOptions.toString(), message.getTimestamp());
                break;
            }
            case FULL_STANDARD_GROUP_VOICE_CHANNEL_USER: {
                if (!(message instanceof GroupVoiceChannelUser)) break;
                GroupVoiceChannelUser gvcu = (GroupVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(gvcu.getTalkgroup());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                ServiceOptions serviceOptions = gvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP, serviceOptions.toString(), message.getTimestamp());
                break;
            }
            case FULL_STANDARD_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                if (!(message instanceof UnitToUnitVoiceChannelUser)) break;
                UnitToUnitVoiceChannelUser uuvcu = (UnitToUnitVoiceChannelUser)message;
                if (isTerminator) {
                    this.getIdentifierCollection().remove(Role.FROM);
                    this.getIdentifierCollection().update(uuvcu.getTargetRadio());
                    break;
                }
                this.getIdentifierCollection().update(message.getIdentifiers());
                ServiceOptions serviceOptions = uuvcu.getServiceOptions();
                this.updateCurrentCall(serviceOptions.isEncrypted() ? DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED : DecodeEventType.CALL_UNIT_TO_UNIT, serviceOptions.toString(), message.getTimestamp());
                break;
            }
            case FULL_STANDARD_GPS_INFO: {
                if (!(message instanceof GPSInformation)) break;
                GPSInformation gpsInformation = (GPSInformation)message;
                PlottableDecodeEvent plottableGPS = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, message.getTimestamp()).channel(this.getCurrentChannel()).details("LOCATION:" + String.valueOf(gpsInformation.getGPSLocation())).identifiers(new IdentifierCollection(this.getIdentifierCollection().getIdentifiers())).protocol(Protocol.DMR).location(gpsInformation.getPosition()).build();
                this.broadcast(plottableGPS);
                break;
            }
            case FULL_STANDARD_TALKER_ALIAS_COMPLETE: {
                TalkerAliasComplete tac;
                if (!(message instanceof TalkerAliasComplete) || !(tac = (TalkerAliasComplete)message).hasTalkerAliasIdentifier()) break;
                this.getIdentifierCollection().update(tac.getTalkerAliasIdentifier());
            }
        }
    }

    private void updateEncryptedCall(io.github.dsheirer.module.decode.dmr.message.voice.embedded.EncryptionParameters encryptionParameters, boolean isGroup, long timestamp) {
        if (this.mCurrentCallEvent != null) {
            Object details = this.mCurrentCallEvent.getDetails();
            if (details == null) {
                details = encryptionParameters.toString();
            } else if (!((String)details).contains(encryptionParameters.toString()) && !((String)details).contains("ENCRYPTION")) {
                details = (String)details + " " + String.valueOf(encryptionParameters);
            }
            this.mCurrentCallEvent.setDetails((String)details);
        } else {
            this.mCurrentCallEvent = DMRDecodeEvent.builder(isGroup ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_ENCRYPTED, timestamp).channel(this.getCurrentChannel()).details(encryptionParameters.toString()).identifiers(this.getIdentifierCollection().copyOf()).timeslot(this.getTimeslot()).build();
            this.broadcast(this.mCurrentCallEvent);
        }
    }

    private void updateCurrentCall(DecodeEventType type, String details, long timestamp) {
        DecoderStateEvent.Event event;
        DecoderStateEvent.Event event2 = event = this.mCurrentCallEvent == null ? DecoderStateEvent.Event.START : DecoderStateEvent.Event.CONTINUATION;
        if (this.mCurrentCallEvent == null) {
            this.mCurrentCallEvent = DMRDecodeEvent.builder(type, timestamp).channel(this.getCurrentChannel()).details(details).identifiers(this.getIdentifierCollection().copyOf()).timeslot(this.getTimeslot()).build();
            this.broadcast(this.mCurrentCallEvent);
        } else {
            if (this.mCurrentCallEvent.getDetails() == null) {
                this.mCurrentCallEvent.setDetails(details);
            }
            this.mCurrentCallEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
        }
        if (type == DecodeEventType.CALL_GROUP_ENCRYPTED || type == DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED) {
            this.broadcast(new DecoderStateEvent((Object)this, event, State.ENCRYPTED, this.getTimeslot()));
        } else {
            this.broadcast(new DecoderStateEvent((Object)this, event, State.CALL, this.getTimeslot()));
        }
    }

    private void closeCurrentCallEvent(long timestamp) {
        if (this.mCurrentCallEvent != null) {
            this.mCurrentCallEvent.end(timestamp);
            this.broadcast(this.mCurrentCallEvent);
            this.mCurrentCallEvent = null;
        }
    }

    @Override
    public String getActivitySummary() {
        if (this.mNetworkConfigurationMonitor != null) {
            return this.mNetworkConfigurationMonitor.getActivitySummary();
        }
        return "";
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                if (this.mNetworkConfigurationMonitor == null) break;
                this.mNetworkConfigurationMonitor.reset();
                break;
            }
            case NOTIFICATION_SOURCE_FREQUENCY: {
                this.mCurrentFrequency = event.getFrequency();
                if (!this.hasTrafficChannelManager()) break;
                this.mTrafficChannelManager.setCurrentControlFrequency(this.mCurrentFrequency);
                break;
            }
        }
    }

    @Override
    public void start() {
        if (this.mChannel.isTrafficChannel()) {
            this.broadcast(new ChangeChannelTimeoutEvent((Object)this, Channel.ChannelType.TRAFFIC, 1000L, this.getTimeslot()));
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void stop() {
    }
}

