/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.DibitDelayBuffer;
import io.github.dsheirer.dsp.symbol.QPSKCarrierLock;
import io.github.dsheirer.module.decode.dmr.DMRSyncDetector;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.IDMRBurstDetectListener;
import io.github.dsheirer.module.decode.dmr.TimeslotAlignmentTracker;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.sample.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMRBurstFramer
implements Listener<Dibit> {
    private static final Logger mLog = LoggerFactory.getLogger(DMRBurstFramer.class);
    private static final int DMR_SYMBOL_RATE = 4800;
    private static final double PLL_PHASE_CORRECTION_90_DEGREES = 1200.0;
    private static final double PLL_PHASE_CORRECTION_180_DEGREES = 2400.0;
    private static final int BURST_DIBIT_START_TS1 = 0;
    private static final int BURST_DIBIT_START_TS2 = 144;
    private static final int BURST_DIBIT_LENGTH = 144;
    private static final int TWO_TIMESLOT_DIBIT_LENGTH = 288;
    private static final int SYNC_DIBIT_OFFSET_TS1 = 66;
    private static final int SYNC_DIBIT_OFFSET_TS2 = 210;
    private static final int SYNC_DIBIT_LENGTH = 24;
    private static final int MAX_STREAMING_SYNC_DETECT_BIT_ERRORS = 4;
    private static final int MAX_EXPLICIT_SYNC_DETECT_BIT_ERRORS = 6;
    private static final int SYNC_LOSS_MESSAGE_THRESHOLD = 5088;
    private DibitDelayBuffer mMessageBuffer = new DibitDelayBuffer(288);
    private DibitDelayBuffer mSyncDelayBuffer = new DibitDelayBuffer(54);
    private boolean mSynchronized = false;
    private int mDibitCounter = 0;
    private DMRSyncDetector mSyncDetectorTimeslot1 = new DMRSyncDetector(4, 6);
    private DMRSyncDetector mSyncDetectorTimeslot2 = new DMRSyncDetector(4, 6);
    private SyncTracker mSyncTrackerTimeslot1 = new SyncTracker(this);
    private SyncTracker mSyncTrackerTimeslot2 = new SyncTracker(this);
    private TimeslotAlignmentTracker mTimeslotAlignmentTracker = new TimeslotAlignmentTracker();
    private IDMRBurstDetectListener mBurstDetectListener;
    private IPhaseLockedLoop mPhaseLockedLoop;

    public DMRBurstFramer(IDMRBurstDetectListener listener, IPhaseLockedLoop phaseLockedLoop) {
        this.mBurstDetectListener = listener;
        this.mPhaseLockedLoop = phaseLockedLoop;
    }

    @Override
    public void receive(Dibit dibit) {
        ++this.mDibitCounter;
        this.mMessageBuffer.put(dibit);
        dibit = this.mSyncDelayBuffer.getAndPut(dibit);
        if (this.mSynchronized) {
            if (this.mDibitCounter >= 288) {
                if (this.mDibitCounter > 288) {
                    this.processSyncLossDibits(this.mDibitCounter - 288, 0);
                }
                this.dispatch();
            }
        } else {
            this.mSyncDetectorTimeslot2.add(dibit);
            if (this.mSyncDetectorTimeslot2.hasSync()) {
                this.dispatch();
            } else if (this.mDibitCounter >= 5088) {
                this.processSyncLossDibits(4800, 0);
            }
        }
    }

    private void dispatch() {
        if (this.mBurstDetectListener != null) {
            if (this.mDibitCounter > 288) {
                this.processSyncLossDibits(this.mDibitCounter - 288, 0);
            }
            this.mSyncDetectorTimeslot1.setCurrentSyncValue(this.getSyncValue(66));
            this.mSyncDetectorTimeslot2.setCurrentSyncValue(this.getSyncValue(210));
            this.mSyncTrackerTimeslot1.update(this.mSyncDetectorTimeslot1.getSyncPattern(), this.mSyncDetectorTimeslot1.getCarrierLock());
            this.mSyncTrackerTimeslot2.update(this.mSyncDetectorTimeslot2.getSyncPattern(), this.mSyncDetectorTimeslot2.getCarrierLock());
            CorrectedBinaryMessage burst1 = null;
            CorrectedBinaryMessage burst2 = null;
            CACH cach1 = null;
            CACH cach2 = null;
            if (this.mSyncTrackerTimeslot1.hasSync() && this.mSyncTrackerTimeslot1.hasCarrierMisAlignment() || this.mSyncTrackerTimeslot2.hasSync() && this.mSyncTrackerTimeslot2.hasCarrierMisAlignment()) {
                if (this.mSyncTrackerTimeslot1.hasCarrierMisAlignment()) {
                    this.repairPLLMisalignment(0, this.mSyncTrackerTimeslot1.getCarrierLock());
                    this.repairPLLMisalignment(144, this.mSyncTrackerTimeslot1.getCarrierLock());
                } else {
                    this.repairPLLMisalignment(0, this.mSyncTrackerTimeslot2.getCarrierLock());
                    this.repairPLLMisalignment(144, this.mSyncTrackerTimeslot2.getCarrierLock());
                }
            }
            if (this.mSyncTrackerTimeslot1.hasSync()) {
                burst1 = this.mMessageBuffer.getMessage(0, 144);
                burst1.incrementCorrectedBitCount(this.mSyncDetectorTimeslot1.getPatternMatchBitErrorCount());
                if (this.mSyncTrackerTimeslot1.getSyncPattern().hasCACH()) {
                    cach1 = CACH.getCACH(burst1);
                }
            }
            if (this.mSyncTrackerTimeslot2.hasSync()) {
                burst2 = this.mMessageBuffer.getMessage(144, 144);
                burst2.incrementCorrectedBitCount(this.mSyncDetectorTimeslot2.getPatternMatchBitErrorCount());
                if (this.mSyncTrackerTimeslot2.getSyncPattern().hasCACH()) {
                    cach2 = CACH.getCACH(burst2);
                }
            }
            this.mTimeslotAlignmentTracker.update(cach1, cach2, this.mSyncDetectorTimeslot1.getSyncPattern(), this.mSyncDetectorTimeslot2.getSyncPattern());
            if (this.mTimeslotAlignmentTracker.hasSufficientData()) {
                if (this.mTimeslotAlignmentTracker.isAligned()) {
                    if (burst1 != null) {
                        this.mBurstDetectListener.burstDetected(burst1, this.mSyncTrackerTimeslot1.getSyncPattern(), 1);
                        this.mDibitCounter -= 144;
                    } else {
                        this.processSyncLossDibits(144, 1);
                    }
                    if (burst2 != null) {
                        this.mBurstDetectListener.burstDetected(burst2, this.mSyncTrackerTimeslot2.getSyncPattern(), 2);
                        this.mDibitCounter -= 144;
                    } else {
                        this.processSyncLossDibits(144, 2);
                    }
                    this.mSynchronized = this.mSyncTrackerTimeslot1.hasSync() || this.mSyncTrackerTimeslot2.hasSync();
                } else {
                    if (burst1 != null) {
                        this.mBurstDetectListener.burstDetected(burst1, this.mSyncTrackerTimeslot1.getSyncPattern(), 2);
                        this.mDibitCounter -= 144;
                        this.mSyncTrackerTimeslot2.setSyncPattern(this.mSyncTrackerTimeslot1.getSyncPattern());
                    } else {
                        this.processSyncLossDibits(144, 2);
                        this.mSyncTrackerTimeslot2.reset();
                    }
                    this.mTimeslotAlignmentTracker.reset();
                    this.mSyncTrackerTimeslot1.reset();
                    this.mDibitCounter = 144;
                    this.mSynchronized = true;
                }
            } else {
                if (burst1 != null) {
                    DMRSyncPattern sync1 = this.mSyncTrackerTimeslot1.getSyncPattern();
                    if (sync1.isMobileStationSyncPattern() || sync1.isDirectModeTS1()) {
                        this.mBurstDetectListener.burstDetected(burst1, sync1, 1);
                    } else if (sync1.isDirectModeTS2()) {
                        this.mBurstDetectListener.burstDetected(burst1, sync1, 2);
                    } else {
                        this.mBurstDetectListener.burstDetected(burst1, sync1, 0);
                    }
                    this.mDibitCounter -= 144;
                } else {
                    this.processSyncLossDibits(144, 0);
                }
                if (burst2 != null) {
                    DMRSyncPattern sync2 = this.mSyncTrackerTimeslot2.getSyncPattern();
                    if (sync2.isMobileStationSyncPattern() || sync2.isDirectModeTS1()) {
                        this.mBurstDetectListener.burstDetected(burst2, sync2, 1);
                    } else if (sync2.isDirectModeTS2()) {
                        this.mBurstDetectListener.burstDetected(burst2, sync2, 2);
                    } else {
                        this.mBurstDetectListener.burstDetected(burst2, sync2, 0);
                    }
                    this.mDibitCounter -= 144;
                } else {
                    this.processSyncLossDibits(144, 0);
                }
                boolean bl = this.mSynchronized = this.mSyncTrackerTimeslot1.hasSync() || this.mSyncTrackerTimeslot2.hasSync();
            }
            if (!this.mSynchronized) {
                this.mTimeslotAlignmentTracker.reset();
                this.mSyncTrackerTimeslot1.reset();
                this.mSyncTrackerTimeslot2.reset();
            }
            if (this.mDibitCounter < 0) {
                this.mDibitCounter = 0;
            }
        }
    }

    private void repairPLLMisalignment(int offset, QPSKCarrierLock carrierLock) {
        int end = offset + 144;
        for (int x = offset; x < end; ++x) {
            Dibit misalignedDibit = this.mMessageBuffer.get(x);
            this.mMessageBuffer.set(x, carrierLock.correct(misalignedDibit));
        }
        if (this.mPhaseLockedLoop != null) {
            switch (carrierLock) {
                case PLUS_90: {
                    this.mPhaseLockedLoop.correctInversion(1200.0);
                    break;
                }
                case MINUS_90: {
                    this.mPhaseLockedLoop.correctInversion(-1200.0);
                    break;
                }
                case INVERTED: {
                    this.mPhaseLockedLoop.correctInversion(2400.0);
                }
            }
        }
    }

    public void reset() {
        this.mDibitCounter = 0;
        this.mMessageBuffer.reset();
        this.mSyncDelayBuffer.reset();
        this.mTimeslotAlignmentTracker.reset();
    }

    private long getSyncValue(int dibitOffset) {
        Dibit[] syncDibits = this.mMessageBuffer.getBuffer(dibitOffset, 24);
        long value = 0L;
        for (Dibit dibit : syncDibits) {
            value = Long.rotateLeft(value, 2);
            value += (long)dibit.getValue();
        }
        return value;
    }

    private void processSyncLossDibits(int dibitCount, int timeslot) {
        this.mDibitCounter -= dibitCount;
        if (this.mBurstDetectListener != null) {
            this.mBurstDetectListener.syncLost(dibitCount * 2, timeslot);
        }
    }

    public class SyncTracker {
        private DMRSyncPattern mSyncPattern = DMRSyncPattern.UNKNOWN;
        private QPSKCarrierLock mCarrierLock = QPSKCarrierLock.NORMAL;

        public SyncTracker(DMRBurstFramer this$0) {
        }

        public void update(DMRSyncPattern pattern, QPSKCarrierLock carrierLock) {
            if (pattern == DMRSyncPattern.UNKNOWN) {
                switch (this.mSyncPattern) {
                    case BASE_STATION_VOICE: {
                        this.mSyncPattern = DMRSyncPattern.BS_VOICE_FRAME_B;
                        break;
                    }
                    case BS_VOICE_FRAME_B: {
                        this.mSyncPattern = DMRSyncPattern.BS_VOICE_FRAME_C;
                        break;
                    }
                    case BS_VOICE_FRAME_C: {
                        this.mSyncPattern = DMRSyncPattern.BS_VOICE_FRAME_D;
                        break;
                    }
                    case BS_VOICE_FRAME_D: {
                        this.mSyncPattern = DMRSyncPattern.BS_VOICE_FRAME_E;
                        break;
                    }
                    case BS_VOICE_FRAME_E: {
                        this.mSyncPattern = DMRSyncPattern.BS_VOICE_FRAME_F;
                        break;
                    }
                    case MOBILE_STATION_VOICE: 
                    case DIRECT_MODE_VOICE_TIMESLOT_1: 
                    case DIRECT_MODE_VOICE_TIMESLOT_2: {
                        this.mSyncPattern = DMRSyncPattern.MS_VOICE_FRAME_B;
                        break;
                    }
                    case MS_VOICE_FRAME_B: {
                        this.mSyncPattern = DMRSyncPattern.MS_VOICE_FRAME_C;
                        break;
                    }
                    case MS_VOICE_FRAME_C: {
                        this.mSyncPattern = DMRSyncPattern.MS_VOICE_FRAME_D;
                        break;
                    }
                    case MS_VOICE_FRAME_D: {
                        this.mSyncPattern = DMRSyncPattern.MS_VOICE_FRAME_E;
                        break;
                    }
                    case MS_VOICE_FRAME_E: {
                        this.mSyncPattern = DMRSyncPattern.MS_VOICE_FRAME_F;
                        break;
                    }
                    default: {
                        this.mSyncPattern = pattern;
                        this.mCarrierLock = carrierLock;
                        break;
                    }
                }
            } else {
                this.mSyncPattern = pattern;
                this.mCarrierLock = carrierLock;
            }
        }

        public DMRSyncPattern getSyncPattern() {
            return this.mSyncPattern;
        }

        public void setSyncPattern(DMRSyncPattern pattern) {
            this.mSyncPattern = pattern;
        }

        public QPSKCarrierLock getCarrierLock() {
            return this.mCarrierLock;
        }

        public boolean hasCarrierMisAlignment() {
            return this.getCarrierLock() != QPSKCarrierLock.NORMAL;
        }

        public boolean hasSync() {
            return this.getSyncPattern() != DMRSyncPattern.UNKNOWN;
        }

        public void reset() {
            this.mSyncPattern = DMRSyncPattern.UNKNOWN;
        }
    }
}

