/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dcs;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dcs.DCSMessage;
import java.util.function.Function;

public class DCSMessageFilter
extends Filter<IMessage, String> {
    private static final String DCS_KEY = "DCS";
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public DCSMessageFilter() {
        super("DCS Messages");
        this.add(new FilterElement<String>(DCS_KEY));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof DCSMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(DCSMessageFilter dCSMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            return DCSMessageFilter.DCS_KEY;
        }
    }
}

