/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dcs;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.dcs.DCSIdentifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.dcs.DCSCode;
import io.github.dsheirer.protocol.Protocol;
import java.util.Collections;
import java.util.List;

public class DCSMessage
extends Message {
    private final DCSCode mDCSCode;

    public DCSMessage(DCSCode code, long timestamp) {
        super(timestamp);
        this.mDCSCode = code;
    }

    @Override
    public String toString() {
        return "Digital Coded Squelch (DCS) Detected: " + this.mDCSCode.toString();
    }

    public DCSCode getDCSCode() {
        return this.mDCSCode;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.DCS;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.singletonList(new DCSIdentifier(this.mDCSCode));
    }
}

