/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dcs;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.dcs.DCSCode;
import io.github.dsheirer.module.decode.dcs.DCSMessage;
import java.util.HashMap;
import java.util.Map;

public class DCSDecoderState
extends DecoderState {
    private Map<DCSCode, Integer> mDcsCodeCountsMap = new HashMap<DCSCode, Integer>();
    private DCSCode mCurrentCode = DCSCode.UNKNOWN;

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.DCS;
    }

    @Override
    public void receive(IMessage message) {
        if (message instanceof DCSMessage) {
            DCSMessage dcsMessage = (DCSMessage)message;
            this.mCurrentCode = dcsMessage.getDCSCode();
            if (!this.mDcsCodeCountsMap.containsKey((Object)this.mCurrentCode)) {
                this.mDcsCodeCountsMap.put(this.mCurrentCode, 1);
            } else {
                this.mDcsCodeCountsMap.put(this.mCurrentCode, this.mDcsCodeCountsMap.get((Object)this.mCurrentCode) + 1);
            }
            this.getIdentifierCollection().update(dcsMessage.getIdentifiers());
        }
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("=============================\n");
        sb.append("Decoder:\tDigital Coded Squelch (DCS)\n\n");
        if (this.mDcsCodeCountsMap.isEmpty()) {
            sb.append("   Detected Codes: (none)\n");
        } else {
            for (Map.Entry<DCSCode, Integer> entry : this.mDcsCodeCountsMap.entrySet()) {
                sb.append("   ").append((Object)entry.getKey()).append(" - Count: ").append(entry.getValue());
                if (entry.getKey().equals((Object)this.mCurrentCode)) {
                    sb.append(" - Current\n");
                    continue;
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void init() {
    }

    @Override
    public void stop() {
    }
}

