/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.analog;

import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.IDecoderStateEventProvider;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.decimate.DecimationFilterFactory;
import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.resample.RealResampler;
import io.github.dsheirer.dsp.fm.ISquelchingDemodulator;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.module.decode.PrimaryDecoder;
import io.github.dsheirer.module.decode.analog.DecodeConfigAnalog;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.sample.real.IRealBufferProvider;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SquelchingAnalogDecoder
extends PrimaryDecoder
implements ISourceEventListener,
ISourceEventProvider,
IComplexSamplesListener,
Listener<ComplexSamples>,
IRealBufferProvider,
IDecoderStateEventProvider {
    private static final Logger mLog = LoggerFactory.getLogger(SquelchingAnalogDecoder.class);
    private static final double DEMODULATED_AUDIO_SAMPLE_RATE = 8000.0;
    private IRealFilter mIBasebandFilter;
    private IRealFilter mQBasebandFilter;
    private IRealDecimationFilter mIDecimationFilter;
    private IRealDecimationFilter mQDecimationFilter;
    private ISquelchingDemodulator mDemodulator;
    private RealResampler mResampler;
    private SourceEventProcessor mSourceEventProcessor = new SourceEventProcessor();
    private Listener<float[]> mResampledBufferListener;
    private Listener<DecoderStateEvent> mDecoderStateEventListener;
    private double mChannelBandwidth;
    private double mOutputSampleRate = 8000.0;
    protected boolean mSquelch = true;

    public SquelchingAnalogDecoder(DecodeConfigAnalog config, ISquelchingDemodulator squelchingDemodulator) {
        super(config);
        this.mDemodulator = squelchingDemodulator;
        this.mChannelBandwidth = config.getBandwidth().getValue();
        this.mDemodulator.setSquelchThreshold(config.getSquelchThreshold());
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceEventProcessor;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    protected void broadcast(float[] demodulatedSamples) {
        if (this.mResampledBufferListener != null) {
            this.mResampledBufferListener.receive(demodulatedSamples);
        }
    }

    @Override
    public void setBufferListener(Listener<float[]> listener) {
        this.mResampledBufferListener = listener;
    }

    @Override
    public void removeBufferListener() {
        this.mResampledBufferListener = null;
    }

    @Override
    public Listener<ComplexSamples> getComplexSamplesListener() {
        return this;
    }

    @Override
    public void receive(ComplexSamples samples) {
        if (this.mIDecimationFilter == null || this.mQDecimationFilter == null) {
            throw new IllegalStateException("NBFM demodulator module must receive a sample rate change source event before it can process complex sample buffers");
        }
        float[] decimatedI = this.mIDecimationFilter.decimateReal(samples.i());
        float[] decimatedQ = this.mQDecimationFilter.decimateReal(samples.q());
        float[] filteredI = this.mIBasebandFilter.filter(decimatedI);
        float[] filteredQ = this.mQBasebandFilter.filter(decimatedQ);
        float[] demodulated = this.mDemodulator.demodulate(filteredI, filteredQ);
        if (this.mResampler != null) {
            if (this.mDemodulator.isSquelchChanged()) {
                if (this.mDemodulator.isMuted()) {
                    if (this.mSquelch) {
                        this.notifyIdle();
                    } else {
                        this.mSquelch = true;
                        this.notifyCallEnd();
                    }
                } else {
                    if (this.mSquelch) {
                        this.mSquelch = false;
                        this.notifyCallStart();
                    } else {
                        this.notifyCallContinuation();
                    }
                    this.mResampler.resample(demodulated);
                }
            } else if (this.mSquelch) {
                this.notifyIdle();
            } else {
                this.notifyCallContinuation();
                this.mResampler.resample(demodulated);
            }
        } else {
            this.notifyIdle();
        }
    }

    protected void notifyCallStart() {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.START, State.CALL, 0));
    }

    private void notifyCallContinuation() {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.CALL, 0));
    }

    private void notifyCallEnd() {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.END, State.CALL, 0));
    }

    private void notifyIdle() {
        this.broadcast(new DecoderStateEvent((Object)this, DecoderStateEvent.Event.CONTINUATION, State.IDLE, 0));
    }

    private void broadcast(DecoderStateEvent event) {
        if (this.mDecoderStateEventListener != null) {
            this.mDecoderStateEventListener.receive(event);
        }
    }

    @Override
    public void setDecoderStateListener(Listener<DecoderStateEvent> listener) {
        this.mDecoderStateEventListener = listener;
    }

    @Override
    public void removeDecoderStateListener() {
        this.mDecoderStateEventListener = null;
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mDemodulator.setSourceEventListener(listener);
    }

    @Override
    public void removeSourceEventListener() {
        this.mDemodulator.setSourceEventListener(null);
    }

    public class SourceEventProcessor
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            switch (sourceEvent.getEvent()) {
                case REQUEST_CURRENT_SQUELCH_THRESHOLD: 
                case REQUEST_CHANGE_SQUELCH_THRESHOLD: 
                case REQUEST_CURRENT_SQUELCH_AUTO_TRACK: 
                case REQUEST_CHANGE_SQUELCH_AUTO_TRACK: {
                    SquelchingAnalogDecoder.this.mDemodulator.receive(sourceEvent);
                    break;
                }
                case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                    if (SquelchingAnalogDecoder.this.mIBasebandFilter != null) {
                        SquelchingAnalogDecoder.this.mIBasebandFilter = null;
                        SquelchingAnalogDecoder.this.mQBasebandFilter = null;
                    }
                    double sampleRate = sourceEvent.getValue().doubleValue();
                    int decimationRate = 0;
                    double decimatedSampleRate = sampleRate;
                    if (sampleRate / 2.0 >= SquelchingAnalogDecoder.this.mChannelBandwidth * 2.0) {
                        decimationRate = 2;
                        while (sampleRate / (double)decimationRate / 2.0 >= SquelchingAnalogDecoder.this.mChannelBandwidth * 2.0) {
                            decimationRate *= 2;
                        }
                    }
                    if (decimationRate > 0) {
                        decimatedSampleRate /= (double)decimationRate;
                    }
                    SquelchingAnalogDecoder.this.mIDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimationRate);
                    SquelchingAnalogDecoder.this.mQDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimationRate);
                    if (decimatedSampleRate < 2.0 * SquelchingAnalogDecoder.this.mChannelBandwidth) {
                        throw new IllegalStateException(SquelchingAnalogDecoder.this.getDecoderType().name() + " demodulator with channel bandwidth [" + SquelchingAnalogDecoder.this.mChannelBandwidth + "] requires a channel sample rate of [" + 2.0 * SquelchingAnalogDecoder.this.mChannelBandwidth + "] - sample rate of [" + decimatedSampleRate + "] is not supported");
                    }
                    SquelchingAnalogDecoder.this.mDemodulator.setSampleRate((int)decimatedSampleRate);
                    int passBandStop = (int)(SquelchingAnalogDecoder.this.mChannelBandwidth * 0.8);
                    int stopBandStart = (int)SquelchingAnalogDecoder.this.mChannelBandwidth;
                    float[] coefficients = null;
                    FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(decimatedSampleRate * 2.0).gridDensity(16).oddLength(true).passBandCutoff(passBandStop).passBandAmplitude(1.0).passBandRipple(0.01).stopBandStart(stopBandStart).stopBandAmplitude(0.0).stopBandRipple(0.005).build();
                    try {
                        coefficients = FilterFactory.getTaps(specification);
                    }
                    catch (FilterDesignException fde) {
                        mLog.error("Couldn't design demodulator remez filter for sample rate [" + sampleRate + "] pass frequency [" + passBandStop + "] and stop frequency [" + stopBandStart + "] - will proceed using sinc (low-pass) filter");
                    }
                    if (coefficients == null) {
                        mLog.info("Unable to use remez filter designer for sample rate [" + decimatedSampleRate + "] pass band stop [" + passBandStop + "] and stop band start [" + stopBandStart + "] - will proceed using simple low pass filter design");
                        coefficients = FilterFactory.getLowPass(decimatedSampleRate, passBandStop, stopBandStart, 60, WindowType.HAMMING, true);
                    }
                    SquelchingAnalogDecoder.this.mIBasebandFilter = FilterFactory.getRealFilter(coefficients);
                    SquelchingAnalogDecoder.this.mQBasebandFilter = FilterFactory.getRealFilter(coefficients);
                    SquelchingAnalogDecoder.this.mResampler = new RealResampler(decimatedSampleRate, SquelchingAnalogDecoder.this.mOutputSampleRate, 4192, 512);
                    SquelchingAnalogDecoder.this.mResampler.setListener(resampled -> SquelchingAnalogDecoder.this.broadcast((float[])resampled));
                }
            }
        }
    }
}

