/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.analog;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.p25.identifier.channel.StandardChannel;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalogDecoderState
extends DecoderState
implements ISourceEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(AnalogDecoderState.class);
    private Listener<SourceEvent> mSourceEventListener = new SourceEventListener();
    private DecodeEvent mDecodeEvent;
    private IChannelDescriptor mChannelDescriptor = null;

    protected abstract Identifier getChannelNameIdentifier();

    protected abstract Identifier getTalkgroupIdentifier();

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.getIdentifierCollection().update(this.getChannelNameIdentifier());
                break;
            }
            case START: {
                if (event.getState() != State.CALL) break;
                this.startCallEvent();
                break;
            }
            case END: {
                if (event.getState() != State.CALL) break;
                this.endCallEvent();
                break;
            }
            case CONTINUATION: {
                if (event.getState() == State.CALL) {
                    this.continueCallEvent();
                    break;
                }
                this.endCallEvent();
            }
        }
    }

    private void startCallEvent() {
        this.getIdentifierCollection().update(this.getTalkgroupIdentifier());
        if (this.mDecodeEvent == null) {
            this.mDecodeEvent = DecodeEvent.builder(DecodeEventType.CALL, System.currentTimeMillis()).channel(this.mChannelDescriptor).details(this.getDecoderType().name()).identifiers(new IdentifierCollection(this.getIdentifierCollection().getIdentifiers())).build();
            this.broadcast(this.mDecodeEvent);
        }
    }

    private void continueCallEvent() {
        if (this.mDecodeEvent == null) {
            this.startCallEvent();
        }
        this.getIdentifierCollection().update(this.getTalkgroupIdentifier());
        this.mDecodeEvent.update(System.currentTimeMillis());
        this.broadcast(this.mDecodeEvent);
    }

    private void endCallEvent() {
        if (this.mDecodeEvent != null) {
            this.mDecodeEvent.end(System.currentTimeMillis());
            this.broadcast(this.mDecodeEvent);
            this.mDecodeEvent = null;
        }
        this.resetState();
    }

    @Override
    public void start() {
        this.getIdentifierCollection().update(this.getChannelNameIdentifier());
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    public void receive(IMessage t) {
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceEventListener;
    }

    private class SourceEventListener
    implements Listener<SourceEvent> {
        private SourceEventListener() {
        }

        @Override
        public void receive(SourceEvent sourceEvent) {
            if (sourceEvent.getEvent() == SourceEvent.Event.NOTIFICATION_FREQUENCY_CHANGE) {
                AnalogDecoderState.this.mChannelDescriptor = new StandardChannel(sourceEvent.getValue().longValue());
            }
        }
    }
}

