/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.am;

import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.string.SimpleStringIdentifier;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.am.AMTalkgroup;
import io.github.dsheirer.module.decode.am.DecodeConfigAM;
import io.github.dsheirer.module.decode.analog.AnalogDecoderState;

public class AMDecoderState
extends AnalogDecoderState {
    private String mChannelName;
    private Identifier mChannelNameIdentifier;
    private Identifier mTalkgroupIdentifier;

    public AMDecoderState(String channelName, DecodeConfigAM decodeConfig) {
        this.mChannelName = channelName != null && !channelName.isEmpty() ? channelName : "AM CHANNEL";
        this.mChannelNameIdentifier = new SimpleStringIdentifier(this.mChannelName, IdentifierClass.CONFIGURATION, Form.CHANNEL_NAME, Role.ANY);
        this.mTalkgroupIdentifier = new AMTalkgroup(decodeConfig.getTalkgroup());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.AM;
    }

    @Override
    protected Identifier getChannelNameIdentifier() {
        return this.mChannelNameIdentifier;
    }

    @Override
    protected Identifier getTalkgroupIdentifier() {
        return this.mTalkgroupIdentifier;
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary\n");
        sb.append("\tDecoder: AM");
        sb.append("\n\n");
        return sb.toString();
    }
}

