/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module;

import com.google.common.eventbus.EventBus;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.audio.AudioSegment;
import io.github.dsheirer.audio.AudioSegmentBroadcaster;
import io.github.dsheirer.audio.IAudioSegmentListener;
import io.github.dsheirer.audio.IAudioSegmentProvider;
import io.github.dsheirer.audio.codec.mbe.MBECallSequenceRecorder;
import io.github.dsheirer.audio.squelch.ISquelchStateListener;
import io.github.dsheirer.audio.squelch.ISquelchStateProvider;
import io.github.dsheirer.audio.squelch.SquelchStateEvent;
import io.github.dsheirer.channel.state.AbstractChannelState;
import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.IDecoderStateEventListener;
import io.github.dsheirer.channel.state.IDecoderStateEventProvider;
import io.github.dsheirer.channel.state.MultiChannelState;
import io.github.dsheirer.channel.state.SingleChannelState;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelConfigurationChangeNotification;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventListener;
import io.github.dsheirer.controller.channel.IChannelEventProvider;
import io.github.dsheirer.identifier.IdentifierUpdateListener;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.message.IMessageProvider;
import io.github.dsheirer.message.MessageHistory;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.module.decode.event.DecodeEventHistory;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventListener;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.module.decode.traffic.TrafficChannelManager;
import io.github.dsheirer.module.log.EventLogger;
import io.github.dsheirer.record.binary.BinaryRecorder;
import io.github.dsheirer.record.wave.ComplexSamplesWaveRecorder;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferListener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.sample.real.IRealBufferListener;
import io.github.dsheirer.sample.real.IRealBufferProvider;
import io.github.dsheirer.source.ComplexSource;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.RealSource;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.heartbeat.Heartbeat;
import io.github.dsheirer.source.heartbeat.IHeartbeatListener;
import io.github.dsheirer.source.heartbeat.IHeartbeatProvider;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingChain
implements Listener<ChannelEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(ProcessingChain.class);
    private Broadcaster<float[]> mDemodulatedAudioBufferBroadcaster = new Broadcaster();
    private Broadcaster<ComplexSamples> mBasebandComplexSamplesBroadcaster = new Broadcaster();
    private Broadcaster<ByteBuffer> mDemodulatedBitstreamBufferBroadcaster = new Broadcaster();
    private Broadcaster<AudioSegment> mAudioSegmentBroadcaster = new AudioSegmentBroadcaster<AudioSegment>();
    private Broadcaster<IDecodeEvent> mDecodeEventBroadcaster = new Broadcaster();
    private Broadcaster<ChannelEvent> mChannelEventBroadcaster = new Broadcaster();
    private Broadcaster<DecoderStateEvent> mDecoderStateEventBroadcaster = new Broadcaster();
    private Broadcaster<Heartbeat> mHeartbeatBroadcaster = new Broadcaster();
    private Broadcaster<IdentifierUpdateNotification> mIdentifierUpdateNotificationBroadcaster = new Broadcaster();
    private Broadcaster<SourceEvent> mSourceEventBroadcaster = new Broadcaster();
    private Broadcaster<IMessage> mMessageBroadcaster = new Broadcaster();
    private Broadcaster<SquelchStateEvent> mSquelchStateEventBroadcaster = new Broadcaster();
    private AtomicBoolean mRunning = new AtomicBoolean();
    private DecodeEventHistory mDecodeEventHistory = new DecodeEventHistory(200);
    private MessageHistory mMessageHistory = new MessageHistory(200);
    private AbstractChannelState mChannelState;
    private EventBus mEventBus;
    protected Source mSource;
    private ReentrantLock mModuleLock = new ReentrantLock();
    private List<Module> mModules = new ArrayList<Module>();

    public ProcessingChain(Channel channel, AliasModel aliasModel) {
        this.mEventBus = new EventBus("Processing Chain Event Bus - Channel: " + channel.getName());
        this.mChannelState = channel.getDecodeConfiguration().getTimeslotCount() == 1 ? new SingleChannelState(channel, aliasModel) : new MultiChannelState(channel, aliasModel, channel.getDecodeConfiguration().getTimeslots());
        this.addModule(this.mChannelState);
        this.addModule(this.mDecodeEventHistory);
        this.addModule(this.mMessageHistory);
    }

    public EventBus getEventBus() {
        return this.mEventBus;
    }

    public AbstractChannelState getChannelState() {
        return this.mChannelState;
    }

    public DecodeEventHistory getDecodeEventHistory() {
        return this.mDecodeEventHistory;
    }

    public MessageHistory getMessageHistory() {
        return this.mMessageHistory;
    }

    public void channelConfigurationChanged(ChannelConfigurationChangeNotification notification) {
        this.getEventBus().post((Object)notification);
    }

    public void removeTrafficChannelManager() {
        this.mModuleLock.lock();
        try {
            Iterator<Module> it = this.mModules.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof TrafficChannelManager)) continue;
                it.remove();
            }
        }
        finally {
            this.mModuleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.stop();
        this.mModuleLock.lock();
        try {
            ArrayList<Module> modulesToRemove = new ArrayList<Module>(this.mModules);
            for (Module module : modulesToRemove) {
                this.removeModule(module);
                module.dispose();
            }
        }
        finally {
            this.mModuleLock.unlock();
        }
        this.mAudioSegmentBroadcaster.dispose();
        this.mDecodeEventBroadcaster.dispose();
        this.mChannelEventBroadcaster.dispose();
        this.mBasebandComplexSamplesBroadcaster.dispose();
        this.mDemodulatedBitstreamBufferBroadcaster.dispose();
        this.mMessageBroadcaster.dispose();
        this.mSquelchStateEventBroadcaster.dispose();
    }

    public boolean isProcessing() {
        return this.mRunning.get();
    }

    public boolean hasSource(Source source) {
        return this.mSource != null && this.mSource.equals(source);
    }

    public void setSource(Source source) throws IllegalStateException {
        if (this.isProcessing()) {
            throw new IllegalStateException("Processing chain is currently processing.  Invoke stop() on the processing chain before applying a new sample source");
        }
        this.mSource = source;
        this.addModule(this.mSource);
    }

    public Source getSource() {
        return this.mSource;
    }

    public List<Module> getModules() {
        return Collections.unmodifiableList(this.mModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DecoderState> getDecoderStates() {
        ArrayList<DecoderState> decoderStates = new ArrayList<DecoderState>();
        this.mModuleLock.lock();
        try {
            for (Module module : this.mModules) {
                if (!(module instanceof DecoderState)) continue;
                decoderStates.add((DecoderState)module);
            }
        }
        finally {
            this.mModuleLock.unlock();
        }
        return decoderStates;
    }

    public void addModules(List<Module> modules) {
        for (Module module : modules) {
            this.addModule(module);
        }
    }

    public void addModule(Module module) {
        this.mModuleLock.lock();
        try {
            this.mModules.add(module);
        }
        finally {
            this.mModuleLock.unlock();
        }
        module.setInterModuleEventBus(this.getEventBus());
        this.registerListeners(module);
        this.registerProviders(module);
    }

    public void removeModule(Module module) {
        this.unregisterListeners(module);
        this.unregisterProviders(module);
        module.setInterModuleEventBus(null);
        this.mModuleLock.lock();
        try {
            this.mModules.remove(module);
        }
        finally {
            this.mModuleLock.unlock();
        }
    }

    public void broadcast(SourceEvent sourceEvent) {
        this.mSourceEventBroadcaster.broadcast(sourceEvent);
    }

    private void registerListeners(Module module) {
        Listener<SourceEvent> listener;
        if (module instanceof IdentifierUpdateListener) {
            this.mIdentifierUpdateNotificationBroadcaster.addListener(((IdentifierUpdateListener)((Object)module)).getIdentifierUpdateListener());
        }
        if (module instanceof IAudioSegmentListener) {
            this.mAudioSegmentBroadcaster.addListener(((IAudioSegmentListener)((Object)module)).getAudioSegmentListener());
        }
        if (module instanceof IDecodeEventListener) {
            this.mDecodeEventBroadcaster.addListener(((IDecodeEventListener)((Object)module)).getDecodeEventListener());
        }
        if (module instanceof IChannelEventListener) {
            this.mChannelEventBroadcaster.addListener(((IChannelEventListener)((Object)module)).getChannelEventListener());
        }
        if (module instanceof IDecoderStateEventListener) {
            this.mDecoderStateEventBroadcaster.addListener(((IDecoderStateEventListener)((Object)module)).getDecoderStateListener());
        }
        if (module instanceof IHeartbeatListener) {
            this.mHeartbeatBroadcaster.addListener(((IHeartbeatListener)((Object)module)).getHeartbeatListener());
        }
        if (module instanceof IMessageListener) {
            this.mMessageBroadcaster.addListener(((IMessageListener)((Object)module)).getMessageListener());
        }
        if (module instanceof IRealBufferListener) {
            this.mDemodulatedAudioBufferBroadcaster.addListener(((IRealBufferListener)((Object)module)).getBufferListener());
        }
        if (module instanceof IByteBufferListener) {
            this.mDemodulatedBitstreamBufferBroadcaster.addListener(((IByteBufferListener)((Object)module)).getByteBufferListener());
        }
        if (module instanceof IComplexSamplesListener) {
            this.mBasebandComplexSamplesBroadcaster.addListener(((IComplexSamplesListener)((Object)module)).getComplexSamplesListener());
        }
        if (module instanceof ISourceEventListener && (listener = ((ISourceEventListener)((Object)module)).getSourceEventListener()) != null) {
            this.mSourceEventBroadcaster.addListener(listener);
        }
        if (module instanceof ISquelchStateListener) {
            this.mSquelchStateEventBroadcaster.addListener(((ISquelchStateListener)((Object)module)).getSquelchStateListener());
        }
    }

    private void unregisterListeners(Module module) {
        if (module instanceof IdentifierUpdateListener) {
            this.mIdentifierUpdateNotificationBroadcaster.removeListener(((IdentifierUpdateListener)((Object)module)).getIdentifierUpdateListener());
        }
        if (module instanceof IAudioSegmentListener) {
            this.mAudioSegmentBroadcaster.removeListener(((IAudioSegmentListener)((Object)module)).getAudioSegmentListener());
        }
        if (module instanceof IDecodeEventListener) {
            this.mDecodeEventBroadcaster.removeListener(((IDecodeEventListener)((Object)module)).getDecodeEventListener());
        }
        if (module instanceof IChannelEventListener) {
            this.mChannelEventBroadcaster.removeListener(((IChannelEventListener)((Object)module)).getChannelEventListener());
        }
        if (module instanceof IDecoderStateEventListener) {
            this.mDecoderStateEventBroadcaster.removeListener(((IDecoderStateEventListener)((Object)module)).getDecoderStateListener());
        }
        if (module instanceof IHeartbeatListener) {
            this.mHeartbeatBroadcaster.removeListener(((IHeartbeatListener)((Object)module)).getHeartbeatListener());
        }
        if (module instanceof IRealBufferListener) {
            this.mDemodulatedAudioBufferBroadcaster.removeListener(((IRealBufferListener)((Object)module)).getBufferListener());
        }
        if (module instanceof IByteBufferListener) {
            this.mDemodulatedBitstreamBufferBroadcaster.removeListener(((IByteBufferListener)((Object)module)).getByteBufferListener());
        }
        if (module instanceof IComplexSamplesListener) {
            this.mBasebandComplexSamplesBroadcaster.removeListener(((IComplexSamplesListener)((Object)module)).getComplexSamplesListener());
        }
        if (module instanceof ISourceEventListener) {
            this.mSourceEventBroadcaster.removeListener(((ISourceEventListener)((Object)module)).getSourceEventListener());
        }
        if (module instanceof IMessageListener) {
            this.mMessageBroadcaster.removeListener(((IMessageListener)((Object)module)).getMessageListener());
        }
        if (module instanceof ISquelchStateListener) {
            this.mSquelchStateEventBroadcaster.removeListener(((ISquelchStateListener)((Object)module)).getSquelchStateListener());
        }
    }

    private void registerProviders(Module module) {
        if (module instanceof IdentifierUpdateProvider) {
            ((IdentifierUpdateProvider)((Object)module)).setIdentifierUpdateListener(this.mIdentifierUpdateNotificationBroadcaster);
        }
        if (module instanceof IAudioSegmentProvider) {
            ((IAudioSegmentProvider)((Object)module)).setAudioSegmentListener(this.mAudioSegmentBroadcaster);
        }
        if (module instanceof IDecodeEventProvider) {
            ((IDecodeEventProvider)((Object)module)).addDecodeEventListener(this.mDecodeEventBroadcaster);
        }
        if (module instanceof IChannelEventProvider) {
            ((IChannelEventProvider)((Object)module)).setChannelEventListener(this.mChannelEventBroadcaster);
        }
        if (module instanceof IDecoderStateEventProvider) {
            ((IDecoderStateEventProvider)((Object)module)).setDecoderStateListener(this.mDecoderStateEventBroadcaster);
        }
        if (module instanceof IHeartbeatProvider) {
            ((IHeartbeatProvider)((Object)module)).addHeartbeatListener(this.mHeartbeatBroadcaster);
        }
        if (module instanceof IMessageProvider) {
            ((IMessageProvider)((Object)module)).setMessageListener(this.mMessageBroadcaster);
        }
        if (module instanceof IMessageProvider) {
            ((IMessageProvider)((Object)module)).setMessageListener(this.mMessageBroadcaster);
        }
        if (module instanceof IByteBufferProvider) {
            ((IByteBufferProvider)((Object)module)).setBufferListener(this.mDemodulatedBitstreamBufferBroadcaster);
        }
        if (module instanceof IRealBufferProvider) {
            ((IRealBufferProvider)((Object)module)).setBufferListener(this.mDemodulatedAudioBufferBroadcaster);
        }
        if (module instanceof ISourceEventProvider) {
            ((ISourceEventProvider)((Object)module)).setSourceEventListener(this.mSourceEventBroadcaster);
        }
        if (module instanceof ISquelchStateProvider) {
            ((ISquelchStateProvider)((Object)module)).setSquelchStateListener(this.mSquelchStateEventBroadcaster);
        }
    }

    private void unregisterProviders(Module module) {
        if (module instanceof IdentifierUpdateProvider) {
            ((IdentifierUpdateProvider)((Object)module)).removeIdentifierUpdateListener();
        }
        if (module instanceof IAudioSegmentProvider) {
            ((IAudioSegmentProvider)((Object)module)).setAudioSegmentListener(null);
        }
        if (module instanceof IByteBufferProvider) {
            ((IByteBufferProvider)((Object)module)).removeBufferListener(this.mDemodulatedBitstreamBufferBroadcaster);
        }
        if (module instanceof IDecodeEventProvider) {
            ((IDecodeEventProvider)((Object)module)).removeDecodeEventListener(this.mDecodeEventBroadcaster);
        }
        if (module instanceof IChannelEventProvider) {
            ((IChannelEventProvider)((Object)module)).removeChannelEventListener();
        }
        if (module instanceof IDecoderStateEventProvider) {
            ((IDecoderStateEventProvider)((Object)module)).setDecoderStateListener(null);
        }
        if (module instanceof IHeartbeatProvider) {
            ((IHeartbeatProvider)((Object)module)).removeHeartbeatListener(this.mHeartbeatBroadcaster);
        }
        if (module instanceof IMessageProvider) {
            ((IMessageProvider)((Object)module)).setMessageListener(null);
        }
        if (module instanceof IMessageProvider) {
            ((IMessageProvider)((Object)module)).setMessageListener(null);
        }
        if (module instanceof IRealBufferProvider) {
            ((IRealBufferProvider)((Object)module)).setBufferListener(null);
        }
        if (module instanceof ISourceEventProvider) {
            ((ISourceEventProvider)((Object)module)).setSourceEventListener(null);
        }
        if (module instanceof ISquelchStateProvider) {
            ((ISquelchStateProvider)((Object)module)).setSquelchStateListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            if (this.mSource != null) {
                this.mSourceEventBroadcaster.broadcast(SourceEvent.sampleRateChange(this.mSource.getSampleRate(), "Processing Chain Startup"));
                this.mSourceEventBroadcaster.broadcast(SourceEvent.frequencyChange(this.mSource, this.mSource.getFrequency(), "Processing Chain Startup"));
                this.mSource.setOverflowListener(this.mChannelState);
                switch (this.mSource.getSampleType()) {
                    case COMPLEX: {
                        ((ComplexSource)this.mSource).setListener(this.mBasebandComplexSamplesBroadcaster);
                        break;
                    }
                    case REAL: {
                        ((RealSource)this.mSource).setListener(this.mDemodulatedAudioBufferBroadcaster);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized source sample type - cannot start processing chain");
                    }
                }
                this.mModuleLock.lock();
                try {
                    for (Module module : this.mModules) {
                        try {
                            module.start();
                        }
                        catch (Exception e) {
                            mLog.error("Error starting module", (Throwable)e);
                        }
                    }
                }
                finally {
                    this.mModuleLock.unlock();
                }
            } else {
                mLog.error("Source is null on start()");
            }
        }
    }

    public void stop() {
        if (this.mRunning.compareAndSet(true, false)) {
            if (this.mSource != null) {
                this.removeModule(this.mSource);
                this.mSource.stop();
                this.mSource.setOverflowListener(null);
                switch (this.mSource.getSampleType()) {
                    case COMPLEX: {
                        ((ComplexSource)this.mSource).setListener(null);
                        break;
                    }
                    case REAL: {
                        ((RealSource)this.mSource).setListener(null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized source sample type - cannot start processing chain");
                    }
                }
                this.mSource = null;
            }
            this.mModuleLock.lock();
            try {
                for (Module module : this.mModules) {
                    module.stop();
                }
                for (Module module : this.mModules) {
                    module.reset();
                }
            }
            catch (Exception e) {
                mLog.error("Error stopping or resetting modules", (Throwable)e);
            }
            finally {
                this.mModuleLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventLoggingModules() {
        ArrayList<Module> eventLoggingModules = new ArrayList<Module>();
        this.mModuleLock.lock();
        try {
            for (Module module : this.mModules) {
                if (!(module instanceof EventLogger)) continue;
                eventLoggingModules.add(module);
            }
        }
        finally {
            this.mModuleLock.unlock();
        }
        for (Module eventLoggingModule : eventLoggingModules) {
            this.removeModule(eventLoggingModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordingModules() {
        ArrayList<Module> recordingModules = new ArrayList<Module>();
        this.mModuleLock.lock();
        try {
            for (Module module : this.mModules) {
                if (module instanceof ComplexSamplesWaveRecorder) {
                    recordingModules.add(module);
                    continue;
                }
                if (module instanceof MBECallSequenceRecorder) {
                    recordingModules.add(module);
                    continue;
                }
                if (!(module instanceof BinaryRecorder)) continue;
                recordingModules.add(module);
            }
        }
        finally {
            this.mModuleLock.unlock();
        }
        for (Module recordingModule : recordingModules) {
            this.removeModule(recordingModule);
        }
    }

    public void addAudioSegmentListener(Listener<AudioSegment> listener) {
        this.mAudioSegmentBroadcaster.addListener(listener);
    }

    public void removeAudioSegmentListener(Listener<AudioSegment> listener) {
        this.mAudioSegmentBroadcaster.removeListener(listener);
    }

    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventBroadcaster.addListener(listener);
    }

    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventBroadcaster.removeListener(listener);
    }

    public void addChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.addListener(listener);
    }

    public void removeChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventBroadcaster.removeListener(listener);
    }

    public void addDecoderStateEventListener(Listener<DecoderStateEvent> listener) {
        this.mDecoderStateEventBroadcaster.addListener(listener);
    }

    public void removeDecoderStateEventListener(Listener<DecoderStateEvent> listener) {
        this.mDecoderStateEventBroadcaster.removeListener(listener);
    }

    public Listener<DecoderStateEvent> getDecoderStateEventListener() {
        return this.mDecoderStateEventBroadcaster;
    }

    public void addSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.addListener(listener);
    }

    public void removeSourceEventListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.removeListener(listener);
    }

    public void addFrequencyChangeListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.addListener(listener);
    }

    public void removeFrequencyChangeListener(Listener<SourceEvent> listener) {
        this.mSourceEventBroadcaster.removeListener(listener);
    }

    public void addSquelchStateListener(Listener<SquelchStateEvent> listener) {
        this.mSquelchStateEventBroadcaster.addListener(listener);
    }

    public void removeSquelchStateListener(Listener<SquelchStateEvent> listener) {
        this.mSquelchStateEventBroadcaster.removeListener(listener);
    }

    public void addDemodulatedAudioListener(Listener<float[]> listener) {
        this.mDemodulatedAudioBufferBroadcaster.addListener(listener);
    }

    public void removeDemodulatedAudioListener(Listener<float[]> listener) {
        this.mDemodulatedAudioBufferBroadcaster.removeListener(listener);
    }

    @Override
    public void receive(ChannelEvent channelEvent) {
        this.mChannelEventBroadcaster.broadcast(channelEvent);
    }

    @Override
    public void receive(IdentifierUpdateNotification updateNotification) {
        this.mIdentifierUpdateNotificationBroadcaster.broadcast(updateNotification);
    }
}

