/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.map.PlottableEntityHistory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class PlottableEntityRenderer {
    private AliasModel mAliasModel;
    private IconModel mIconModel;

    public PlottableEntityRenderer(AliasModel aliasModel, IconModel iconModel) {
        this.mAliasModel = aliasModel;
        this.mIconModel = iconModel;
    }

    public void paintPlottableEntity(Graphics2D g, JXMapViewer viewer, PlottableEntityHistory entity, boolean antiAliasing) {
        List<GeoPosition> locationHistory = entity.getLocationHistory();
        if (!locationHistory.isEmpty() && locationHistory.get(locationHistory.size() - 1).isValid()) {
            List<Alias> aliases;
            Graphics2D graphics = (Graphics2D)g.create();
            if (antiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            Alias alias = (aliases = this.getAliases(entity)).isEmpty() ? null : aliases.get(0);
            Color color = alias != null ? alias.getDisplayColor() : Color.YELLOW;
            graphics.setColor(color);
            this.paintRoute(graphics, viewer, entity, color);
            Point2D point = viewer.getTileFactory().geoToPixel(locationHistory.get(locationHistory.size() - 1), viewer.getZoom());
            ImageIcon icon = this.getIcon(alias);
            this.paintIcon(graphics, point, icon);
            String label = alias != null ? alias.getName() : entity.getIdentifier().toString();
            this.paintLabel(graphics, point, label, icon.getIconWidth() / 2, 0);
            graphics.dispose();
        }
    }

    private List<Alias> getAliases(PlottableEntityHistory entityHistory) {
        AliasList aliasList = this.mAliasModel.getAliasList(entityHistory.getIdentifierCollection());
        if (aliasList != null) {
            return aliasList.getAliases(entityHistory.getIdentifier());
        }
        return Collections.EMPTY_LIST;
    }

    private ImageIcon getIcon(Alias alias) {
        String iconName = alias != null ? alias.getIconName() : null;
        return this.mIconModel.getIcon(iconName, 12);
    }

    private void paintIcon(Graphics2D graphics, Point2D point, ImageIcon icon) {
        graphics.drawImage(icon.getImage(), (int)point.getX() - icon.getIconWidth() / 2, (int)point.getY() - icon.getIconHeight() / 2, null);
    }

    private void paintLabel(Graphics2D graphics, Point2D point, String label, int xOffset, int yOffset) {
        graphics.drawString(label, (int)point.getX() + xOffset, (int)point.getY() + yOffset);
    }

    private void paintRoute(Graphics2D graphics, JXMapViewer viewer, PlottableEntityHistory entity, Color color) {
        List<GeoPosition> locations = entity.getLocationHistory();
        if (!locations.isEmpty()) {
            graphics.setColor(Color.BLACK);
            graphics.setStroke(new BasicStroke(3.0f));
            this.drawRoute(locations, graphics, viewer);
            graphics.setColor(color);
            graphics.setStroke(new BasicStroke(1.0f));
            this.drawRoute(locations, graphics, viewer);
        }
    }

    private void drawRoute(List<GeoPosition> locations, Graphics2D g, JXMapViewer viewer) {
        Point2D lastPoint = null;
        for (GeoPosition location : locations) {
            Point2D currentPoint = viewer.getTileFactory().geoToPixel(location, viewer.getZoom());
            if (lastPoint != null) {
                g.drawLine((int)lastPoint.getX(), (int)lastPoint.getY(), (int)currentPoint.getX(), (int)currentPoint.getY());
            }
            lastPoint = currentPoint;
        }
    }
}

