/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.map.IPlottableUpdateListener;
import io.github.dsheirer.map.PlottableEntityHistory;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapService
implements Listener<IDecodeEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(MapService.class);
    private int mMaxHistory = 2;
    private List<IPlottableUpdateListener> mListeners = new ArrayList<IPlottableUpdateListener>();
    private Map<Identifier, PlottableEntityHistory> mEntityHistories = new HashMap<Identifier, PlottableEntityHistory>();
    private IconModel mIconModel;

    public MapService(IconModel resourceManager) {
        this.mIconModel = resourceManager;
    }

    @Override
    public void receive(IDecodeEvent decodeEvent) {
        if (decodeEvent instanceof PlottableDecodeEvent) {
            PlottableDecodeEvent plottableDecodeEvent = (PlottableDecodeEvent)decodeEvent;
            Identifier from = plottableDecodeEvent.getIdentifierCollection().getFromIdentifier();
            if (from != null) {
                PlottableEntityHistory entityHistory = this.mEntityHistories.get(from);
                if (entityHistory == null) {
                    entityHistory = new PlottableEntityHistory(from, plottableDecodeEvent);
                    this.mEntityHistories.put(from, entityHistory);
                } else {
                    entityHistory.add(plottableDecodeEvent);
                }
                for (IPlottableUpdateListener listener : this.mListeners) {
                    listener.addPlottableEntity(entityHistory);
                }
            } else {
                mLog.warn("Received plottable decode event that does not contain a FROM identifier - cannot plot");
            }
        }
    }

    public void addListener(IPlottableUpdateListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(IPlottableUpdateListener listener) {
        this.mListeners.remove(listener);
    }
}

