/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.settings.Setting;
import io.github.dsheirer.settings.SettingType;
import java.net.URL;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapIcon
extends Setting
implements Comparable<MapIcon> {
    private static final Logger mLog = LoggerFactory.getLogger(MapIcon.class);
    private static final int sMAX_IMAGE_DIMENSION = 48;
    private String mPath;
    private ImageIcon mImageIcon;
    @JsonIgnore
    private boolean mEditable;
    @JsonIgnore
    private boolean mDefaultIcon;

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public SettingType getType() {
        return SettingType.MAP_ICON;
    }

    public MapIcon(String name, String path, boolean editable) {
        super(name);
        this.mPath = path;
        this.mEditable = editable;
    }

    public MapIcon(String name, String path) {
        this(name, path, true);
    }

    public MapIcon() {
        this.mEditable = true;
    }

    @JacksonXmlProperty(isAttribute=true, localName="editable")
    public boolean isEditable() {
        return this.mEditable;
    }

    @JacksonXmlProperty(isAttribute=true, localName="default")
    public boolean isDefaultIcon() {
        return this.mDefaultIcon;
    }

    public void setDefaultIcon(boolean isDefault) {
        this.mDefaultIcon = isDefault;
    }

    @JsonIgnore
    public ImageIcon getImageIcon() {
        if (this.mImageIcon == null && this.mPath != null) {
            try {
                URL imageURL = Icon.class.getResource(this.mPath);
                if (imageURL == null && !this.mPath.startsWith("/")) {
                    imageURL = Icon.class.getResource("/" + this.mPath);
                }
                if (imageURL != null) {
                    this.mImageIcon = new ImageIcon(imageURL);
                    if (this.mImageIcon.getIconWidth() > 48 || this.mImageIcon.getIconHeight() > 48) {
                        int height = -1;
                        int width = -1;
                        if (this.mImageIcon.getIconHeight() > this.mImageIcon.getIconWidth()) {
                            height = 48;
                        } else {
                            width = 48;
                        }
                        this.mImageIcon = new ImageIcon(this.mImageIcon.getImage().getScaledInstance(width, height, 4));
                    }
                }
            }
            catch (Exception e) {
                mLog.error("Error loading Icon [" + this.mPath + "]", (Throwable)e);
            }
        }
        return this.mImageIcon;
    }

    @JacksonXmlProperty(isAttribute=true, localName="path")
    public String getPath() {
        return this.mPath;
    }

    public void setPath(String path) {
        this.mPath = path;
    }

    public String toString() {
        if (this.mDefaultIcon) {
            return this.getName() + " (default)";
        }
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MapIcon) {
            MapIcon other = (MapIcon)obj;
            return other.getName().contentEquals(this.getName()) && other.getPath().contentEquals(this.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getPath().hashCode();
    }

    @Override
    public int compareTo(MapIcon other) {
        return this.getName().compareTo(other.getName());
    }
}

