/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.log;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class LoggingSuppressor {
    private Map<String, Integer> mSuppressionCountMap = new HashMap<String, Integer>();
    private Logger mLogger;

    public LoggingSuppressor(Logger logger) {
        this.mLogger = logger;
    }

    public void info(String key, int maxCount, String message) {
        if (this.canLog(key, maxCount)) {
            this.mLogger.info(message + this.getTag(key, maxCount));
        }
    }

    public void info(String key, int maxCount, String message, Throwable t) {
        if (this.canLog(key, maxCount)) {
            this.mLogger.info(message + this.getTag(key, maxCount), t);
        }
    }

    public void error(String key, int maxCount, String message) {
        if (this.canLog(key, maxCount)) {
            this.mLogger.error(message + this.getTag(key, maxCount));
        }
    }

    public void error(String key, int maxCount, String message, Throwable t) {
        if (this.canLog(key, maxCount)) {
            this.mLogger.error(message + this.getTag(key, maxCount), t);
        }
    }

    private String getTag(String key, int maxCount) {
        int count = this.mSuppressionCountMap.get(key);
        return " [Log Suppress " + count + "/" + maxCount + "]";
    }

    private boolean canLog(String key, int maxCount) {
        if (this.mSuppressionCountMap.containsKey(key)) {
            int count = this.mSuppressionCountMap.get(key);
            if (count >= maxCount) {
                return false;
            }
            this.mSuppressionCountMap.put(key, count + 1);
        } else {
            this.mSuppressionCountMap.put(key, 1);
        }
        return true;
    }
}

