/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLog {
    private static final Logger mLog = LoggerFactory.getLogger(ApplicationLog.class);
    private static final String APPLICATION_LOG_FILENAME = "sdrtrunk_app.log";
    private static final int APPLICATION_LOG_MAX_HISTORY = 10;
    private UserPreferences mUserPreferences;
    private RollingFileAppender mRollingFileAppender;
    private Path mApplicationLogPath;

    public ApplicationLog(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        Path applicationLogPath;
        if (preferenceType == PreferenceType.DIRECTORY && this.mRollingFileAppender != null && this.mApplicationLogPath != null && !(applicationLogPath = this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationLog()).equals(this.mApplicationLogPath)) {
            mLog.info("Application logging directory has changed [" + applicationLogPath.toString() + " ] - restarting logging");
            this.stop();
            this.start();
        }
    }

    public void start() {
        MyEventBus.getGlobalEventBus().register((Object)this);
        if (this.mRollingFileAppender == null) {
            this.mApplicationLogPath = this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationLog();
            Path logfile = this.mApplicationLogPath.resolve(APPLICATION_LOG_FILENAME);
            mLog.info("Application Log File: " + logfile.toString());
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern("%-25(%d{yyyyMMdd HHmmss.SSS} [%thread]) %-5level %logger{30} - %msg  %memory_usage%n");
            encoder.start();
            this.mRollingFileAppender = new RollingFileAppender();
            this.mRollingFileAppender.setContext((Context)loggerContext);
            this.mRollingFileAppender.setAppend(true);
            this.mRollingFileAppender.setName("FILE");
            this.mRollingFileAppender.setEncoder((Encoder)encoder);
            this.mRollingFileAppender.setFile(logfile.toString());
            ThresholdFilter thresholdFilter = new ThresholdFilter();
            thresholdFilter.setLevel(Level.DEBUG.toString());
            thresholdFilter.setContext((Context)loggerContext);
            thresholdFilter.setName("sdrtrunk threshold filter");
            thresholdFilter.start();
            this.mRollingFileAppender.addFilter((Filter)thresholdFilter);
            String pattern = logfile.toString().replace(APPLICATION_LOG_FILENAME, "%d{yyyyMMdd}_sdrtrunk_app.log");
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext((Context)loggerContext);
            rollingPolicy.setFileNamePattern(pattern);
            rollingPolicy.setMaxHistory(10);
            rollingPolicy.setParent((FileAppender)this.mRollingFileAppender);
            rollingPolicy.start();
            this.mRollingFileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
            this.mRollingFileAppender.start();
            ch.qos.logback.classic.Logger logger = loggerContext.getLogger("ROOT");
            logger.setLevel(Level.ALL);
            logger.addAppender((Appender)this.mRollingFileAppender);
            Attributes atts = this.findManifestAttributes();
            if (atts != null) {
                mLog.info("SDRTrunk Version  : " + atts.getValue("Implementation-Version"));
                mLog.info("Gradle Version    : " + atts.getValue("Created-By"));
                mLog.info("Build Timestamp   : " + atts.getValue("Build-Timestamp"));
                mLog.info("Build-JDK         : " + atts.getValue("Build-JDK"));
                mLog.info("Build OS          : " + atts.getValue("Build-OS"));
            } else {
                mLog.info("Failed to find build information.");
            }
            mLog.info("");
            mLog.info("*******************************************************************");
            mLog.info("**** sdrtrunk: a trunked radio and digital decoding application ***");
            mLog.info("****  website: https://github.com/dsheirer/sdrtrunk             ***");
            mLog.info("*******************************************************************");
            mLog.info("Memory Logging Format: [Used/Allocated PercentUsed%]");
            mLog.info("Host OS Name:          " + System.getProperty("os.name"));
            mLog.info("Host OS Arch:          " + System.getProperty("os.arch"));
            mLog.info("Host OS Version:       " + System.getProperty("os.version"));
            mLog.info("Host CPU Cores:        " + Runtime.getRuntime().availableProcessors());
            mLog.info("Host Max Java Memory:  " + FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
            mLog.info("Storage Directories:");
            mLog.info(" Application Root: " + String.valueOf(this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationRoot()));
            mLog.info(" Application Log:  " + String.valueOf(this.mUserPreferences.getDirectoryPreference().getDirectoryApplicationLog()));
            mLog.info(" Event Log:        " + String.valueOf(this.mUserPreferences.getDirectoryPreference().getDirectoryEventLog()));
            mLog.info(" Playlist:         " + String.valueOf(this.mUserPreferences.getDirectoryPreference().getDirectoryPlaylist()));
            mLog.info(" Recordings:       " + String.valueOf(this.mUserPreferences.getDirectoryPreference().getDirectoryRecording()));
        }
    }

    public void stop() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
        if (this.mRollingFileAppender != null) {
            mLog.info("Stopping application logging");
            this.mRollingFileAppender.stop();
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger logger = loggerContext.getLogger("ROOT");
            logger.detachAppender((Appender)this.mRollingFileAppender);
            this.mRollingFileAppender = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Attributes findManifestAttributes() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes atts = manifest.getMainAttributes();
                    Boolean hasTitle = atts.containsValue("sdrtrunk project");
                    if (!hasTitle.booleanValue()) continue;
                    return atts;
                }
                catch (IOException E) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
    }
}

