/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.jmbe.github;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    public static final Pattern VERSION_PATTERN = Pattern.compile("v?(\\d{1,5}).(\\d{1,5}).(\\d{1,5})(\\w*)");
    private Integer mMajor;
    private Integer mMinor;
    private Integer mRelease;
    private Character mPatch;

    public Version(int major, int minor, int release, Character patch) {
        this.mMajor = major;
        this.mMinor = minor;
        this.mRelease = release;
        this.mPatch = patch;
    }

    public static Version fromString(String version) {
        Matcher m;
        if (version != null && (m = VERSION_PATTERN.matcher(version.replace("\"", ""))).matches()) {
            int major = 0;
            int minor = 0;
            int release = 0;
            Character patch = null;
            try {
                major = Integer.parseInt(m.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                minor = Integer.parseInt(m.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                release = Integer.parseInt(m.group(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String rawPatch = m.group(4);
            if (rawPatch != null && rawPatch.length() >= 1) {
                patch = Character.valueOf(rawPatch.charAt(0));
            }
            return new Version(major, minor, release, patch);
        }
        return null;
    }

    public Integer getMajor() {
        return this.mMajor;
    }

    public boolean hasMajor() {
        return this.mMajor != null;
    }

    public Integer getMinor() {
        return this.mMinor;
    }

    public boolean hasMinor() {
        return this.mMinor != null;
    }

    public Integer getRelease() {
        return this.mRelease;
    }

    public boolean hasRelease() {
        return this.mRelease != null;
    }

    public char getPatch() {
        return this.mPatch.charValue();
    }

    public boolean hasPatch() {
        return this.mPatch != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hasMajor() ? this.getMajor() : "x");
        sb.append(".").append(this.hasMinor() ? this.getMinor() : "x");
        sb.append(".").append(this.hasRelease() ? this.getRelease() : "x");
        if (this.hasPatch()) {
            sb.append(this.mPatch);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Version other) {
        if (this.hasMajor() && other.hasMajor()) {
            if (this.getMajor() != other.getMajor()) {
                return Integer.compare(this.getMajor(), other.getMajor());
            }
            if (this.hasMinor() && other.hasMinor()) {
                if (this.getMinor() != other.getMinor()) {
                    return Integer.compare(this.getMinor(), other.getMinor());
                }
                if (this.hasRelease() && other.hasRelease()) {
                    if (this.getRelease() != other.getRelease()) {
                        return Integer.compare(this.getRelease(), other.getRelease());
                    }
                    if (this.hasPatch() && other.hasPatch()) {
                        if (this.getPatch() != other.getPatch()) {
                            return Character.compare(this.getPatch(), other.getPatch());
                        }
                        return 0;
                    }
                    return this.hasPatch() ? 1 : -1;
                }
                return this.hasRelease() ? -1 : 1;
            }
            return this.hasMinor() ? -1 : 1;
        }
        return this.hasMajor() ? -1 : 1;
    }
}

