/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.jmbe.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.dsheirer.jmbe.github.Asset;
import io.github.dsheirer.jmbe.github.Version;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Release {
    private static final Logger mLog = LoggerFactory.getLogger(Release.class);
    private Version mVersion;
    private JsonObject mJsonObject;

    public Release(Version version, JsonObject jsonObject) {
        this.mVersion = version;
        this.mJsonObject = jsonObject;
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public JsonObject getJsonObject() {
        return this.mJsonObject;
    }

    public String getName() {
        return this.getTag("name");
    }

    public String getAssetsUrl() {
        return this.getTag("assets_url");
    }

    public List<Asset> getAssets() {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JsonArray array = this.mJsonObject.getAsJsonArray("assets");
        if (!array.isJsonNull()) {
            for (JsonElement element : array) {
                assets.add(new Asset(element.getAsJsonObject()));
            }
        }
        return assets;
    }

    public String getHtmlUrl() {
        return this.getTag("html_url");
    }

    public String getDownloadUrl() {
        return this.getTag("zipball_url");
    }

    private String getTag(String tagName) {
        JsonElement element;
        if (this.mJsonObject != null && !(element = this.mJsonObject.get(tagName)).isJsonNull()) {
            return element.toString().replace("\"", "");
        }
        return null;
    }

    public boolean hasDownloadUrl() {
        return this.getDownloadUrl() != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nName:").append(this.getName());
        sb.append("\nVersion: ").append(this.getVersion().toString());
        sb.append("\nHTML URL:").append(this.getHtmlUrl());
        sb.append("\nDownload URL:").append(this.getDownloadUrl());
        for (Asset asset : this.getAssets()) {
            sb.append("\nAsset: " + asset.toString());
        }
        return sb.toString();
    }
}

