/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.jmbe.github;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.dsheirer.jmbe.github.Release;
import io.github.dsheirer.jmbe.github.Version;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHub {
    private static final Logger mLog = LoggerFactory.getLogger(GitHub.class);

    private GitHub() {
    }

    public static Path downloadArtifact(String url, Path directory) {
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        try {
            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFileDownload(directory, StandardOpenOption.CREATE, StandardOpenOption.WRITE));
            if (response.statusCode() != 200) {
                mLog.error("HTTP Download Status Code: " + response.statusCode());
            }
            return response.body();
        }
        catch (Exception e) {
            mLog.error("Error downloading source code from GitHub", (Throwable)e);
            return null;
        }
    }

    public static Release getLatestRelease(String repositoryURL) {
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(repositoryURL)).build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return GitHub.parseResponse(response.body());
            }
            mLog.error("Error while fetching latest releases - HTTP:" + response.statusCode());
        }
        catch (IOException | InterruptedException e) {
            mLog.error("Error while detecting the current release version of JMBE library", (Throwable)e);
        }
        return null;
    }

    private static Release parseResponse(String json) {
        JsonElement element;
        Release release = null;
        if (json != null && (element = JsonParser.parseString((String)json)).isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement child : array) {
                JsonObject releaseObject;
                Version version;
                if (!child.isJsonObject() || (version = GitHub.getVersion(releaseObject = child.getAsJsonObject())) == null || release != null && release.getVersion().compareTo(version) >= 0) continue;
                release = new Release(version, releaseObject);
            }
        }
        return release;
    }

    private static Version getVersion(JsonObject jsonObject) {
        JsonElement tagName = jsonObject.get("tag_name");
        if (tagName != null) {
            return Version.fromString(tagName.toString());
        }
        return null;
    }
}

