/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.jmbe;

import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.jmbe.JmbeCreator;
import io.github.dsheirer.jmbe.JmbeEditorRequest;
import io.github.dsheirer.jmbe.github.Release;
import io.github.dsheirer.jmbe.github.Version;
import io.github.dsheirer.preference.UserPreferences;
import java.io.File;
import java.nio.file.Path;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmbeEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeEditor.class);
    private UserPreferences mUserPreferences;
    private Release mCurrentRelease;
    private Label mCurrentVersionLabel;
    private Label mUpdatedVersionLabel;
    private Label mLibraryPathLabel;
    private Button mChangeDirectoryButton;
    private GridPane mLabelGridPane;
    private Path mLibraryDirectoryPath;
    private Button mCreateButton;
    private TextArea mConsoleTextArea;

    public JmbeEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        Separator separator = new Separator();
        separator.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.getConsoleTextArea(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getLabelGridPane(), separator, this.getCreateButton(), this.getConsoleTextArea()});
    }

    public void process(JmbeEditorRequest request) {
        if (request != null) {
            this.setCurrentRelease(request.getCurrentRelease());
        }
    }

    private TextArea getConsoleTextArea() {
        if (this.mConsoleTextArea == null) {
            this.mConsoleTextArea = new TextArea();
            this.mConsoleTextArea.setMaxHeight(Double.MAX_VALUE);
            this.mConsoleTextArea.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mConsoleTextArea;
    }

    private Button getCreateButton() {
        if (this.mCreateButton == null) {
            this.mCreateButton = new Button("Create Library");
            this.mCreateButton.setOnAction(event -> {
                String noticeText = "The JMBE library is available as source code for educational purposes only.  It is a written description of how certain voice encoding/decoding algorithms could be implemented. Executable objects compiled or derived from this package may be covered by one or more patents. Users are strongly advised to check for any patent restrictions or licensing requirements before compiling or using this source code.\n\nClicking the YES button indicates that you are requesting to download the JMBE source code and compile the JMBE library.";
                Alert alert = new Alert(Alert.AlertType.WARNING, noticeText, new ButtonType[]{ButtonType.YES, ButtonType.NO});
                alert.setResizable(true);
                alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                alert.setTitle("Download and Compile JMBE Library?");
                alert.setHeaderText("Do you want to continue?");
                alert.initOwner(this.getCreateButton().getScene().getWindow());
                alert.showAndWait().ifPresent(buttonType -> {
                    if (buttonType == ButtonType.YES) {
                        Path library = this.getLibraryDirectoryPath().resolve(JmbeEditor.getJarName(this.mCurrentRelease.getVersion()));
                        this.getCreateButton().setDisable(true);
                        this.createJmbeLibrary(library);
                    }
                });
            });
        }
        return this.mCreateButton;
    }

    private void createJmbeLibrary(Path library) {
        JmbeCreator jmbeCreator = new JmbeCreator(this.mCurrentRelease, library);
        this.getConsoleTextArea().textProperty().bind((ObservableValue)jmbeCreator.consoleOutputProperty());
        jmbeCreator.completeProperty().addListener((observable, oldValue, newValue) -> {
            this.getCreateButton().setDisable(false);
            boolean failed = jmbeCreator.hasErrors();
            String content = null;
            if (failed) {
                content = "JMBE library creation attempt failed.  Please update the library manually by downloading the JMBE creator application.";
            } else {
                content = "JMBE library successfully created/updated";
                this.mUserPreferences.getJmbeLibraryPreference().setPathJmbeLibrary(jmbeCreator.getLibraryPath());
                this.getCurrentVersionLabel().setText(this.mCurrentRelease.getVersion().toString());
            }
            Alert alert = new Alert(Alert.AlertType.INFORMATION, content, new ButtonType[]{ButtonType.OK});
            alert.setTitle("JMBE Library Creator");
            alert.setHeaderText((failed ? "Attempt failed." : "Success!") + " Please click OK to close this window");
            alert.initOwner(this.getCreateButton().getScene().getWindow());
            alert.showAndWait().ifPresent(buttonType -> {
                jmbeCreator.completeProperty().unbind();
                MyEventBus.getGlobalEventBus().post((Object)new JmbeEditorRequest(true));
            });
        });
        jmbeCreator.execute();
    }

    public static String getJarName(Version version) {
        String name = version.toString();
        name = name.replace("v", "");
        return "jmbe-" + name + ".jar";
    }

    private GridPane getLabelGridPane() {
        if (this.mLabelGridPane == null) {
            this.mLabelGridPane = new GridPane();
            this.mLabelGridPane.setHgap(10.0);
            this.mLabelGridPane.setVgap(10.0);
            int row = 0;
            Label topLabel = new Label("Create or Update JMBE Library");
            this.mLabelGridPane.add((Node)topLabel, 0, row, 2, 1);
            Label currentLabel = new Label("Current Version:");
            GridPane.setHalignment((Node)currentLabel, (HPos)HPos.RIGHT);
            this.mLabelGridPane.add((Node)currentLabel, 0, ++row);
            this.mLabelGridPane.add((Node)this.getCurrentVersionLabel(), 1, row);
            Label updateLabel = new Label("Updating To Version:");
            GridPane.setHalignment((Node)updateLabel, (HPos)HPos.RIGHT);
            this.mLabelGridPane.add((Node)updateLabel, 0, ++row);
            this.mLabelGridPane.add((Node)this.getUpdatedVersionLabel(), 1, row);
            Label pathLabel = new Label("Store Library At:");
            GridPane.setHalignment((Node)pathLabel, (HPos)HPos.RIGHT);
            this.mLabelGridPane.add((Node)pathLabel, 0, ++row);
            this.mLabelGridPane.add((Node)this.getLibraryPathLabel(), 1, row);
            this.mLabelGridPane.add((Node)this.getChangeDirectoryButton(), 1, ++row);
        }
        return this.mLabelGridPane;
    }

    private Path getLibraryDirectoryPath() {
        if (this.mLibraryDirectoryPath == null) {
            this.mLibraryDirectoryPath = this.mUserPreferences.getDirectoryPreference().getDefaultJmbeDirectory();
        }
        return this.mLibraryDirectoryPath;
    }

    private Button getChangeDirectoryButton() {
        if (this.mChangeDirectoryButton == null) {
            this.mChangeDirectoryButton = new Button("Change Directory ...");
            this.mChangeDirectoryButton.setOnAction(event -> {
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.setInitialDirectory(this.getLibraryDirectoryPath().toFile());
                chooser.setTitle("JMBE Library Directory");
                File newDirectory = chooser.showDialog(this.getChangeDirectoryButton().getScene().getWindow());
                this.setLibraryDirectoryPath(newDirectory.toPath());
            });
        }
        return this.mChangeDirectoryButton;
    }

    private void setLibraryDirectoryPath(Path path) {
        if (path != null) {
            this.mLibraryDirectoryPath = path;
            this.getLibraryPathLabel().setText(this.mLibraryDirectoryPath.toString());
        }
    }

    private Label getLibraryPathLabel() {
        if (this.mLibraryPathLabel == null) {
            this.mLibraryPathLabel = new Label();
            if (this.getLibraryDirectoryPath() != null) {
                this.mLibraryPathLabel.setText(this.getLibraryDirectoryPath().toString());
            }
        }
        return this.mLibraryPathLabel;
    }

    private Label getCurrentVersionLabel() {
        if (this.mCurrentVersionLabel == null) {
            this.mCurrentVersionLabel = new Label("(empty)");
            Version currentVersion = this.mUserPreferences.getJmbeLibraryPreference().getCurrentVersion();
            if (currentVersion != null) {
                this.mCurrentVersionLabel.setText(currentVersion.toString());
            }
        }
        return this.mCurrentVersionLabel;
    }

    private Label getUpdatedVersionLabel() {
        if (this.mUpdatedVersionLabel == null) {
            this.mUpdatedVersionLabel = new Label("(empty)");
        }
        return this.mUpdatedVersionLabel;
    }

    private Release getCurrentRelease() {
        return this.mCurrentRelease;
    }

    public void setCurrentRelease(Release release) {
        Version updateVersion;
        this.mCurrentRelease = release;
        if (release != null && (updateVersion = release.getVersion()) != null) {
            this.getUpdatedVersionLabel().setText(updateVersion.toString());
        }
    }
}

