/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.tone;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.google.common.base.Joiner;
import io.github.dsheirer.identifier.tone.Tone;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ToneSequence {
    private ObservableList<Tone> mTones = FXCollections.observableArrayList(Tone.extractor());

    public ToneSequence(List<Tone> tones) {
        this.mTones.setAll(tones);
    }

    public ToneSequence() {
    }

    public ToneSequence copyOf() {
        ToneSequence toneSequence = new ToneSequence();
        for (Tone tone : this.mTones) {
            toneSequence.addTone(tone.copyOf());
        }
        return toneSequence;
    }

    public ObservableList<Tone> tonesProperty() {
        return this.mTones;
    }

    @JacksonXmlProperty(isAttribute=false, localName="tone")
    public List<Tone> getTones() {
        return this.mTones;
    }

    public void setTones(List<Tone> tones) {
        if (tones != null) {
            this.mTones.setAll(tones);
        }
    }

    @JsonIgnore
    public boolean hasTones() {
        return !this.mTones.isEmpty();
    }

    public void clear() {
        this.mTones.clear();
    }

    public void addTone(Tone tone) {
        if (tone != null) {
            this.mTones.add((Object)tone);
        }
    }

    public void removeTone(Tone tone) {
        if (tone != null) {
            this.mTones.remove((Object)tone);
        }
    }

    public String toString() {
        if (this.mTones.isEmpty()) {
            return "Tones: (empty)";
        }
        return Joiner.on((String)",").join(this.mTones);
    }

    public boolean isContainedIn(ToneSequence other) {
        if (other == null || other.getTones().isEmpty()) {
            return false;
        }
        List<Tone> otherTones = other.getTones();
        int pointer = 0;
        for (Tone thisTone : this.mTones) {
            boolean matches = false;
            for (int x = pointer; x < otherTones.size(); ++x) {
                if (!thisTone.isContainedIn(otherTones.get(x))) continue;
                pointer = x + 1;
                matches = true;
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }
}

