/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.talkgroup;

import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.protocol.Protocol;

public class LTRTalkgroup
extends TalkgroupIdentifier
implements Comparable<LTRTalkgroup> {
    private static final int AREA_MASK = 8192;
    private static final int HOME_MASK = 7936;
    private static final int GROUP_MASK = 255;

    public LTRTalkgroup(Integer talkgroup, Role role) {
        super(talkgroup, role);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.LTR;
    }

    public String formatted() {
        return String.format("%02d-%03d", this.getHomeChannel(), this.getTalkgroup());
    }

    public int getArea() {
        return ((Integer)this.getValue() & 0x2000) >> 13;
    }

    public int getHomeChannel() {
        return ((Integer)this.getValue() & 0x1F00) >> 8;
    }

    public int getTalkgroup() {
        return (Integer)this.getValue() & 0xFF;
    }

    public static LTRTalkgroup create(int talkgroup) {
        return new LTRTalkgroup(talkgroup, Role.TO);
    }

    public static int create(int area, int home, int group) {
        int value = area << 13;
        value += home << 8;
        return value += group;
    }

    @Override
    public int compareTo(LTRTalkgroup o) {
        return ((Integer)this.getValue()).compareTo((Integer)o.getValue());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LTRTalkgroup)) {
            return false;
        }
        return this.compareTo((LTRTalkgroup)o) == 0;
    }
}

