/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.patch;

import io.github.dsheirer.identifier.radio.RadioIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PatchGroup {
    private TalkgroupIdentifier mPatchGroupIdentifier;
    private List<TalkgroupIdentifier> mPatchedTalkgroupIdentifiers = new ArrayList<TalkgroupIdentifier>();
    private List<RadioIdentifier> mPatchedRadioIdentifiers = new ArrayList<RadioIdentifier>();
    private int mVersion;

    public PatchGroup(TalkgroupIdentifier patchGroupIdentifier, int version) {
        this.mPatchGroupIdentifier = patchGroupIdentifier;
        this.mVersion = version;
    }

    public PatchGroup(TalkgroupIdentifier patchGroupIdentifier) {
        this(patchGroupIdentifier, 0);
    }

    public int getVersion() {
        return this.mVersion;
    }

    public TalkgroupIdentifier getPatchGroup() {
        return this.mPatchGroupIdentifier;
    }

    public boolean hasPatchedTalkgroups() {
        return !this.getPatchedTalkgroupIdentifiers().isEmpty();
    }

    public boolean hasPatchedRadios() {
        return !this.getPatchedRadioIdentifiers().isEmpty();
    }

    public void addPatchedTalkgroup(TalkgroupIdentifier patchedGroupIdentifier) {
        if (!this.mPatchedTalkgroupIdentifiers.contains(patchedGroupIdentifier)) {
            this.mPatchedTalkgroupIdentifiers.add(patchedGroupIdentifier);
        }
    }

    public void addPatchedTalkgroups(List<TalkgroupIdentifier> patchedGroupIdentifiers) {
        for (TalkgroupIdentifier identifier : patchedGroupIdentifiers) {
            this.addPatchedTalkgroup(identifier);
        }
    }

    public List<TalkgroupIdentifier> getPatchedTalkgroupIdentifiers() {
        return this.mPatchedTalkgroupIdentifiers;
    }

    public void addPatchedRadio(RadioIdentifier patchedRadioIdentifier) {
        if (!this.mPatchedRadioIdentifiers.contains(patchedRadioIdentifier)) {
            this.mPatchedRadioIdentifiers.add(patchedRadioIdentifier);
        }
    }

    public void addPatchedRadios(List<RadioIdentifier> patchedRadioIdentifiers) {
        for (RadioIdentifier identifier : patchedRadioIdentifiers) {
            this.addPatchedRadio(identifier);
        }
    }

    public List<RadioIdentifier> getPatchedRadioIdentifiers() {
        return this.mPatchedRadioIdentifiers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("P:").append(this.getPatchGroup());
        if (this.hasPatchedTalkgroups()) {
            sb.append(" ").append(this.getPatchedTalkgroupIdentifiers());
        }
        if (this.hasPatchedRadios()) {
            sb.append(" ").append(this.getPatchedRadioIdentifiers());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchGroup that = (PatchGroup)o;
        return Objects.equals(this.mPatchGroupIdentifier, that.mPatchGroupIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.mPatchGroupIdentifier);
    }
}

