/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier;

import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierCollection {
    private static final Logger mLog = LoggerFactory.getLogger(IdentifierCollection.class);
    protected List<Identifier> mIdentifiers = new CopyOnWriteArrayList<Identifier>();
    protected AliasListConfigurationIdentifier mAliasListConfigurationIdentifier;
    private int mTimeslot = 0;

    public IdentifierCollection(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public IdentifierCollection() {
        this(0);
    }

    public IdentifierCollection(Collection<Identifier> identifiers) {
        this(identifiers, 0);
    }

    public IdentifierCollection(Collection<Identifier> identifiers, int timeslot) {
        for (Identifier identifier : identifiers) {
            if (identifier == null) {
                throw new IllegalArgumentException("Identifier cannot be null");
            }
            this.mIdentifiers.add(identifier);
            if (!(identifier instanceof AliasListConfigurationIdentifier)) continue;
            this.mAliasListConfigurationIdentifier = (AliasListConfigurationIdentifier)identifier;
        }
    }

    public int getTimeslot() {
        return this.mTimeslot;
    }

    public void setTimeslot(int timeslot) {
        this.mTimeslot = timeslot;
    }

    public AliasListConfigurationIdentifier getAliasListConfiguration() {
        return this.mAliasListConfigurationIdentifier;
    }

    public boolean hasAliasListConfiguration() {
        return this.mAliasListConfigurationIdentifier != null;
    }

    public List<Identifier> getIdentifiers() {
        return Collections.unmodifiableList(this.mIdentifiers);
    }

    public boolean isEmpty() {
        return this.mIdentifiers.isEmpty();
    }

    public List<Identifier> getIdentifiers(IdentifierClass identifierClass) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier.getIdentifierClass() != identifierClass) continue;
            identifiers.add(identifier);
        }
        return identifiers;
    }

    public List<Identifier> getIdentifiers(Form form) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier.getForm() != form) continue;
            identifiers.add(identifier);
        }
        return identifiers;
    }

    public List<Identifier> getIdentifiers(Role role) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.mIdentifiers) {
            try {
                if (identifier.getRole() != role) continue;
                identifiers.add(identifier);
            }
            catch (NullPointerException npe) {
                StringBuilder sb = new StringBuilder();
                for (Identifier i : this.mIdentifiers) {
                    if (i == null) {
                        sb.append("Identifier: (null)").append("\n");
                        continue;
                    }
                    sb.append("Identifier: ").append(i).append(" Class:").append(i.getClass()).append("\n");
                }
                mLog.warn("An identifier in a collection is somehow null ...\n" + String.valueOf(sb));
            }
        }
        return identifiers;
    }

    public List<Identifier> getIdentifiers(IdentifierClass identifierClass, Role role) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier.getIdentifierClass() != identifierClass || identifier.getRole() != role) continue;
            identifiers.add(identifier);
        }
        return identifiers;
    }

    public List<Identifier> getIdentifiers(IdentifierClass identifierClass, Form form) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier.getIdentifierClass() != identifierClass || identifier.getForm() != form) continue;
            identifiers.add(identifier);
        }
        return identifiers;
    }

    public Identifier getIdentifier(IdentifierClass identifierClass, Form form, Role role) {
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier.getIdentifierClass() != identifierClass || identifier.getForm() != form || identifier.getRole() != role) continue;
            return identifier;
        }
        return null;
    }

    public Identifier getFromIdentifier() {
        List<Identifier> fromIdentifiers;
        Identifier from = this.getIdentifier(IdentifierClass.USER, Form.RADIO, Role.FROM);
        if (from == null && !(fromIdentifiers = this.getIdentifiers(Role.FROM)).isEmpty()) {
            from = fromIdentifiers.get(0);
        }
        return from;
    }

    public Identifier getToIdentifier() {
        List<Identifier> toIdentifiers;
        Identifier to = this.getIdentifier(IdentifierClass.USER, Form.PATCH_GROUP, Role.TO);
        if (to == null) {
            to = this.getIdentifier(IdentifierClass.USER, Form.TALKGROUP, Role.TO);
        }
        if (to == null && !(toIdentifiers = this.getIdentifiers(Role.TO)).isEmpty()) {
            to = toIdentifiers.get(0);
        }
        return to;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Identifier Collection - Timeslot:").append(this.mTimeslot).append("\n");
        for (Identifier identifier : this.getIdentifiers()) {
            sb.append("\t").append(identifier.toString());
            sb.append("\t{").append(identifier.getIdentifierClass().name()).append("|").append(identifier.getForm().name()).append("|").append(identifier.getRole().name()).append("}");
            sb.append("\t").append(identifier.getClass()).append("\n");
        }
        return sb.toString();
    }
}

