/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier;

import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.protocol.Protocol;
import java.util.Objects;

public abstract class Identifier<T> {
    private T mValue;
    private IdentifierClass mIdentifierClass;
    private Form mForm;
    private Role mRole;

    public Identifier(T value, IdentifierClass identifierClass, Form form, Role role) {
        this.mValue = value;
        this.mIdentifierClass = identifierClass;
        this.mForm = form;
        this.mRole = role;
    }

    public String debug() {
        StringBuilder sb = new StringBuilder();
        sb.append("CLASS:").append((Object)this.getIdentifierClass());
        sb.append(" FORM:").append((Object)this.getForm());
        sb.append(" VALUE:").append(this.getValue());
        sb.append(" VALUE CLASS:").append(this.getValue().getClass());
        sb.append(" CLASS:").append(this.getClass());
        return sb.toString();
    }

    public boolean isValid() {
        return true;
    }

    public T getValue() {
        return this.mValue;
    }

    protected void setValue(T value) {
        this.mValue = value;
    }

    public IdentifierClass getIdentifierClass() {
        return this.mIdentifierClass;
    }

    public Form getForm() {
        return this.mForm;
    }

    public Role getRole() {
        return this.mRole;
    }

    public abstract Protocol getProtocol();

    public String toString() {
        return this.getValue().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.getValue(), that.getValue()) && this.getIdentifierClass() == that.getIdentifierClass() && this.getForm() == that.getForm() && this.getRole() == that.getRole();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getValue(), this.getIdentifierClass(), this.getForm(), this.getRole()});
    }
}

