/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.icon;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import javafx.util.Callback;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonXmlRootElement(localName="icon")
public class Icon
implements Comparable<Icon> {
    private static final Logger mLog = LoggerFactory.getLogger(Icon.class);
    private static final int ICON_HEIGHT_JAVAFX = 16;
    private StringProperty mName = new SimpleStringProperty();
    private StringProperty mPath = new SimpleStringProperty();
    private BooleanProperty mDefaultIcon = new SimpleBooleanProperty();
    private BooleanProperty mStandardIcon = new SimpleBooleanProperty();
    private ImageIcon mImageIcon;
    private Image mFxImage;
    private boolean mFxImageLoaded = false;

    public Icon() {
    }

    public Icon(String name, String path) {
        this.setName(name);
        this.setPath(path);
    }

    @JsonIgnore
    public StringProperty nameProperty() {
        return this.mName;
    }

    @JsonIgnore
    public StringProperty pathProperty() {
        return this.mPath;
    }

    @JsonIgnore
    public BooleanProperty defaultIconProperty() {
        return this.mDefaultIcon;
    }

    @JsonIgnore
    public BooleanProperty standardIconProperty() {
        return this.mStandardIcon;
    }

    @JacksonXmlProperty(isAttribute=true, localName="name")
    public String getName() {
        return (String)this.mName.get();
    }

    public void setName(String name) {
        this.mName.set((Object)name);
    }

    @JsonIgnore
    public boolean getStandardIcon() {
        return this.mStandardIcon.get();
    }

    void setStandardIcon(boolean standardIcon) {
        this.mStandardIcon.set(standardIcon);
    }

    @JsonIgnore
    public boolean getDefaultIcon() {
        return this.mDefaultIcon.get();
    }

    void setDefaultIcon(boolean defaultIcon) {
        this.mDefaultIcon.set(defaultIcon);
    }

    public String toString() {
        return this.getName();
    }

    @JacksonXmlProperty(isAttribute=true, localName="path")
    public String getPath() {
        return (String)this.mPath.get();
    }

    public void setPath(String path) {
        this.mPath.set((Object)path);
    }

    @JsonIgnore
    public ImageIcon getIcon() {
        if (this.mImageIcon == null && this.mPath != null) {
            try {
                if (!this.getPath().startsWith("images")) {
                    this.mImageIcon = new ImageIcon(this.getPath());
                } else {
                    URL imageURL = Icon.class.getResource(this.getPath());
                    if (imageURL == null && !this.getPath().startsWith("/")) {
                        imageURL = Icon.class.getResource("/" + this.getPath());
                    }
                    if (imageURL != null) {
                        this.mImageIcon = new ImageIcon(imageURL);
                    }
                }
            }
            catch (Exception e) {
                mLog.error("Error loading Icon [" + this.getPath() + "]", (Throwable)e);
            }
        }
        return this.mImageIcon;
    }

    @JsonIgnore
    public Image getFxImage() {
        if (!this.mFxImageLoaded && this.getPath() != null && !this.getPath().isEmpty()) {
            this.mFxImageLoaded = true;
            if (this.getPath() == null || this.getPath().isEmpty()) {
                mLog.error("Error loading icon [" + this.getName() + "] - null or empty file path to image");
            } else {
                if (this.getPath().startsWith("images")) {
                    this.mFxImage = new Image(this.getPath(), 0.0, 16.0, true, true);
                } else {
                    Path filePath = Path.of(this.getPath(), new String[0]);
                    this.mFxImage = new Image(filePath.toUri().toString(), 0.0, 16.0, true, true);
                }
                if (this.mFxImage.getException() != null) {
                    mLog.error("Error loading icon [" + this.getName() + " " + this.getPath() + "] - " + this.mFxImage.getException().getLocalizedMessage());
                }
            }
        }
        return this.mFxImage;
    }

    @Override
    public int compareTo(Icon other) {
        if (other == null) {
            return -1;
        }
        if (this.hashCode() == other.hashCode()) {
            return 0;
        }
        if (this.getName() != null && other.getName() != null) {
            if (this.getName().contentEquals(other.getName())) {
                if (this.getPath() != null && other.getPath() != null) {
                    return this.getPath().compareTo(other.getPath());
                }
                if (this.getPath() != null) {
                    return -1;
                }
                return 1;
            }
            return this.getName().compareTo(other.getName());
        }
        if (this.getName() != null) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getPath());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Icon)) {
            return false;
        }
        return this.compareTo((Icon)o) == 0;
    }

    /*
     * Exception decompiling
     */
    @JsonIgnore
    public static Callback<Icon, Observable[]> extractor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

