/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.viewer;

import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.DMRMessageFramer;
import io.github.dsheirer.module.decode.dmr.DMRMessageProcessor;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.record.binary.BinaryReader;
import io.github.dsheirer.util.ThreadPool;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmrViewer
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(DmrViewer.class);
    private static final KeyCodeCombination KEY_CODE_COPY = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});
    private static final String LAST_SELECTED_DIRECTORY = "last.selected.directory.dmr";
    private Preferences mPreferences = Preferences.userNodeForPackage(DmrViewer.class);
    private Button mSelectFileButton;
    private Label mSelectedFileLabel;
    private TableView<IMessage> mMessageTableView;
    private ObservableList<IMessage> mMessages = FXCollections.observableArrayList();
    private FilteredList<IMessage> mFilteredMessages = new FilteredList(this.mMessages);
    private CheckBox mShowTS0;
    private CheckBox mShowTS1;
    private CheckBox mShowTS2;
    private CheckBox mUseCompressedTalkgroups;
    private TextField mSearchText;
    private TextField mFindText;
    private Button mFindButton;
    private Button mFindNextButton;
    private ProgressIndicator mLoadingIndicator;

    public DmrViewer() {
        this.setPadding(new Insets(5.0));
        this.setSpacing(5.0);
        HBox fileBox = new HBox();
        fileBox.setMaxWidth(Double.MAX_VALUE);
        fileBox.setAlignment(Pos.CENTER_LEFT);
        fileBox.setSpacing(5.0);
        HBox.setHgrow((Node)this.getSelectFileButton(), (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.getSelectedFileLabel(), (Priority)Priority.ALWAYS);
        this.getSelectedFileLabel().setAlignment(Pos.BASELINE_CENTER);
        HBox compressedBox = new HBox();
        compressedBox.setAlignment(Pos.CENTER_RIGHT);
        compressedBox.setMaxWidth(Double.MAX_VALUE);
        compressedBox.getChildren().addAll((Object[])new Node[]{this.getUseCompressedTalkgroups()});
        HBox.setHgrow((Node)compressedBox, (Priority)Priority.ALWAYS);
        fileBox.getChildren().addAll((Object[])new Node[]{this.getSelectFileButton(), this.getSelectedFileLabel(), compressedBox});
        HBox filterBox = new HBox();
        filterBox.setMaxWidth(Double.MAX_VALUE);
        filterBox.setAlignment(Pos.BASELINE_CENTER);
        filterBox.setSpacing(5.0);
        Label showLabel = new Label("Show:");
        HBox.setMargin((Node)showLabel, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
        Label searchLabel = new Label("Message Filter:");
        HBox.setMargin((Node)searchLabel, (Insets)new Insets(0.0, 0.0, 0.0, 15.0));
        Label findLabel = new Label("Find:");
        HBox.setHgrow((Node)this.getFindText(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getSearchText(), (Priority)Priority.ALWAYS);
        filterBox.getChildren().addAll((Object[])new Node[]{findLabel, this.getFindText(), this.getFindButton(), this.getFindNextButton(), searchLabel, this.getSearchText(), showLabel, this.getShowTS0(), this.getShowTS1(), this.getShowTS2()});
        VBox.setVgrow((Node)fileBox, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)filterBox, (Priority)Priority.NEVER);
        VBox.setVgrow(this.getMessageTableView(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{fileBox, filterBox, this.getMessageTableView()});
    }

    private ProgressIndicator getLoadingIndicator() {
        if (this.mLoadingIndicator == null) {
            this.mLoadingIndicator = new ProgressIndicator();
            this.mLoadingIndicator.setProgress(-1.0);
            this.mLoadingIndicator.setVisible(false);
        }
        return this.mLoadingIndicator;
    }

    private void load(final File file) {
        if (file != null && file.exists()) {
            this.mMessages.clear();
            this.getLoadingIndicator().setVisible(true);
            this.getSelectedFileLabel().setText("Loading ...");
            final boolean useCompressed = this.getUseCompressedTalkgroups().isSelected();
            ThreadPool.CACHED.submit(new Runnable(){

                @Override
                public void run() {
                    ArrayList messages = new ArrayList();
                    DMRMessageFramer messageFramer = new DMRMessageFramer(null);
                    DecodeConfigDMR config = new DecodeConfigDMR();
                    config.setUseCompressedTalkgroups(useCompressed);
                    DMRMessageProcessor messageProcessor = new DMRMessageProcessor(config);
                    messageFramer.setListener(messageProcessor);
                    messageProcessor.setMessageListener(message -> messages.add(message));
                    try (BinaryReader reader = new BinaryReader(file.toPath(), 200);){
                        while (reader.hasNext()) {
                            ByteBuffer buffer = reader.next();
                            messageFramer.receive(buffer);
                        }
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                    Platform.runLater(() -> {
                        DmrViewer.this.getLoadingIndicator().setVisible(false);
                        DmrViewer.this.getSelectedFileLabel().setText(file.getName());
                        DmrViewer.this.mMessages.addAll((Collection)messages);
                        DmrViewer.this.getMessageTableView().scrollTo(0);
                    });
                }
            });
        }
    }

    private void updateFilters() {
        Predicate<IMessage> timeslotPredicate = message -> this.getShowTS0().isSelected() && message.getTimeslot() == 0 || this.getShowTS1().isSelected() && message.getTimeslot() == 1 || this.getShowTS2().isSelected() && message.getTimeslot() == 2;
        String filterText = this.getSearchText().getText();
        if (filterText == null || filterText.isEmpty()) {
            this.mFilteredMessages.setPredicate(timeslotPredicate);
        } else {
            Predicate<IMessage> textPredicate = message -> message.toString().toLowerCase().contains(filterText.toLowerCase());
            this.mFilteredMessages.setPredicate(timeslotPredicate.and(textPredicate));
        }
    }

    private void find(String text) {
        if (text != null && !text.isEmpty()) {
            for (IMessage message : this.mFilteredMessages) {
                if (!message.toString().toLowerCase().contains(text.toLowerCase())) continue;
                this.getMessageTableView().getSelectionModel().select((Object)message);
                this.getMessageTableView().scrollTo((Object)message);
                return;
            }
        }
    }

    private void findNext(String text) {
        if (text != null && !text.isEmpty()) {
            IMessage selected = (IMessage)this.getMessageTableView().getSelectionModel().getSelectedItem();
            if (selected == null) {
                this.find(text);
                return;
            }
            int row = this.mFilteredMessages.indexOf((Object)selected);
            for (int x = row + 1; x < this.mFilteredMessages.size(); ++x) {
                IMessage message;
                if (x >= this.mFilteredMessages.size() || !(message = (IMessage)this.mFilteredMessages.get(x)).toString().toLowerCase().contains(text.toLowerCase())) continue;
                this.getMessageTableView().getSelectionModel().select((Object)message);
                this.getMessageTableView().scrollTo((Object)message);
                return;
            }
        }
    }

    private TableView<IMessage> getMessageTableView() {
        if (this.mMessageTableView == null) {
            this.mMessageTableView = new TableView();
            this.mMessageTableView.setPlaceholder((Node)this.getLoadingIndicator());
            SortedList sortedList = new SortedList(this.mFilteredMessages);
            sortedList.comparatorProperty().bind((ObservableValue)this.mMessageTableView.comparatorProperty());
            this.mMessageTableView.setItems((ObservableList)sortedList);
            this.mMessageTableView.setOnKeyPressed(event -> {
                if (KEY_CODE_COPY.match(event)) {
                    TreeSet<Integer> rows = new TreeSet<Integer>();
                    for (TablePosition tablePosition : this.mMessageTableView.getSelectionModel().getSelectedCells()) {
                        rows.add(tablePosition.getRow());
                    }
                    StringBuilder sb = new StringBuilder();
                    boolean firstRow = true;
                    for (Integer row : rows) {
                        if (firstRow) {
                            firstRow = false;
                        } else {
                            sb.append('\n');
                        }
                        boolean firstCol = true;
                        for (TableColumn column : this.mMessageTableView.getColumns()) {
                            if (firstCol) {
                                firstCol = false;
                            } else {
                                sb.append('\t');
                            }
                            Object cellData = column.getCellData(row.intValue());
                            sb.append(cellData == null ? "" : cellData.toString());
                        }
                    }
                    ClipboardContent clipboardContent = new ClipboardContent();
                    clipboardContent.putString(sb.toString());
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                }
            });
            TableColumn timestampColumn = new TableColumn();
            timestampColumn.setPrefWidth(110.0);
            timestampColumn.setText("Time");
            timestampColumn.setCellValueFactory((Callback)new PropertyValueFactory("timestamp"));
            TableColumn timeslotColumn = new TableColumn();
            timeslotColumn.setPrefWidth(35.0);
            timeslotColumn.setText("TS");
            timeslotColumn.setCellValueFactory((Callback)new PropertyValueFactory("timeslot"));
            TableColumn validColumn = new TableColumn();
            validColumn.setPrefWidth(50.0);
            validColumn.setText("Valid");
            validColumn.setCellValueFactory((Callback)new PropertyValueFactory("valid"));
            TableColumn messageColumn = new TableColumn();
            messageColumn.setPrefWidth(1000.0);
            messageColumn.setText("Message");
            messageColumn.setCellValueFactory(param -> {
                SimpleStringProperty property = new SimpleStringProperty();
                Object patt0$temp = param.getValue();
                if (patt0$temp instanceof IMessage) {
                    IMessage message = (IMessage)patt0$temp;
                    property.set(message.toString());
                }
                return property;
            });
            this.mMessageTableView.getColumns().addAll((Object[])new TableColumn[]{timestampColumn, validColumn, timeslotColumn, messageColumn});
        }
        return this.mMessageTableView;
    }

    private Button getSelectFileButton() {
        if (this.mSelectFileButton == null) {
            this.mSelectFileButton = new Button("Select ...");
            this.mSelectFileButton.onActionProperty().set(event -> {
                File file;
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Select DMR .bits Recording");
                String lastDirectory = this.mPreferences.get(LAST_SELECTED_DIRECTORY, null);
                if (lastDirectory != null && (file = new File(lastDirectory)).exists() && file.isDirectory()) {
                    fileChooser.setInitialDirectory(file);
                }
                fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("sdrtrunk bits recording", new String[]{"*.bits"}));
                File selected = fileChooser.showOpenDialog(this.getScene().getWindow());
                if (selected != null) {
                    this.mPreferences.put(LAST_SELECTED_DIRECTORY, selected.getParent());
                    this.load(selected);
                }
            });
        }
        return this.mSelectFileButton;
    }

    private Label getSelectedFileLabel() {
        if (this.mSelectedFileLabel == null) {
            this.mSelectedFileLabel = new Label(" ");
        }
        return this.mSelectedFileLabel;
    }

    private CheckBox getShowTS0() {
        if (this.mShowTS0 == null) {
            this.mShowTS0 = new CheckBox("TS0");
            this.mShowTS0.setSelected(true);
            this.mShowTS0.setOnAction(event -> this.updateFilters());
        }
        return this.mShowTS0;
    }

    private CheckBox getShowTS1() {
        if (this.mShowTS1 == null) {
            this.mShowTS1 = new CheckBox("TS1");
            this.mShowTS1.setSelected(true);
            this.mShowTS1.setOnAction(event -> this.updateFilters());
        }
        return this.mShowTS1;
    }

    private CheckBox getShowTS2() {
        if (this.mShowTS2 == null) {
            this.mShowTS2 = new CheckBox("TS2");
            this.mShowTS2.setSelected(true);
            this.mShowTS2.setOnAction(event -> this.updateFilters());
        }
        return this.mShowTS2;
    }

    private TextField getSearchText() {
        if (this.mSearchText == null) {
            this.mSearchText = new TextField();
            this.mSearchText.textProperty().addListener((observable, oldValue, newValue) -> this.updateFilters());
        }
        return this.mSearchText;
    }

    private TextField getFindText() {
        if (this.mFindText == null) {
            this.mFindText = new TextField();
            this.mFindText.setOnKeyPressed(event -> {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    this.getFindButton().fire();
                }
            });
            this.mFindText.textProperty().addListener((observable, oldValue, newValue) -> this.updateFilters());
        }
        return this.mFindText;
    }

    private Button getFindButton() {
        if (this.mFindButton == null) {
            this.mFindButton = new Button("Find");
            this.mFindButton.setOnAction(event -> this.find(this.getFindText().getText()));
        }
        return this.mFindButton;
    }

    private Button getFindNextButton() {
        if (this.mFindNextButton == null) {
            this.mFindNextButton = new Button("Next");
            this.mFindNextButton.setOnAction(event -> this.findNext(this.getFindText().getText()));
        }
        return this.mFindNextButton;
    }

    private CheckBox getUseCompressedTalkgroups() {
        if (this.mUseCompressedTalkgroups == null) {
            this.mUseCompressedTalkgroups = new CheckBox("Use Hytera Tier III Compressed Talkgroups");
        }
        return this.mUseCompressedTalkgroups;
    }
}

