/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.tuner;

import io.github.dsheirer.gui.preference.tuner.RspDuoSelectionMode;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.preference.source.TunerPreference;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class TunerPreferenceEditor
extends HBox {
    private static final String HELP_TEXT_POLYPHASE = "Processes all channels from tuner.  This channelizer is more efficient when decoding 3 or more channels.";
    private static final String HELP_TEXT_HETERODYNE = "Processes each channel on-demand.  This channelizer may work better for computers with constrained resources when processing a small number of channels.";
    private TunerPreference mTunerPreference;
    private GridPane mEditorPane;
    private ChoiceBox<ChannelizerType> mChannelizerTypeChoiceBox;
    private Label mChannelizerLabel;
    private Label mPolyphaseLabel;
    private Label mHelpTextPolyphaseLabel;
    private Label mHeterodyneLabel;
    private Label mHelpTextHeterodyneLabel;
    private ChoiceBox<RspDuoSelectionMode> mRspDuoTunerModeChoiceBox;
    private Label mRspDuoModeLabel;

    public TunerPreferenceEditor(UserPreferences userPreferences) {
        this.mTunerPreference = userPreferences.getTunerPreference();
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            int row = 0;
            this.mEditorPane = new GridPane();
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            GridPane.setHalignment((Node)this.getChannelizerLabel(), (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)this.getChannelizerLabel(), 0, row);
            this.mEditorPane.add(this.getChannelizerTypeChoiceBox(), 1, row);
            this.mEditorPane.add((Node)this.getPolyphaseLabel(), 0, ++row, 2, 1);
            this.mEditorPane.add((Node)this.getHelpTextPolyphaseLabel(), 0, ++row, 2, 3);
            this.mEditorPane.add((Node)new Label(" "), 0, row += 3);
            this.mEditorPane.add((Node)this.getHeterodyneLabel(), 0, ++row, 2, 1);
            this.mEditorPane.add((Node)this.getHelpTextHeterodyneLabel(), 0, ++row, 2, 3);
            this.mEditorPane.add((Node)new Separator(Orientation.HORIZONTAL), 0, row += 3, 2, 1);
            this.mEditorPane.add((Node)this.getRspDuoModeLabel(), 0, ++row);
            this.mEditorPane.add(this.getRspDuoTunerModeChoiceBox(), 1, row);
        }
        return this.mEditorPane;
    }

    private Label getChannelizerLabel() {
        if (this.mChannelizerLabel == null) {
            this.mChannelizerLabel = new Label("Channelizer Type");
        }
        return this.mChannelizerLabel;
    }

    private ChoiceBox<ChannelizerType> getChannelizerTypeChoiceBox() {
        if (this.mChannelizerTypeChoiceBox == null) {
            this.mChannelizerTypeChoiceBox = new ChoiceBox();
            this.mChannelizerTypeChoiceBox.getItems().addAll((Object[])ChannelizerType.values());
            ChannelizerType current = this.mTunerPreference.getChannelizerType();
            this.mChannelizerTypeChoiceBox.getSelectionModel().select((Object)current);
            this.mChannelizerTypeChoiceBox.setOnAction(event -> {
                ChannelizerType selected = (ChannelizerType)((Object)((Object)this.mChannelizerTypeChoiceBox.getSelectionModel().getSelectedItem()));
                this.mTunerPreference.setChannelizerType(selected);
                Label label = new Label("Please restart the application for this change to take effect");
                label.setWrapText(true);
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.getDialogPane().setContent((Node)label);
                alert.initOwner(this.getChannelizerTypeChoiceBox().getScene().getWindow());
                alert.show();
            });
        }
        return this.mChannelizerTypeChoiceBox;
    }

    private Label getPolyphaseLabel() {
        if (this.mPolyphaseLabel == null) {
            this.mPolyphaseLabel = new Label("Polyphase (default)");
        }
        return this.mPolyphaseLabel;
    }

    private Label getHelpTextPolyphaseLabel() {
        if (this.mHelpTextPolyphaseLabel == null) {
            this.mHelpTextPolyphaseLabel = new Label(HELP_TEXT_POLYPHASE);
            this.mHelpTextPolyphaseLabel.setWrapText(true);
        }
        return this.mHelpTextPolyphaseLabel;
    }

    private Label getHeterodyneLabel() {
        if (this.mHeterodyneLabel == null) {
            this.mHeterodyneLabel = new Label("Heterodyne");
        }
        return this.mHeterodyneLabel;
    }

    private Label getHelpTextHeterodyneLabel() {
        if (this.mHelpTextHeterodyneLabel == null) {
            this.mHelpTextHeterodyneLabel = new Label(HELP_TEXT_HETERODYNE);
            this.mHelpTextHeterodyneLabel.setWrapText(true);
        }
        return this.mHelpTextHeterodyneLabel;
    }

    private ChoiceBox<RspDuoSelectionMode> getRspDuoTunerModeChoiceBox() {
        if (this.mRspDuoTunerModeChoiceBox == null) {
            this.mRspDuoTunerModeChoiceBox = new ChoiceBox();
            this.mRspDuoTunerModeChoiceBox.getItems().addAll((Object[])RspDuoSelectionMode.values());
            RspDuoSelectionMode current = this.mTunerPreference.getRspDuoTunerMode();
            this.mRspDuoTunerModeChoiceBox.getSelectionModel().select((Object)current);
            this.mRspDuoTunerModeChoiceBox.setOnAction(event -> {
                RspDuoSelectionMode selected = (RspDuoSelectionMode)((Object)((Object)this.mRspDuoTunerModeChoiceBox.getSelectionModel().getSelectedItem()));
                this.mTunerPreference.setRspDuoTunerMode(selected);
                Label label = new Label("Please restart the application for this change to take effect");
                label.setWrapText(true);
                Alert alert = new Alert(Alert.AlertType.WARNING);
                alert.getDialogPane().setContent((Node)label);
                alert.initOwner(this.getRspDuoTunerModeChoiceBox().getScene().getWindow());
                alert.show();
            });
        }
        return this.mRspDuoTunerModeChoiceBox;
    }

    private Label getRspDuoModeLabel() {
        if (this.mRspDuoModeLabel == null) {
            this.mRspDuoModeLabel = new Label("SDRPlay RSPduo Selection Mode");
        }
        return this.mRspDuoModeLabel;
    }
}

