/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.record;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.record.RecordPreference;
import io.github.dsheirer.record.RecordFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordPreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(RecordPreferenceEditor.class);
    private RecordPreference mRecordPreference;
    private GridPane mEditorPane;
    private ComboBox<RecordFormat> mRecordFormatComboBox;

    public RecordPreferenceEditor(UserPreferences userPreferences) {
        this.mRecordPreference = userPreferences.getRecordPreference();
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            Label label = new Label("Audio Recording Format:");
            this.mEditorPane.add((Node)label, 0, 0);
            this.mEditorPane.add(this.getRecordFormatComboBox(), 1, 0);
        }
        return this.mEditorPane;
    }

    private ComboBox<RecordFormat> getRecordFormatComboBox() {
        if (this.mRecordFormatComboBox == null) {
            this.mRecordFormatComboBox = new ComboBox();
            this.mRecordFormatComboBox.getItems().addAll((Object[])RecordFormat.values());
            this.mRecordFormatComboBox.getSelectionModel().select((Object)this.mRecordPreference.getAudioRecordFormat());
            this.mRecordFormatComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<RecordFormat>(){

                public void changed(ObservableValue<? extends RecordFormat> observable, RecordFormat oldValue, RecordFormat newValue) {
                    RecordPreferenceEditor.this.mRecordPreference.setAudioRecordFormat(newValue);
                }
            });
        }
        return this.mRecordFormatComboBox;
    }
}

