/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.playback;

import io.github.dsheirer.dsp.oscillator.ScalarRealOscillator;
import io.github.dsheirer.gui.preference.playback.ToneFrequency;
import io.github.dsheirer.gui.preference.playback.ToneVolume;

public class ToneUtil {
    private static final double MAX_TONE_VOLUME = 0.5;

    public static float[] getTone(ToneFrequency toneFrequency, ToneVolume toneVolume, int sampleCount) {
        ScalarRealOscillator oscillator = new ScalarRealOscillator(toneFrequency.getValue(), 8000.0);
        float[] samples = oscillator.generate(sampleCount);
        double gain = 0.5 * ((double)toneVolume.getValue() / 10.0);
        int x = 0;
        while (x < samples.length) {
            int n = x++;
            samples[n] = (float)((double)samples[n] * gain);
        }
        if (sampleCount > 10) {
            for (x = 0; x < 10; ++x) {
                int n = x;
                samples[n] = samples[n] * ((float)x / 10.0f);
            }
            for (x = 0; x < 10; ++x) {
                int n = samples.length - 1 - x;
                samples[n] = samples[n] * ((float)x / 10.0f);
            }
        }
        return samples;
    }
}

