/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.mp3;

import io.github.dsheirer.audio.convert.InputAudioFormat;
import io.github.dsheirer.audio.convert.MP3Setting;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.mp3.MP3Preference;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MP3PreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(MP3PreferenceEditor.class);
    private MP3Preference mMP3Preference;
    private GridPane mEditorPane;
    private ComboBox<MP3Setting> mMP3SettingComboBox;
    private ComboBox<InputAudioFormat> mAudioSampleRateComboBox;
    private CheckBox mNormalizeAudioCheckBox;

    public MP3PreferenceEditor(UserPreferences userPreferences) {
        this.mMP3Preference = userPreferences.getMP3Preference();
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            int row = 0;
            Label topLabel = new Label("MP3 Encoder Preferences");
            this.mEditorPane.add((Node)topLabel, 0, row++, 2, 1);
            this.mEditorPane.add((Node)this.getNormalizeAudioCheckBox(), 1, row++);
            Label label = new Label("(LAME) Encoder Setting:");
            GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)label, 0, row);
            this.mEditorPane.add(this.getMP3SettingComboBox(), 1, row++);
            Label sampleRateLabel = new Label("Input Audio Sample Rate:");
            GridPane.setHalignment((Node)sampleRateLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)sampleRateLabel, 0, row);
            this.mEditorPane.add(this.getAudioSampleRateComboBox(), 1, row++);
            Label notice = new Label("Note: sdrtrunk default 8 kHz audio rate is resampled to input sample rate before MP3 encoding");
            this.mEditorPane.add((Node)notice, 0, row++, 2, 1);
        }
        return this.mEditorPane;
    }

    private ComboBox<MP3Setting> getMP3SettingComboBox() {
        if (this.mMP3SettingComboBox == null) {
            this.mMP3SettingComboBox = new ComboBox();
            this.mMP3SettingComboBox.getItems().addAll((Object[])MP3Setting.values());
            this.mMP3SettingComboBox.getSelectionModel().select((Object)this.mMP3Preference.getMP3Setting());
            this.mMP3SettingComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.mMP3Preference.setMP3Setting((MP3Setting)((Object)newValue));
                this.updateAudioSampleRateComboBox();
            });
        }
        return this.mMP3SettingComboBox;
    }

    private void updateAudioSampleRateComboBox() {
        InputAudioFormat currentSelection = (InputAudioFormat)((Object)this.getAudioSampleRateComboBox().getSelectionModel().getSelectedItem());
        MP3Setting setting = (MP3Setting)((Object)this.getMP3SettingComboBox().getSelectionModel().getSelectedItem());
        this.getAudioSampleRateComboBox().getItems().clear();
        this.getAudioSampleRateComboBox().getItems().addAll(setting.getSupportedSampleRates());
        if (currentSelection != null && this.getAudioSampleRateComboBox().getItems().contains((Object)currentSelection)) {
            this.getAudioSampleRateComboBox().getSelectionModel().select((Object)currentSelection);
        } else {
            this.getAudioSampleRateComboBox().getSelectionModel().select((Object)InputAudioFormat.getDefault());
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Sample Rate Updated");
            alert.setHeaderText("Input Sample Rate Updated");
            Label wrappingLabel = new Label("Previous input sample rate [" + String.valueOf((Object)currentSelection) + "] is not supported with encoder setting [" + String.valueOf((Object)setting) + "].  Sample rate updated to default.");
            wrappingLabel.setWrapText(true);
            alert.getDialogPane().setContent((Node)wrappingLabel);
            alert.show();
        }
    }

    private ComboBox<InputAudioFormat> getAudioSampleRateComboBox() {
        if (this.mAudioSampleRateComboBox == null) {
            this.mAudioSampleRateComboBox = new ComboBox();
            this.mAudioSampleRateComboBox.getItems().addAll((Object[])InputAudioFormat.values());
            this.mAudioSampleRateComboBox.getSelectionModel().select((Object)this.mMP3Preference.getAudioSampleRate());
            this.mAudioSampleRateComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    this.mMP3Preference.setAudioSampleRate((InputAudioFormat)((Object)newValue));
                }
            });
        }
        return this.mAudioSampleRateComboBox;
    }

    private CheckBox getNormalizeAudioCheckBox() {
        if (this.mNormalizeAudioCheckBox == null) {
            this.mNormalizeAudioCheckBox = new CheckBox("Normalize Audio Before Encoding");
            this.mNormalizeAudioCheckBox.setSelected(this.mMP3Preference.isNormalizeAudioBeforeEncode());
            this.mNormalizeAudioCheckBox.onActionProperty().set(event -> this.mMP3Preference.setNormalizeAudioBeforeEncode(this.getNormalizeAudioCheckBox().isSelected()));
        }
        return this.mNormalizeAudioCheckBox;
    }
}

