/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.duplicate;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.duplicate.DuplicateCallDetectionPreference;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateCallPreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(DuplicateCallPreferenceEditor.class);
    private DuplicateCallDetectionPreference mPreference;
    private GridPane mEditorPane;
    private ToggleSwitch mDetectDuplicateTalkgroups;
    private ToggleSwitch mDetectDuplicateRadios;
    private ToggleSwitch mSuppressDuplicateListening;
    private ToggleSwitch mSuppressDuplicateRecording;
    private ToggleSwitch mSuppressDuplicateStreaming;

    public DuplicateCallPreferenceEditor(UserPreferences userPreferences) {
        this.mPreference = userPreferences.getDuplicateCallDetectionPreference();
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            int row = 0;
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            Label detectionLabel = new Label("Duplicate Call Detection.  Detect duplicate calls across channels that share a common System name in each channel configuration.");
            detectionLabel.setWrapText(true);
            GridPane.setConstraints((Node)detectionLabel, (int)0, (int)row, (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)detectionLabel);
            GridPane.setConstraints((Node)this.getDetectDuplicateTalkgroups(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getDetectDuplicateTalkgroups());
            Label talkgroupLabel = new Label("Talkgroup.  Detect duplicate calls by matching talkgroup or patchgroup values");
            talkgroupLabel.setWrapText(true);
            GridPane.setConstraints((Node)talkgroupLabel, (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)talkgroupLabel);
            GridPane.setConstraints((Node)this.getDetectDuplicateRadios(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getDetectDuplicateRadios());
            Label radioLabel = new Label("Radio ID.  Detect duplicate calls by matching radio identifiers.");
            radioLabel.setWrapText(true);
            GridPane.setConstraints((Node)radioLabel, (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)radioLabel);
            Label warningLabel = new Label("Note: be careful when enabling duplicate call detection by Radio ID because this can produce unintended side-effects.  For example, if you have two talkgroups with talkgroup 1 set to record and talkgroup 2 set to stream and dispatch radio ID 1234 makes a simultaneous call to both talkgroup 1 and talkgroup 2, there is no way to control which call audio (talkgroup 1 or 2) gets flagged as the duplicate call and therefore either the audio for talkgroup 1 doesn't record, or the audio for talkgroup 2 doesn't stream.");
            warningLabel.setWrapText(true);
            GridPane.setConstraints((Node)warningLabel, (int)0, (int)(++row), (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)warningLabel);
            Separator separator = new Separator();
            GridPane.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)separator, (int)0, (int)(++row), (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)separator);
            Label suppressionLabel = new Label("Duplicate Call Suppression.  When duplicate call audio is detected, suppress the audio during:");
            suppressionLabel.setWrapText(true);
            GridPane.setConstraints((Node)suppressionLabel, (int)0, (int)(++row), (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)suppressionLabel);
            GridPane.setConstraints((Node)this.getSuppressDuplicateListening(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getSuppressDuplicateListening());
            Label listeningLabel = new Label("Listening");
            listeningLabel.setWrapText(true);
            GridPane.setConstraints((Node)listeningLabel, (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)listeningLabel);
            GridPane.setConstraints((Node)this.getSuppressDuplicateRecording(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getSuppressDuplicateRecording());
            Label recordingLabel = new Label("Recording");
            recordingLabel.setWrapText(true);
            GridPane.setConstraints((Node)recordingLabel, (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)recordingLabel);
            GridPane.setConstraints((Node)this.getSuppressDuplicateStreaming(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getSuppressDuplicateStreaming());
            Label streamingLabel = new Label("Streaming");
            streamingLabel.setWrapText(true);
            GridPane.setConstraints((Node)streamingLabel, (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)streamingLabel);
        }
        return this.mEditorPane;
    }

    private ToggleSwitch getDetectDuplicateTalkgroups() {
        if (this.mDetectDuplicateTalkgroups == null) {
            this.mDetectDuplicateTalkgroups = new ToggleSwitch();
            this.mDetectDuplicateTalkgroups.setSelected(this.mPreference.isDuplicateCallDetectionByTalkgroupEnabled());
            this.mDetectDuplicateTalkgroups.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPreference.setDuplicateCallDetectionByTalkgroupEnabled((boolean)newValue));
        }
        return this.mDetectDuplicateTalkgroups;
    }

    private ToggleSwitch getDetectDuplicateRadios() {
        if (this.mDetectDuplicateRadios == null) {
            this.mDetectDuplicateRadios = new ToggleSwitch();
            this.mDetectDuplicateRadios.setSelected(this.mPreference.isDuplicateCallDetectionByRadioEnabled());
            this.mDetectDuplicateRadios.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPreference.setDuplicateCallDetectionByRadioEnabled((boolean)newValue));
        }
        return this.mDetectDuplicateRadios;
    }

    private ToggleSwitch getSuppressDuplicateListening() {
        if (this.mSuppressDuplicateListening == null) {
            this.mSuppressDuplicateListening = new ToggleSwitch();
            this.mSuppressDuplicateListening.disableProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.getDetectDuplicateTalkgroups().selectedProperty().not(), (ObservableBooleanValue)this.getDetectDuplicateRadios().selectedProperty().not()));
            this.mSuppressDuplicateListening.setSelected(this.mPreference.isDuplicatePlaybackSuppressionEnabled());
            this.mSuppressDuplicateListening.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPreference.setDuplicatePlaybackSuppressionEnabled((boolean)newValue));
        }
        return this.mSuppressDuplicateListening;
    }

    private ToggleSwitch getSuppressDuplicateRecording() {
        if (this.mSuppressDuplicateRecording == null) {
            this.mSuppressDuplicateRecording = new ToggleSwitch();
            this.mSuppressDuplicateRecording.disableProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.getDetectDuplicateTalkgroups().selectedProperty().not(), (ObservableBooleanValue)this.getDetectDuplicateRadios().selectedProperty().not()));
            this.mSuppressDuplicateRecording.setSelected(this.mPreference.isDuplicateRecordingSuppressionEnabled());
            this.mSuppressDuplicateRecording.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPreference.setDuplicateRecordingSuppressionEnabled((boolean)newValue));
        }
        return this.mSuppressDuplicateRecording;
    }

    private ToggleSwitch getSuppressDuplicateStreaming() {
        if (this.mSuppressDuplicateStreaming == null) {
            this.mSuppressDuplicateStreaming = new ToggleSwitch();
            this.mSuppressDuplicateStreaming.disableProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.getDetectDuplicateTalkgroups().selectedProperty().not(), (ObservableBooleanValue)this.getDetectDuplicateRadios().selectedProperty().not()));
            this.mSuppressDuplicateStreaming.setSelected(this.mPreference.isDuplicateStreamingSuppressionEnabled());
            this.mSuppressDuplicateStreaming.selectedProperty().addListener((observable, oldValue, newValue) -> this.mPreference.setDuplicateStreamingSuppressionEnabled((boolean)newValue));
        }
        return this.mSuppressDuplicateStreaming;
    }
}

