/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.decoder;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.jmbe.JmbeEditorRequest;
import io.github.dsheirer.jmbe.github.GitHub;
import io.github.dsheirer.jmbe.github.Release;
import io.github.dsheirer.jmbe.github.Version;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.util.ThreadPool;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmbeLibraryPreferenceEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeLibraryPreferenceEditor.class);
    private static final String PATH_NOT_SET = "(not set)";
    private static final String CREATE_LIBRARY = "Create Library";
    private static final String CHECK_FOR_UPDATE = "Check For Library Update";
    private static final String LIBRARY_NOT_SETUP = "None.  Click Select or Create Library button to setup.";
    private UserPreferences mUserPreferences;
    private GridPane mEditorPane;
    private Label mJmbeLibraryLabel;
    private Label mJmbeVersionLabel;
    private Label mPathToJmbeLibraryLabel;
    private Button mSelectButton;
    private Button mResetButton;
    private Button mCreateButton;
    private HBox mButtonsBox;
    private CheckBox mAlertUserWhenMissingCheckBox;

    public JmbeLibraryPreferenceEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        this.getChildren().addAll((Object[])new Node[]{this.getEditorPane(), this.getButtonsBox(), this.getAlertUserWhenMissingCheckBox()});
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    private CheckBox getAlertUserWhenMissingCheckBox() {
        if (this.mAlertUserWhenMissingCheckBox == null) {
            this.mAlertUserWhenMissingCheckBox = new CheckBox("Alert when decoder requires missing JMBE library");
            this.mAlertUserWhenMissingCheckBox.setSelected(this.mUserPreferences.getJmbeLibraryPreference().getAlertIfMissingLibraryRequired());
            this.mAlertUserWhenMissingCheckBox.setOnAction(event -> {
                boolean alert = this.mAlertUserWhenMissingCheckBox.isSelected();
                this.mUserPreferences.getJmbeLibraryPreference().setAlertIfMissingLibraryRequired(alert);
            });
        }
        return this.mAlertUserWhenMissingCheckBox;
    }

    private HBox getButtonsBox() {
        if (this.mButtonsBox == null) {
            this.mButtonsBox = new HBox();
            this.mButtonsBox.setSpacing(10.0);
            this.mButtonsBox.getChildren().addAll((Object[])new Node[]{this.getCreateButton(), this.getSelectButton(), this.getResetButton()});
        }
        return this.mButtonsBox;
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(10.0);
            int row = 0;
            this.mEditorPane.add((Node)this.getJmbeLibraryLabel(), 0, row, 2, 1);
            Label versionLabel = new Label("Current Version:");
            GridPane.setHalignment((Node)versionLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)versionLabel, 0, ++row);
            this.mEditorPane.add((Node)this.getJmbeVersionLabel(), 1, row);
            Label fileLabel = new Label("File:");
            GridPane.setHalignment((Node)fileLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)fileLabel, 0, ++row);
            this.mEditorPane.add((Node)this.getPathToJmbeLibraryLabel(), 1, row);
        }
        return this.mEditorPane;
    }

    private Button getCreateButton() {
        if (this.mCreateButton == null) {
            this.mCreateButton = new Button();
            this.mCreateButton.setText(this.mUserPreferences.getJmbeLibraryPreference().getPathJmbeLibrary() != null ? CHECK_FOR_UPDATE : CREATE_LIBRARY);
            this.mCreateButton.setOnAction(event -> this.checkForUpdatedLibrary());
        }
        return this.mCreateButton;
    }

    private void checkForUpdatedLibrary() {
        ThreadPool.CACHED.execute(() -> {
            try {
                boolean canUpdate;
                Version current = this.mUserPreferences.getJmbeLibraryPreference().getCurrentVersion();
                final Release release = GitHub.getLatestRelease("https://api.github.com/repos/dsheirer/jmbe/releases");
                mLog.info("Checking for JMBE Library Updates ...");
                mLog.info("Current: " + (current != null ? current.toString() : "empty"));
                boolean bl = canUpdate = release != null && (current == null || release.getVersion().compareTo(current) > 0);
                if (release != null) {
                    mLog.info("Available: " + release.getVersion().toString());
                }
                if (canUpdate) {
                    mLog.info("JMBE Library update is available");
                } else {
                    mLog.info("No JMBE library update is available at this time");
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (canUpdate) {
                                String content = "JMBE library version " + release.getVersion().toString() + " is available.  Would you like to download the latest source code and create an updated JMBE library?";
                                Alert alert = new Alert(Alert.AlertType.INFORMATION, content, new ButtonType[]{ButtonType.YES, ButtonType.NO});
                                alert.setResizable(true);
                                alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                                alert.setTitle("JMBE Library Update Check");
                                alert.setHeaderText("Update is available");
                                alert.initOwner(JmbeLibraryPreferenceEditor.this.getCreateButton().getScene().getWindow());
                                alert.showAndWait().ifPresent(buttonType -> {
                                    if (buttonType == ButtonType.YES) {
                                        mLog.info("Posting JMBE editor request to event bus");
                                        MyEventBus.getGlobalEventBus().post((Object)new JmbeEditorRequest(release));
                                    }
                                });
                            } else {
                                Alert alert = new Alert(Alert.AlertType.INFORMATION, "No JMBE library update is available.", new ButtonType[]{ButtonType.OK});
                                alert.setTitle("JMBE Library Update Check");
                                if (release != null) {
                                    alert.setHeaderText("No update available");
                                } else {
                                    alert.setHeaderText("Unable to determine latest release version.  Check network connection");
                                }
                                alert.initOwner(JmbeLibraryPreferenceEditor.this.getCreateButton().getScene().getWindow());
                                alert.showAndWait();
                            }
                        }
                        catch (Throwable t) {
                            mLog.error("Error during JavaFX portion of create library");
                        }
                    }
                });
            }
            catch (Throwable t) {
                mLog.error("Error during create library", t);
            }
        });
    }

    private Label getJmbeLibraryLabel() {
        if (this.mJmbeLibraryLabel == null) {
            this.mJmbeLibraryLabel = new Label("JMBE Audio Library");
        }
        return this.mJmbeLibraryLabel;
    }

    private Label getJmbeVersionLabel() {
        if (this.mJmbeVersionLabel == null) {
            this.mJmbeVersionLabel = new Label();
            Version version = this.mUserPreferences.getJmbeLibraryPreference().getCurrentVersion();
            if (version != null) {
                this.mJmbeVersionLabel.setText(version.toString());
            } else {
                this.mJmbeVersionLabel.setText(LIBRARY_NOT_SETUP);
            }
        }
        return this.mJmbeVersionLabel;
    }

    private Button getSelectButton() {
        if (this.mSelectButton == null) {
            this.mSelectButton = new Button("Select...");
            this.mSelectButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Stage stage;
                    File selected;
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle("Select JMBE Audio Library Location");
                    Path path = JmbeLibraryPreferenceEditor.this.mUserPreferences.getDirectoryPreference().getDefaultJmbeDirectory();
                    if (Files.exists(path, new LinkOption[0])) {
                        fileChooser.setInitialDirectory(path.toFile());
                    }
                    if ((selected = fileChooser.showOpenDialog((Window)(stage = (Stage)JmbeLibraryPreferenceEditor.this.getSelectButton().getScene().getWindow()))) != null) {
                        JmbeLibraryPreferenceEditor.this.mUserPreferences.getJmbeLibraryPreference().setPathJmbeLibrary(selected.toPath());
                    }
                }
            });
        }
        return this.mSelectButton;
    }

    private Button getResetButton() {
        if (this.mResetButton == null) {
            this.mResetButton = new Button("Reset");
            this.mResetButton.setOnAction(event -> this.mUserPreferences.getJmbeLibraryPreference().resetPathJmbeLibrary());
        }
        return this.mResetButton;
    }

    private Label getPathToJmbeLibraryLabel() {
        if (this.mPathToJmbeLibraryLabel == null) {
            Path path = this.mUserPreferences.getJmbeLibraryPreference().getPathJmbeLibrary();
            this.mPathToJmbeLibraryLabel = new Label(path != null ? path.toString() : PATH_NOT_SET);
        }
        return this.mPathToJmbeLibraryLabel;
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType != null && preferenceType == PreferenceType.JMBE_LIBRARY) {
            Path path = this.mUserPreferences.getJmbeLibraryPreference().getPathJmbeLibrary();
            this.getPathToJmbeLibraryLabel().setText(path != null ? path.toString() : PATH_NOT_SET);
            Version version = this.mUserPreferences.getJmbeLibraryPreference().getCurrentVersion();
            this.getJmbeVersionLabel().setText(version != null ? version.toString() : LIBRARY_NOT_SETUP);
            this.getCreateButton().setText(this.mUserPreferences.getJmbeLibraryPreference().getPathJmbeLibrary() != null ? CHECK_FOR_UPDATE : CREATE_LIBRARY);
            this.getAlertUserWhenMissingCheckBox().setSelected(this.mUserPreferences.getJmbeLibraryPreference().getAlertIfMissingLibraryRequired());
        }
    }
}

