/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.calibration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.preference.CalibrateRequest;
import io.github.dsheirer.log.TextAreaLogAppender;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.calibration.VectorCalibrationPreference;
import io.github.dsheirer.util.ThreadPool;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationManager;
import java.util.List;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCalibrationPreferenceEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(VectorCalibrationPreferenceEditor.class);
    private VectorCalibrationPreference mPreference;
    private GridPane mEditorPane;
    private ToggleSwitch mHideDialogSwitch;
    private ToggleSwitch mVectorEnabled;
    private Label mCalibrationsPendingValue;
    private Button mResetAllButton;
    private Button mCalibrateButton;
    private ProgressBar mProgressBar;
    private Label mCalibratingLabel;
    private TextArea mConsoleTextArea;
    private TextAreaLogAppender mTextAreaLogAppender;

    public VectorCalibrationPreferenceEditor(UserPreferences userPreferences) {
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.mPreference = userPreferences.getVectorCalibrationPreference();
        this.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        VBox vbox = new VBox();
        vbox.setMaxHeight(Double.MAX_VALUE);
        vbox.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)vbox, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.getEditorPane(), (Priority)Priority.NEVER);
        vbox.getChildren().add((Object)this.getEditorPane());
        ScrollPane scrollPane = new ScrollPane((Node)this.getConsoleTextArea());
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        VBox.setVgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        vbox.getChildren().add((Object)scrollPane);
        this.getChildren().add((Object)vbox);
    }

    @Subscribe
    public void process(CalibrateRequest request) {
        this.getCalibrateButton().fire();
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            int row = 0;
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            Label titleLabel = new Label("CPU Vector SIMD Preferences");
            GridPane.setConstraints((Node)titleLabel, (int)0, (int)row++, (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)titleLabel);
            GridPane.setConstraints((Node)this.getVectorEnabledToggleSwitch(), (int)0, (int)row);
            GridPane.setHalignment((Node)this.getVectorEnabledToggleSwitch(), (HPos)HPos.RIGHT);
            this.mEditorPane.getChildren().add((Object)this.getVectorEnabledToggleSwitch());
            Label enableSimdLabel = new Label("Enable SIMD Vector Operations");
            GridPane.setConstraints((Node)enableSimdLabel, (int)1, (int)row++);
            this.mEditorPane.getChildren().add((Object)enableSimdLabel);
            GridPane.setConstraints((Node)this.getHideDialogSwitch(), (int)0, (int)row);
            GridPane.setHalignment((Node)this.getHideDialogSwitch(), (HPos)HPos.RIGHT);
            this.mEditorPane.getChildren().add((Object)this.getHideDialogSwitch());
            Label hideDialogLabel = new Label("Don't Show Calibration Dialog When New Calibrations Are Available");
            GridPane.setConstraints((Node)hideDialogLabel, (int)1, (int)row++);
            this.mEditorPane.getChildren().add((Object)hideDialogLabel);
            GridPane.setConstraints((Node)this.getCalibrationsPendingValue(), (int)0, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getCalibrationsPendingValue());
            Label calibrationsPendingLabel = new Label("Calibrations To Perform");
            GridPane.setHalignment((Node)this.getCalibrationsPendingValue(), (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)calibrationsPendingLabel, (int)1, (int)row++);
            this.mEditorPane.getChildren().add((Object)calibrationsPendingLabel);
            this.updateControls();
            GridPane.setConstraints((Node)this.getCalibratingLabel(), (int)0, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getCalibratingLabel());
            GridPane.setConstraints((Node)this.getProgressBar(), (int)1, (int)row++);
            this.mEditorPane.getChildren().add((Object)this.getProgressBar());
            HBox buttonsBox = new HBox();
            buttonsBox.setSpacing(10.0);
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getCalibrateButton(), this.getResetAllButton()});
            GridPane.setHalignment((Node)buttonsBox, (HPos)HPos.CENTER);
            GridPane.setConstraints((Node)buttonsBox, (int)0, (int)row, (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)buttonsBox);
        }
        return this.mEditorPane;
    }

    private void enableConsoleLogging() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger(Calibration.class);
        logger.setLevel(Level.INFO);
        logger.addAppender((Appender)this.getTextAreaLogAppender());
        this.getTextAreaLogAppender().start();
    }

    private void disableConsoleLogging() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = loggerContext.getLogger(Calibration.class);
        logger.detachAppender((Appender)this.getTextAreaLogAppender());
        this.getTextAreaLogAppender().stop();
    }

    private TextAreaLogAppender getTextAreaLogAppender() {
        if (this.mTextAreaLogAppender == null) {
            this.mTextAreaLogAppender = new TextAreaLogAppender(this.getConsoleTextArea(), "My Console Logger");
        }
        return this.mTextAreaLogAppender;
    }

    private TextArea getConsoleTextArea() {
        if (this.mConsoleTextArea == null) {
            this.mConsoleTextArea = new TextArea();
            this.mConsoleTextArea.setDisable(true);
            this.mConsoleTextArea.setMaxHeight(Double.MAX_VALUE);
            this.mConsoleTextArea.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mConsoleTextArea;
    }

    private ProgressBar getProgressBar() {
        if (this.mProgressBar == null) {
            this.mProgressBar = new ProgressBar();
            this.mProgressBar.setVisible(false);
        }
        return this.mProgressBar;
    }

    private Button getResetAllButton() {
        if (this.mResetAllButton == null) {
            this.mResetAllButton = new Button("Reset All Calibrations");
            this.mResetAllButton.setTooltip(new Tooltip("Reset all calibrations to an Uncalibrated state"));
            this.mResetAllButton.setOnAction(event -> {
                CalibrationManager.getInstance().reset();
                this.updateControls();
            });
        }
        return this.mResetAllButton;
    }

    private Button getCalibrateButton() {
        if (this.mCalibrateButton == null) {
            this.mCalibrateButton = new Button("Calibrate");
            this.mCalibrateButton.setTooltip(new Tooltip("Calibrate the items that need calibrated"));
            this.mCalibrateButton.setOnAction(event -> {
                this.getCalibrateButton().setDisable(true);
                this.getResetAllButton().setDisable(true);
                this.getConsoleTextArea().clear();
                this.getConsoleTextArea().appendText("Calibrating.  Each calibration lasts 20 - 40 seconds.");
                this.enableConsoleLogging();
                this.getCalibratingLabel().setVisible(true);
                this.getProgressBar().setVisible(true);
                this.getProgressBar().setProgress(0.0);
                ThreadPool.CACHED.submit(() -> {
                    try {
                        CalibrationManager manager = CalibrationManager.getInstance();
                        List<Calibration> calibrations = manager.getUncalibrated();
                        int counter = 0;
                        for (Calibration calibration : calibrations) {
                            String message = "\n\nCalibration [" + ++counter + "/" + calibrations.size() + "] - " + String.valueOf((Object)calibration.getType());
                            Platform.runLater(() -> this.getConsoleTextArea().appendText(message));
                            try {
                                calibration.calibrate();
                                double progress = (double)counter / (double)calibrations.size();
                                Platform.runLater(() -> this.getProgressBar().setProgress(progress));
                            }
                            catch (CalibrationException ce) {
                                mLog.error("Calibration error for " + String.valueOf((Object)calibration.getType()), (Throwable)ce);
                            }
                        }
                    }
                    catch (Throwable t) {
                        mLog.error("Error while performing calibrations", t);
                    }
                    Platform.runLater(() -> {
                        this.getConsoleTextArea().appendText("\nCalibration Complete!\nNote: restart the application to use these new settings.");
                        this.getCalibratingLabel().setVisible(false);
                        this.getProgressBar().setVisible(false);
                        this.updateControls();
                        this.disableConsoleLogging();
                    });
                });
            });
        }
        return this.mCalibrateButton;
    }

    private Label getCalibratingLabel() {
        if (this.mCalibratingLabel == null) {
            this.mCalibratingLabel = new Label("Calibrating:");
            this.mCalibratingLabel.setVisible(false);
        }
        return this.mCalibratingLabel;
    }

    private void updateControls() {
        int pending = CalibrationManager.getInstance().getUncalibrated().size();
        int total = CalibrationManager.getInstance().getCalibrationTypes().size();
        this.getCalibrationsPendingValue().setText(String.valueOf(pending));
        this.getCalibrateButton().setDisable(pending == 0);
        this.getResetAllButton().setDisable(pending == total);
    }

    private Label getCalibrationsPendingValue() {
        if (this.mCalibrationsPendingValue == null) {
            this.mCalibrationsPendingValue = new Label(" ");
        }
        return this.mCalibrationsPendingValue;
    }

    private ToggleSwitch getVectorEnabledToggleSwitch() {
        if (this.mVectorEnabled == null) {
            this.mVectorEnabled = new ToggleSwitch();
            this.mVectorEnabled.setTooltip(new Tooltip("Allow sdrtrunk to use optimized vector operations when supported by your CPU"));
            this.mVectorEnabled.setSelected(this.mPreference.isVectorEnabled());
            this.mVectorEnabled.selectedProperty().addListener((observable, oldValue, enabled) -> this.mPreference.setVectorEnabled((boolean)enabled));
        }
        return this.mVectorEnabled;
    }

    private ToggleSwitch getHideDialogSwitch() {
        if (this.mHideDialogSwitch == null) {
            this.mHideDialogSwitch = new ToggleSwitch();
            this.mHideDialogSwitch.setTooltip(new Tooltip("Don't show dialog when new calibrations are available"));
            this.mHideDialogSwitch.setSelected(this.mPreference.isHideCalibrationDialog());
            this.mHideDialogSwitch.selectedProperty().addListener((observable, oldValue, hide) -> this.mPreference.setHideCalibrationDialog((boolean)hide));
        }
        return this.mHideDialogSwitch;
    }
}

