/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.calibration;

import io.github.dsheirer.preference.UserPreferences;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class CalibrationDialog
extends Dialog {
    private UserPreferences mUserPreferences;

    public CalibrationDialog(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.setTitle("Calibrate CPU");
        this.setHeaderText("Perform CPU Calibration?");
        Label instructionsLabel = new Label("The sdrtrunk application can run more efficiently by using Vector or Single Instruction Multiple Data (SIMD) CPU operations.  sdrtrunk must calibrate your CPU in order to determine the best implementation.\n\nCalibration takes a few minutes to complete.\n\nIf you click 'Cancel', you will be prompted next time you run sdrtrunk, or you can open the User Preferences dialog from the View menu and manually start the calibration process.");
        instructionsLabel.setPrefWidth(300.0);
        instructionsLabel.setWrapText(true);
        CheckBox doNotShowAgainCheckBox = new CheckBox("Do not show again");
        doNotShowAgainCheckBox.setOnAction(event -> this.mUserPreferences.getVectorCalibrationPreference().setHideCalibrationDialog(doNotShowAgainCheckBox.isSelected()));
        VBox.setVgrow((Node)instructionsLabel, (Priority)Priority.ALWAYS);
        VBox contentBox = new VBox();
        contentBox.setPadding(new Insets(10.0));
        contentBox.setSpacing(20.0);
        contentBox.getChildren().addAll((Object[])new Node[]{instructionsLabel, doNotShowAgainCheckBox});
        this.getDialogPane().setContent((Node)contentBox);
        ButtonType calibrateButtonType = new ButtonType("Calibrate", ButtonBar.ButtonData.OK_DONE);
        ButtonType cancelButtonType = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{calibrateButtonType, cancelButtonType});
    }
}

