/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference.application;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.application.ApplicationPreference;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class ApplicationPreferenceEditor
extends HBox {
    private ApplicationPreference mApplicationPreference;
    private GridPane mEditorPane;
    private Label mAutoStartTimeoutLabel;
    private Spinner<Integer> mTimeoutSpinner;

    public ApplicationPreferenceEditor(UserPreferences userPreferences) {
        this.mApplicationPreference = userPreferences.getApplicationPreference();
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            int row = 0;
            this.mEditorPane = new GridPane();
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            GridPane.setHalignment((Node)this.getAutoStartTimeoutLabel(), (HPos)HPos.RIGHT);
            this.mEditorPane.add((Node)this.getAutoStartTimeoutLabel(), 0, row);
            this.mEditorPane.add(this.getTimeoutSpinner(), 1, row);
            this.mEditorPane.add((Node)new Label("seconds"), 2, row);
        }
        return this.mEditorPane;
    }

    private Label getAutoStartTimeoutLabel() {
        if (this.mAutoStartTimeoutLabel == null) {
            this.mAutoStartTimeoutLabel = new Label("Channel Auto-Start Timeout");
        }
        return this.mAutoStartTimeoutLabel;
    }

    private Spinner<Integer> getTimeoutSpinner() {
        if (this.mTimeoutSpinner == null) {
            this.mTimeoutSpinner = new Spinner(0, 30, this.mApplicationPreference.getChannelAutoStartTimeout(), 1);
            this.mTimeoutSpinner.valueProperty().addListener((observable, oldValue, newValue) -> this.mApplicationPreference.setChannelAutoStartTimeout((int)newValue));
        }
        return this.mTimeoutSpinner;
    }
}

