/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference;

import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.ViewPlaylistRequest;
import io.github.dsheirer.gui.preference.PreferenceEditorFactory;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.preference.UserPreferences;
import java.util.EnumMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferencesEditor
extends BorderPane {
    private static final Logger mLog = LoggerFactory.getLogger(UserPreferencesEditor.class);
    private Map<PreferenceEditorType, Node> mEditors = new EnumMap<PreferenceEditorType, Node>(PreferenceEditorType.class);
    private UserPreferences mUserPreferences;
    private MenuBar mMenuBar;
    private TreeView mEditorSelectionTreeView;
    private VBox mEditorAndButtonsBox;
    private Node mEditor;
    private HBox mButtonsBox;

    public UserPreferencesEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.setTop((Node)this.getMenuBar());
        HBox contentBox = new HBox();
        HBox.setHgrow((Node)this.getEditorAndButtonsBox(), (Priority)Priority.ALWAYS);
        contentBox.getChildren().addAll((Object[])new Node[]{this.getEditorSelectionTreeView(), this.getEditorAndButtonsBox()});
        this.setCenter((Node)contentBox);
    }

    private UserPreferences getUserPreferences() {
        if (this.mUserPreferences == null) {
            this.mUserPreferences = new UserPreferences();
        }
        return this.mUserPreferences;
    }

    public void process(ViewUserPreferenceEditorRequest request) {
        TreeItem toSelect;
        if (request.getPreferenceType() != null && (toSelect = this.recursivelyFindEditorType(this.getEditorSelectionTreeView().getRoot(), request.getPreferenceType())) != null) {
            this.getEditorSelectionTreeView().getSelectionModel().select((Object)toSelect);
        }
    }

    private TreeItem recursivelyFindEditorType(TreeItem parent, PreferenceEditorType type) {
        for (TreeItem treeItem : parent.getChildren()) {
            if (treeItem.getValue() instanceof PreferenceEditorType && treeItem.getValue().equals((Object)type)) {
                return treeItem;
            }
            TreeItem item = this.recursivelyFindEditorType(treeItem, type);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    private VBox getEditorAndButtonsBox() {
        if (this.mEditorAndButtonsBox == null) {
            this.mEditorAndButtonsBox = new VBox();
            this.mEditor = this.getDefaultEditor();
            VBox.setVgrow((Node)this.getDefaultEditor(), (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)this.getButtonsBox(), (Priority)Priority.NEVER);
            this.mEditorAndButtonsBox.getChildren().addAll((Object[])new Node[]{this.getDefaultEditor(), this.getButtonsBox()});
        }
        return this.mEditorAndButtonsBox;
    }

    private Node getDefaultEditor() {
        Node editor = this.mEditors.get((Object)PreferenceEditorType.DEFAULT);
        if (editor == null) {
            VBox defaultEditor = new VBox();
            defaultEditor.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            Label label = new Label("Please select a preference ...");
            defaultEditor.getChildren().add((Object)label);
            this.mEditors.put(PreferenceEditorType.DEFAULT, (Node)defaultEditor);
            editor = defaultEditor;
        }
        return editor;
    }

    private TreeView getEditorSelectionTreeView() {
        if (this.mEditorSelectionTreeView == null) {
            TreeItem treeRoot = new TreeItem((Object)"Root node");
            TreeItem applicationItem = new TreeItem((Object)"Application");
            applicationItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.APPLICATION));
            treeRoot.getChildren().add((Object)applicationItem);
            applicationItem.setExpanded(true);
            TreeItem audioItem = new TreeItem((Object)"Audio");
            audioItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.AUDIO_DUPLICATE_CALL_DETECTION));
            audioItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.AUDIO_MP3));
            audioItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.AUDIO_OUTPUT));
            audioItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.AUDIO_RECORD));
            treeRoot.getChildren().add((Object)audioItem);
            audioItem.setExpanded(true);
            TreeItem cpuItem = new TreeItem((Object)"CPU");
            cpuItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.VECTOR_CALIBRATION));
            treeRoot.getChildren().add((Object)cpuItem);
            cpuItem.setExpanded(true);
            TreeItem decoderItem = new TreeItem((Object)"Decoder");
            decoderItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.JMBE_LIBRARY));
            treeRoot.getChildren().add((Object)decoderItem);
            decoderItem.setExpanded(true);
            TreeItem displayItem = new TreeItem((Object)"Display");
            displayItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.CHANNEL_EVENT));
            displayItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.TALKGROUP_FORMAT));
            treeRoot.getChildren().add((Object)displayItem);
            displayItem.setExpanded(true);
            TreeItem storageItem = new TreeItem((Object)"File Storage");
            storageItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.DIRECTORY));
            treeRoot.getChildren().add((Object)storageItem);
            storageItem.setExpanded(true);
            TreeItem sourceItem = new TreeItem((Object)"Source");
            sourceItem.getChildren().add((Object)new TreeItem((Object)PreferenceEditorType.SOURCE_TUNERS));
            treeRoot.getChildren().add((Object)sourceItem);
            sourceItem.setExpanded(true);
            this.mEditorSelectionTreeView = new TreeView();
            this.mEditorSelectionTreeView.setShowRoot(false);
            this.mEditorSelectionTreeView.setRoot(treeRoot);
            treeRoot.setExpanded(true);
            this.mEditorSelectionTreeView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            this.mEditorSelectionTreeView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new EditorTreeSelectionListener());
            this.mEditorSelectionTreeView.setMinWidth(Double.NEGATIVE_INFINITY);
        }
        return this.mEditorSelectionTreeView;
    }

    private HBox getButtonsBox() {
        if (this.mButtonsBox == null) {
            this.mButtonsBox = new HBox();
            this.mButtonsBox.setMaxWidth(Double.MAX_VALUE);
            Button okButton = new Button("Ok");
            okButton.setOnAction(event -> {
                Stage stage = (Stage)this.getButtonsBox().getScene().getWindow();
                stage.close();
            });
            HBox.setMargin((Node)okButton, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
            this.mButtonsBox.setAlignment(Pos.CENTER_RIGHT);
            this.mButtonsBox.getChildren().add((Object)okButton);
        }
        return this.mButtonsBox;
    }

    private MenuBar getMenuBar() {
        if (this.mMenuBar == null) {
            this.mMenuBar = new MenuBar();
            Menu fileMenu = new Menu("File");
            MenuItem closeItem = new MenuItem("Close");
            closeItem.setOnAction(event -> this.getMenuBar().getParent().getScene().getWindow().hide());
            fileMenu.getItems().add((Object)closeItem);
            this.mMenuBar.getMenus().add((Object)fileMenu);
            Menu viewMenu = new Menu("View");
            MenuItem playlistEditorItem = new MenuItem("Playlist Editor");
            playlistEditorItem.setOnAction(event -> MyEventBus.getGlobalEventBus().post((Object)new ViewPlaylistRequest()));
            viewMenu.getItems().add((Object)playlistEditorItem);
            this.mMenuBar.getMenus().add((Object)viewMenu);
        }
        return this.mMenuBar;
    }

    private void setEditor(PreferenceEditorType type) {
        Node editor = this.mEditors.get((Object)type);
        if (editor == null) {
            if (type == PreferenceEditorType.DEFAULT) {
                editor = this.getDefaultEditor();
            } else {
                editor = PreferenceEditorFactory.getEditor(type, this.getUserPreferences());
                this.mEditors.put(type, editor);
            }
        }
        this.getEditorAndButtonsBox().getChildren().remove((Object)this.mEditor);
        VBox.setVgrow((Node)editor, (Priority)Priority.ALWAYS);
        this.mEditor = editor;
        this.getEditorAndButtonsBox().getChildren().add(0, (Object)this.mEditor);
    }

    public class EditorTreeSelectionListener
    implements ChangeListener {
        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            Object value;
            if (newValue instanceof TreeItem && (value = ((TreeItem)newValue).getValue()) instanceof PreferenceEditorType) {
                UserPreferencesEditor.this.setEditor((PreferenceEditorType)((Object)value));
                return;
            }
            UserPreferencesEditor.this.setEditor(PreferenceEditorType.DEFAULT);
        }
    }
}

