/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.TalkgroupFormatPreference;
import io.github.dsheirer.protocol.Protocol;
import java.util.Set;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

public class TalkgroupFormatPreferenceEditor
extends HBox {
    private TalkgroupFormatPreference mTalkgroupFormatPreference;
    private GridPane mEditorPane;

    public TalkgroupFormatPreferenceEditor(UserPreferences userPreferences) {
        this.mTalkgroupFormatPreference = userPreferences.getTalkgroupFormatPreference();
        this.getChildren().add((Object)this.getEditorPane());
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            int row = 0;
            this.mEditorPane.add((Node)new Label("Protocol"), 0, row);
            this.mEditorPane.add((Node)new Label("Display Format"), 1, row++);
            this.mEditorPane.add((Node)new Separator(Orientation.HORIZONTAL), 0, row++, 3, 1);
            for (Protocol protocol : Protocol.TALKGROUP_PROTOCOLS) {
                Label label = new Label(protocol.toString());
                GridPane.setMargin((Node)label, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
                this.mEditorPane.add((Node)label, 0, row);
                IntegerFormatEditor editor = new IntegerFormatEditor(this, this.mTalkgroupFormatPreference, protocol, TalkgroupFormatPreference.getFormats(protocol));
                GridPane.setMargin((Node)editor, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
                this.mEditorPane.add((Node)editor, 1, row);
                FixedWidthEditor fixedWidthEditor = new FixedWidthEditor(this, this.mTalkgroupFormatPreference, protocol);
                GridPane.setMargin((Node)fixedWidthEditor, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
                this.mEditorPane.add((Node)fixedWidthEditor, 2, row);
                ++row;
            }
        }
        return this.mEditorPane;
    }

    public class IntegerFormatEditor
    extends ChoiceBox<IntegerFormat> {
        private TalkgroupFormatPreference mTalkgroupFormatPreference;
        private Protocol mProtocol;

        public IntegerFormatEditor(TalkgroupFormatPreferenceEditor this$0, TalkgroupFormatPreference preference, Protocol protocol, Set<IntegerFormat> formats) {
            this.mTalkgroupFormatPreference = preference;
            this.mProtocol = protocol;
            this.setMaxWidth(Double.MAX_VALUE);
            this.getItems().addAll(formats);
            this.getSelectionModel().select((Object)this.mTalkgroupFormatPreference.getTalkgroupFormat(this.mProtocol));
            this.setOnAction(event -> {
                IntegerFormat selected = (IntegerFormat)((Object)((Object)this.getSelectionModel().getSelectedItem()));
                this.mTalkgroupFormatPreference.setTalkgroupFormat(this.mProtocol, selected);
            });
        }
    }

    public class FixedWidthEditor
    extends CheckBox {
        private TalkgroupFormatPreference mTalkgroupFormatPreference;
        private Protocol mProtocol;

        public FixedWidthEditor(TalkgroupFormatPreferenceEditor this$0, TalkgroupFormatPreference preference, Protocol protocol) {
            super("Fixed Width");
            this.mTalkgroupFormatPreference = preference;
            this.mProtocol = protocol;
            this.setSelected(this.mTalkgroupFormatPreference.isTalkgroupFixedWidth(this.mProtocol));
            this.setOnAction(event -> this.mTalkgroupFormatPreference.setTalkgroupFixedWidth(this.mProtocol, this.isSelected()));
        }
    }
}

