/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.gui.playlist.streaming.AbstractBroadcastEditor;
import io.github.dsheirer.gui.playlist.streaming.BroadcastifyCallEditor;
import io.github.dsheirer.gui.playlist.streaming.BroadcastifyStreamEditor;
import io.github.dsheirer.gui.playlist.streaming.IcecastHTTPStreamEditor;
import io.github.dsheirer.gui.playlist.streaming.IcecastTCPStreamEditor;
import io.github.dsheirer.gui.playlist.streaming.OpenMHzEditor;
import io.github.dsheirer.gui.playlist.streaming.RdioScannerEditor;
import io.github.dsheirer.gui.playlist.streaming.ShoutcastV1StreamEditor;
import io.github.dsheirer.gui.playlist.streaming.ShoutcastV2StreamEditor;
import io.github.dsheirer.gui.playlist.streaming.UnknownStreamEditor;
import io.github.dsheirer.playlist.PlaylistManager;

public class StreamEditorFactory {
    public static AbstractBroadcastEditor getEditor(BroadcastServerType broadcastServerType, PlaylistManager playlistManager) {
        switch (broadcastServerType) {
            case BROADCASTIFY: {
                return new BroadcastifyStreamEditor(playlistManager);
            }
            case RDIOSCANNER_CALL: {
                return new RdioScannerEditor(playlistManager);
            }
            case OPENMHZ: {
                return new OpenMHzEditor(playlistManager);
            }
            case BROADCASTIFY_CALL: {
                return new BroadcastifyCallEditor(playlistManager);
            }
            case ICECAST_HTTP: {
                return new IcecastHTTPStreamEditor(playlistManager);
            }
            case ICECAST_TCP: {
                return new IcecastTCPStreamEditor(playlistManager);
            }
            case SHOUTCAST_V1: {
                return new ShoutcastV1StreamEditor(playlistManager);
            }
            case SHOUTCAST_V2: {
                return new ShoutcastV2StreamEditor(playlistManager);
            }
        }
        return new UnknownStreamEditor(playlistManager);
    }
}

