/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.broadcast.BroadcastChannel;
import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import java.util.ArrayList;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAliasSelectionEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(StreamAliasSelectionEditor.class);
    private PlaylistManager mPlaylistManager;
    private BroadcastConfiguration mSelectedBroadcastConfiguration;
    private HBox mSearchBox;
    private TextField mSearchField;
    private TableView<Alias> mAvailableAliasTableView;
    private TableView<Alias> mSelectedAliasTableView;
    private Button mAddButton;
    private Button mAddAllButton;
    private Button mRemoveButton;
    private Button mRemoveAllButton;
    private FilteredList<Alias> mAvailableFilteredList;
    private FilteredList<Alias> mSelectedFilteredList;
    private AvailableAliasPredicate mAvailableAliasPredicate = new AvailableAliasPredicate();
    private SelectedAliasPredicate mSelectedAliasPredicate = new SelectedAliasPredicate();

    public StreamAliasSelectionEditor(PlaylistManager playlistManager) {
        this.mPlaylistManager = playlistManager;
        VBox buttonBox = new VBox();
        buttonBox.setMaxHeight(Double.MAX_VALUE);
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.setSpacing(5.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.getAddAllButton(), this.getAddButton(), this.getRemoveButton(), this.getRemoveAllButton()});
        VBox availableBox = new VBox();
        availableBox.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.getAvailableAliasTableView(), (Priority)Priority.ALWAYS);
        availableBox.getChildren().addAll((Object[])new Node[]{new Label("Available"), this.getAvailableAliasTableView()});
        VBox selectedBox = new VBox();
        selectedBox.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.getSelectedAliasTableView(), (Priority)Priority.ALWAYS);
        selectedBox.getChildren().addAll((Object[])new Node[]{new Label("Selected"), this.getSelectedAliasTableView()});
        HBox listsBox = new HBox();
        listsBox.setMaxHeight(Double.MAX_VALUE);
        listsBox.setPadding(new Insets(5.0, 10.0, 10.0, 10.0));
        listsBox.setSpacing(10.0);
        HBox.setHgrow((Node)availableBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)selectedBox, (Priority)Priority.ALWAYS);
        listsBox.getChildren().addAll((Object[])new Node[]{availableBox, buttonBox, selectedBox});
        VBox.setVgrow((Node)listsBox, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getSearchBox(), listsBox});
    }

    public void setBroadcastConfiguration(BroadcastConfiguration broadcastConfiguration) {
        this.mSearchField.setText(null);
        this.mSelectedBroadcastConfiguration = broadcastConfiguration;
        this.getSearchField().setDisable(this.mSelectedBroadcastConfiguration == null);
        this.getAvailableAliasTableView().setDisable(this.mSelectedBroadcastConfiguration == null);
        this.getSelectedAliasTableView().setDisable(this.mSelectedBroadcastConfiguration == null);
        this.updateListFilters();
    }

    private FilteredList<Alias> getAvailableFilteredList() {
        if (this.mAvailableFilteredList == null) {
            this.mAvailableFilteredList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasList(), (Predicate)this.mAvailableAliasPredicate);
        }
        return this.mAvailableFilteredList;
    }

    private FilteredList<Alias> getSelectedFilteredList() {
        if (this.mSelectedFilteredList == null) {
            this.mSelectedFilteredList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasList(), (Predicate)this.mSelectedAliasPredicate);
        }
        return this.mSelectedFilteredList;
    }

    private HBox getSearchBox() {
        if (this.mSearchBox == null) {
            this.mSearchBox = new HBox();
            this.mSearchBox.setAlignment(Pos.CENTER_LEFT);
            this.mSearchBox.setPadding(new Insets(5.0, 5.0, 0.0, 15.0));
            this.mSearchBox.setSpacing(5.0);
            Label searchLabel = new Label("Search:");
            searchLabel.setAlignment(Pos.CENTER_RIGHT);
            this.mSearchBox.getChildren().addAll((Object[])new Node[]{searchLabel, this.getSearchField()});
        }
        return this.mSearchBox;
    }

    private TextField getSearchField() {
        if (this.mSearchField == null) {
            this.mSearchField = TextFields.createClearableTextField();
            this.mSearchField.setDisable(true);
            this.mSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.updateListFilters());
        }
        return this.mSearchField;
    }

    private void updateListFilters() {
        String streamName = this.getSelectedStreamName();
        String filterText = this.getSearchField().getText();
        this.mAvailableAliasPredicate.setStreamName(streamName);
        this.mAvailableAliasPredicate.setFilterText(filterText);
        this.mSelectedAliasPredicate.setStreamName(streamName);
        this.mSelectedAliasPredicate.setFilterText(filterText);
        this.getAvailableFilteredList().setPredicate(null);
        this.getAvailableFilteredList().setPredicate((Predicate)this.mAvailableAliasPredicate);
        this.getSelectedFilteredList().setPredicate(null);
        this.getSelectedFilteredList().setPredicate((Predicate)this.mSelectedAliasPredicate);
    }

    private String getSelectedStreamName() {
        if (this.mSelectedBroadcastConfiguration != null && this.mSelectedBroadcastConfiguration.getName() != null && !this.mSelectedBroadcastConfiguration.getName().isEmpty()) {
            return this.mSelectedBroadcastConfiguration.getName();
        }
        return null;
    }

    private TableView<Alias> getAvailableAliasTableView() {
        if (this.mAvailableAliasTableView == null) {
            this.mAvailableAliasTableView = new TableView();
            this.mAvailableAliasTableView.setMaxHeight(Double.MAX_VALUE);
            this.mAvailableAliasTableView.setDisable(true);
            this.mAvailableAliasTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            TableColumn aliasListNameColumn = new TableColumn();
            aliasListNameColumn.setText("Alias List");
            aliasListNameColumn.setPrefWidth(150.0);
            aliasListNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("aliasListName"));
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setPrefWidth(150.0);
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            TableColumn nameColumn = new TableColumn();
            nameColumn.setText("Alias");
            nameColumn.setPrefWidth(150.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.mAvailableAliasTableView.getColumns().addAll((Object[])new TableColumn[]{aliasListNameColumn, groupColumn, nameColumn});
            this.mAvailableAliasTableView.setPlaceholder((Node)new Label("No aliases available"));
            this.mAvailableAliasTableView.getSelectionModel().getSelectedItems().addListener(c -> {
                int selectedCount = this.mAvailableAliasTableView.getSelectionModel().getSelectedItems().size();
                this.getAddButton().setDisable(selectedCount != 1);
                this.getAddAllButton().setDisable(selectedCount < 2);
                if (selectedCount > 0) {
                    this.getSelectedAliasTableView().getSelectionModel().clearSelection();
                }
            });
            SortedList sortedList = new SortedList(this.getAvailableFilteredList());
            sortedList.comparatorProperty().bind((ObservableValue)this.mAvailableAliasTableView.comparatorProperty());
            this.mAvailableAliasTableView.setItems((ObservableList)sortedList);
        }
        return this.mAvailableAliasTableView;
    }

    private TableView<Alias> getSelectedAliasTableView() {
        if (this.mSelectedAliasTableView == null) {
            this.mSelectedAliasTableView = new TableView();
            this.mSelectedAliasTableView.setMaxHeight(Double.MAX_VALUE);
            this.mSelectedAliasTableView.setDisable(true);
            this.mSelectedAliasTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            TableColumn aliasListNameColumn = new TableColumn();
            aliasListNameColumn.setText("Alias List");
            aliasListNameColumn.setPrefWidth(150.0);
            aliasListNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("aliasListName"));
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setPrefWidth(150.0);
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            TableColumn nameColumn = new TableColumn();
            nameColumn.setText("Alias");
            nameColumn.setPrefWidth(150.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.mSelectedAliasTableView.getColumns().addAll((Object[])new TableColumn[]{aliasListNameColumn, groupColumn, nameColumn});
            this.mSelectedAliasTableView.setPlaceholder((Node)new Label("No aliases selected"));
            this.mSelectedAliasTableView.getSelectionModel().getSelectedItems().addListener(c -> {
                int selectedCount = this.mSelectedAliasTableView.getSelectionModel().getSelectedItems().size();
                this.getRemoveButton().setDisable(selectedCount != 1);
                this.getRemoveAllButton().setDisable(selectedCount < 2);
                if (selectedCount > 0) {
                    this.getAvailableAliasTableView().getSelectionModel().clearSelection();
                }
            });
            SortedList sortedList = new SortedList(this.getSelectedFilteredList());
            sortedList.comparatorProperty().bind((ObservableValue)this.mSelectedAliasTableView.comparatorProperty());
            this.mSelectedAliasTableView.setItems((ObservableList)sortedList);
        }
        return this.mSelectedAliasTableView;
    }

    private Button getAddButton() {
        if (this.mAddButton == null) {
            this.mAddButton = new Button();
            this.mAddButton.setDisable(true);
            this.mAddButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_RIGHT));
            this.mAddButton.setAlignment(Pos.CENTER);
            this.mAddButton.setOnAction(event -> {
                Alias selectedAlias = (Alias)this.getAvailableAliasTableView().getSelectionModel().getSelectedItem();
                String stream = this.getSelectedStreamName();
                if (selectedAlias != null && stream != null) {
                    selectedAlias.addAliasID(new BroadcastChannel(stream));
                    this.updateListFilters();
                }
            });
        }
        return this.mAddButton;
    }

    private Button getAddAllButton() {
        if (this.mAddAllButton == null) {
            this.mAddAllButton = new Button();
            this.mAddAllButton.setDisable(true);
            this.mAddAllButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddAllButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_DOUBLE_RIGHT));
            this.mAddAllButton.setAlignment(Pos.CENTER);
            this.mAddAllButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ArrayList selectedAliases = new ArrayList(StreamAliasSelectionEditor.this.getAvailableAliasTableView().getSelectionModel().getSelectedItems());
                    String stream = StreamAliasSelectionEditor.this.getSelectedStreamName();
                    if (!selectedAliases.isEmpty() && stream != null) {
                        for (Alias selectedAlias : selectedAliases) {
                            selectedAlias.addAliasID(new BroadcastChannel(stream));
                        }
                        StreamAliasSelectionEditor.this.updateListFilters();
                    }
                }
            });
        }
        return this.mAddAllButton;
    }

    private Button getRemoveButton() {
        if (this.mRemoveButton == null) {
            this.mRemoveButton = new Button();
            this.mRemoveButton.setDisable(true);
            this.mRemoveButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_LEFT));
            this.mRemoveButton.setAlignment(Pos.CENTER);
            this.mRemoveButton.setOnAction(event -> {
                Alias selectedAlias = (Alias)this.getSelectedAliasTableView().getSelectionModel().getSelectedItem();
                String stream = this.getSelectedStreamName();
                if (selectedAlias != null && stream != null) {
                    selectedAlias.removeBroadcastChannel(stream);
                    this.updateListFilters();
                }
            });
        }
        return this.mRemoveButton;
    }

    private Button getRemoveAllButton() {
        if (this.mRemoveAllButton == null) {
            this.mRemoveAllButton = new Button();
            this.mRemoveAllButton.setDisable(true);
            this.mRemoveAllButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveAllButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_DOUBLE_LEFT));
            this.mRemoveAllButton.setAlignment(Pos.CENTER);
            this.mRemoveAllButton.setOnAction(event -> {
                ArrayList selectedAliases = new ArrayList(this.getSelectedAliasTableView().getSelectionModel().getSelectedItems());
                String stream = this.getSelectedStreamName();
                if (!selectedAliases.isEmpty() && stream != null) {
                    for (Alias selectedAlias : selectedAliases) {
                        selectedAlias.removeBroadcastChannel(stream);
                    }
                    this.updateListFilters();
                }
            });
        }
        return this.mRemoveAllButton;
    }

    public static class AvailableAliasPredicate
    implements Predicate<Alias> {
        private String mStreamName;
        private String mFilterText;

        public void setStreamName(String streamName) {
            this.mStreamName = streamName;
        }

        public void setFilterText(String filterText) {
            this.mFilterText = filterText == null || filterText.isEmpty() ? null : filterText.toLowerCase();
        }

        @Override
        public boolean test(Alias alias) {
            if (this.mStreamName == null || alias.hasBroadcastChannel(this.mStreamName)) {
                return false;
            }
            if (this.mFilterText == null) {
                return true;
            }
            if (alias.getAliasListName() != null && alias.getAliasListName().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            if (alias.getGroup() != null && alias.getGroup().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            return alias.getName() != null && alias.getName().toLowerCase().contains(this.mFilterText);
        }
    }

    public static class SelectedAliasPredicate
    implements Predicate<Alias> {
        private String mStreamName;
        private String mFilterText;

        public void setStreamName(String streamName) {
            this.mStreamName = streamName;
        }

        public void setFilterText(String filterText) {
            this.mFilterText = filterText == null || filterText.isEmpty() ? null : filterText.toLowerCase();
        }

        @Override
        public boolean test(Alias alias) {
            if (!alias.hasBroadcastChannel(this.mStreamName)) {
                return false;
            }
            if (this.mFilterText == null) {
                return true;
            }
            if (alias.getAliasListName() != null && alias.getAliasListName().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            if (alias.getGroup() != null && alias.getGroup().toLowerCase().contains(this.mFilterText)) {
                return true;
            }
            return alias.getName() != null && alias.getName().toLowerCase().contains(this.mFilterText);
        }
    }
}

