/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.icecast.IcecastConfiguration;
import io.github.dsheirer.gui.playlist.streaming.AbstractStreamEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;

public abstract class IcecastStreamEditor
extends AbstractStreamEditor<IcecastConfiguration> {
    private GridPane mEditorPane;
    private ToggleSwitch mInlineToggleSwitch;
    private TextField mMountPointTextField;
    private TextField mUserNameTextField;
    private TextField mDescriptionTextField;
    private TextField mGenreTextField;
    private TextField mURLTextField;

    public IcecastStreamEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public void setItem(IcecastConfiguration item) {
        this.getMountPointTextField().setDisable(item == null);
        this.getInlineToggleSwitch().setDisable(item == null);
        this.getUserNameTextField().setDisable(item == null);
        this.getDescriptionTextField().setDisable(item == null);
        this.getGenreTextField().setDisable(item == null);
        this.getURLTextField().setDisable(item == null);
        if (item != null) {
            this.getMountPointTextField().setText(item.getMountPoint());
            this.getInlineToggleSwitch().setSelected(item.getInline());
            this.getUserNameTextField().setText(item.getUserName());
            this.getDescriptionTextField().setText(item.getDescription());
            this.getGenreTextField().setText(item.getGenre());
            this.getURLTextField().setText(item.getURL());
        } else {
            this.getMountPointTextField().setText(null);
            this.getInlineToggleSwitch().setSelected(false);
            this.getUserNameTextField().setText(null);
            this.getDescriptionTextField().setText(null);
            this.getGenreTextField().setText(null);
            this.getURLTextField().setText(null);
        }
        super.setItem(item);
    }

    @Override
    public void save() {
        if (this.getItem() != null) {
            ((IcecastConfiguration)this.getItem()).setMountPoint(this.getMountPointTextField().getText());
            ((IcecastConfiguration)this.getItem()).setInline(this.getInlineToggleSwitch().isSelected());
            ((IcecastConfiguration)this.getItem()).setUserName(this.getUserNameTextField().getText());
            ((IcecastConfiguration)this.getItem()).setDescription(this.getDescriptionTextField().getText());
            ((IcecastConfiguration)this.getItem()).setGenre(this.getGenreTextField().getText());
            ((IcecastConfiguration)this.getItem()).setURL(this.getURLTextField().getText());
        }
        super.save();
    }

    @Override
    protected GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 5.0, 10.0, 10.0));
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(5.0);
            Label formatLabel = new Label("Format");
            GridPane.setHalignment((Node)formatLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)formatLabel, (int)0, (int)0);
            this.mEditorPane.getChildren().add((Object)formatLabel);
            this.getFormatField().setText(this.getBroadcastServerType().toString());
            GridPane.setConstraints((Node)this.getFormatField(), (int)1, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getFormatField());
            Label enabledLabel = new Label("Enabled");
            GridPane.setHalignment((Node)enabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)enabledLabel, (int)2, (int)0);
            this.mEditorPane.getChildren().add((Object)enabledLabel);
            GridPane.setConstraints((Node)this.getEnabledSwitch(), (int)3, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getEnabledSwitch());
            Label systemLabel = new Label("Name");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)1);
            this.mEditorPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            Label hostLabel = new Label("Server");
            GridPane.setHalignment((Node)hostLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)hostLabel, (int)0, (int)2);
            this.mEditorPane.getChildren().add((Object)hostLabel);
            GridPane.setConstraints((Node)this.getHostTextField(), (int)1, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getHostTextField());
            Label portLabel = new Label("Port");
            GridPane.setHalignment((Node)portLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)portLabel, (int)2, (int)2);
            this.mEditorPane.getChildren().add((Object)portLabel);
            GridPane.setConstraints((Node)this.getPortTextField(), (int)3, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getPortTextField());
            Label mountPointLabel = new Label("Mount Point");
            GridPane.setHalignment((Node)mountPointLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)mountPointLabel, (int)0, (int)3);
            this.mEditorPane.getChildren().add((Object)mountPointLabel);
            GridPane.setConstraints((Node)this.getMountPointTextField(), (int)1, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getMountPointTextField());
            Label inlineLabel = new Label("Inline Metadata");
            GridPane.setHalignment((Node)inlineLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)inlineLabel, (int)2, (int)3);
            this.mEditorPane.getChildren().add((Object)inlineLabel);
            GridPane.setConstraints((Node)this.getInlineToggleSwitch(), (int)3, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getInlineToggleSwitch());
            Label userNameLabel = new Label("User Name");
            GridPane.setHalignment((Node)userNameLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)userNameLabel, (int)0, (int)4);
            this.mEditorPane.getChildren().add((Object)userNameLabel);
            GridPane.setConstraints((Node)this.getUserNameTextField(), (int)1, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getUserNameTextField());
            Label passwordLabel = new Label("Password");
            GridPane.setHalignment((Node)passwordLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)passwordLabel, (int)2, (int)4);
            this.mEditorPane.getChildren().add((Object)passwordLabel);
            GridPane.setConstraints((Node)this.getMaskedPasswordTextField(), (int)3, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getUnMaskedPasswordTextField(), (int)3, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getUnMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getShowPasswordCheckBox(), (int)4, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getShowPasswordCheckBox());
            Label maxAgeLabel = new Label("Max Recording Age (seconds)");
            GridPane.setHalignment((Node)maxAgeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)maxAgeLabel, (int)0, (int)5);
            this.mEditorPane.getChildren().add((Object)maxAgeLabel);
            GridPane.setConstraints((Node)this.getMaxAgeTextField(), (int)1, (int)5);
            this.mEditorPane.getChildren().add((Object)this.getMaxAgeTextField());
            Label delayLabel = new Label("Delay (seconds)");
            GridPane.setHalignment((Node)delayLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)delayLabel, (int)2, (int)5);
            this.mEditorPane.getChildren().add((Object)delayLabel);
            GridPane.setConstraints((Node)this.getDelayTextField(), (int)3, (int)5);
            this.mEditorPane.getChildren().add((Object)this.getDelayTextField());
            Label descriptionLabel = new Label("Description");
            GridPane.setHalignment((Node)descriptionLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)descriptionLabel, (int)0, (int)6);
            this.mEditorPane.getChildren().add((Object)descriptionLabel);
            GridPane.setConstraints((Node)this.getDescriptionTextField(), (int)1, (int)6, (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getDescriptionTextField());
            Label genreLabel = new Label("Genre");
            GridPane.setHalignment((Node)genreLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)genreLabel, (int)0, (int)7);
            this.mEditorPane.getChildren().add((Object)genreLabel);
            GridPane.setConstraints((Node)this.getGenreTextField(), (int)1, (int)7, (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getGenreTextField());
            Label urlLabel = new Label("URL");
            GridPane.setHalignment((Node)urlLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)urlLabel, (int)0, (int)8);
            this.mEditorPane.getChildren().add((Object)urlLabel);
            GridPane.setConstraints((Node)this.getURLTextField(), (int)1, (int)8, (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getURLTextField());
        }
        return this.mEditorPane;
    }

    private TextField getMountPointTextField() {
        if (this.mMountPointTextField == null) {
            this.mMountPointTextField = new TextField();
            this.mMountPointTextField.setDisable(true);
            this.mMountPointTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMountPointTextField;
    }

    private ToggleSwitch getInlineToggleSwitch() {
        if (this.mInlineToggleSwitch == null) {
            this.mInlineToggleSwitch = new ToggleSwitch();
            this.mInlineToggleSwitch.setDisable(true);
            this.mInlineToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mInlineToggleSwitch;
    }

    private TextField getUserNameTextField() {
        if (this.mUserNameTextField == null) {
            this.mUserNameTextField = new TextField();
            this.mUserNameTextField.setDisable(true);
            this.mUserNameTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mUserNameTextField;
    }

    private TextField getDescriptionTextField() {
        if (this.mDescriptionTextField == null) {
            this.mDescriptionTextField = new TextField();
            this.mDescriptionTextField.setDisable(true);
            this.mDescriptionTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mDescriptionTextField;
    }

    private TextField getGenreTextField() {
        if (this.mGenreTextField == null) {
            this.mGenreTextField = new TextField();
            this.mGenreTextField.setDisable(true);
            this.mGenreTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mGenreTextField;
    }

    private TextField getURLTextField() {
        if (this.mURLTextField == null) {
            this.mURLTextField = new TextField();
            this.mURLTextField.setDisable(true);
            this.mURLTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mURLTextField;
    }
}

