/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyFeedConfiguration;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.streaming.AbstractStreamEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class BroadcastifyStreamEditor
extends AbstractStreamEditor<BroadcastifyFeedConfiguration> {
    private GridPane mEditorPane;
    private TextField mMountPointTextField;
    private IntegerTextField mFeedIdTextField;

    public BroadcastifyStreamEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public void setItem(BroadcastifyFeedConfiguration item) {
        super.setItem(item);
        this.getFeedIdTextField().setDisable(item == null);
        this.getMountPointTextField().setDisable(item == null);
        if (item != null) {
            this.getFeedIdTextField().set(item.getFeedID());
            this.getMountPointTextField().setText(item.getMountPoint());
        } else {
            this.getFeedIdTextField().set(0);
            this.getMountPointTextField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        if (this.getItem() != null) {
            ((BroadcastifyFeedConfiguration)this.getItem()).setFeedID(this.getFeedIdTextField().get());
            ((BroadcastifyFeedConfiguration)this.getItem()).setMountPoint(this.getMountPointTextField().getText());
        }
        super.save();
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.BROADCASTIFY;
    }

    @Override
    protected GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 5.0, 10.0, 10.0));
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(5.0);
            Label formatLabel = new Label("Format");
            GridPane.setHalignment((Node)formatLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)formatLabel, (int)0, (int)0);
            this.mEditorPane.getChildren().add((Object)formatLabel);
            GridPane.setConstraints((Node)this.getFormatField(), (int)1, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getFormatField());
            Label enabledLabel = new Label("Enabled");
            GridPane.setHalignment((Node)enabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)enabledLabel, (int)2, (int)0);
            this.mEditorPane.getChildren().add((Object)enabledLabel);
            GridPane.setConstraints((Node)this.getEnabledSwitch(), (int)3, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getEnabledSwitch());
            Label systemLabel = new Label("Name");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)1);
            this.mEditorPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            Label hostLabel = new Label("Server");
            GridPane.setHalignment((Node)hostLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)hostLabel, (int)0, (int)2);
            this.mEditorPane.getChildren().add((Object)hostLabel);
            GridPane.setConstraints((Node)this.getHostTextField(), (int)1, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getHostTextField());
            Label portLabel = new Label("Port");
            GridPane.setHalignment((Node)portLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)portLabel, (int)2, (int)2);
            this.mEditorPane.getChildren().add((Object)portLabel);
            GridPane.setConstraints((Node)this.getPortTextField(), (int)3, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getPortTextField());
            Label mountPointLabel = new Label("Mount Point");
            GridPane.setHalignment((Node)mountPointLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)mountPointLabel, (int)0, (int)3);
            this.mEditorPane.getChildren().add((Object)mountPointLabel);
            GridPane.setConstraints((Node)this.getMountPointTextField(), (int)1, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getMountPointTextField());
            Label passwordLabel = new Label("Password");
            GridPane.setHalignment((Node)passwordLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)passwordLabel, (int)2, (int)3);
            this.mEditorPane.getChildren().add((Object)passwordLabel);
            GridPane.setConstraints((Node)this.getMaskedPasswordTextField(), (int)3, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getUnMaskedPasswordTextField(), (int)3, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getUnMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getShowPasswordCheckBox(), (int)4, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getShowPasswordCheckBox());
            Label maxAgeLabel = new Label("Max Recording Age (seconds)");
            GridPane.setHalignment((Node)maxAgeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)maxAgeLabel, (int)0, (int)4);
            this.mEditorPane.getChildren().add((Object)maxAgeLabel);
            GridPane.setConstraints((Node)this.getMaxAgeTextField(), (int)1, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getMaxAgeTextField());
            Label delayLabel = new Label("Delay (seconds)");
            GridPane.setHalignment((Node)delayLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)delayLabel, (int)2, (int)4);
            this.mEditorPane.getChildren().add((Object)delayLabel);
            GridPane.setConstraints((Node)this.getDelayTextField(), (int)3, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getDelayTextField());
            Label feedIdLabel = new Label("Feed ID");
            GridPane.setHalignment((Node)feedIdLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)feedIdLabel, (int)0, (int)5);
            this.getEditorPane().getChildren().add((Object)feedIdLabel);
            GridPane.setConstraints((Node)this.getFeedIdTextField(), (int)1, (int)5);
            this.getEditorPane().getChildren().add((Object)this.getFeedIdTextField());
        }
        return this.mEditorPane;
    }

    private TextField getMountPointTextField() {
        if (this.mMountPointTextField == null) {
            this.mMountPointTextField = new TextField();
            this.mMountPointTextField.setDisable(true);
            this.mMountPointTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMountPointTextField;
    }

    private IntegerTextField getFeedIdTextField() {
        if (this.mFeedIdTextField == null) {
            this.mFeedIdTextField = new IntegerTextField();
            this.mFeedIdTextField.setDisable(true);
            this.mFeedIdTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mFeedIdTextField;
    }
}

