/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.streaming.AbstractBroadcastEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public abstract class AbstractStreamEditor<T extends BroadcastConfiguration>
extends AbstractBroadcastEditor<T> {
    private TextField mHostTextField;
    private TextField mUnMaskedPasswordTextField;
    private PasswordField mMaskedPasswordTextField;
    private CheckBox mShowPasswordCheckBox;
    private IntegerTextField mPortTextField;
    private IntegerTextField mDelayTextField;
    private IntegerTextField mMaxAgeTextField;

    public AbstractStreamEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public void setItem(T item) {
        super.setItem(item);
        this.getHostTextField().setDisable(item == null);
        this.getPortTextField().setDisable(item == null);
        this.getMaskedPasswordTextField().setDisable(item == null);
        this.getUnMaskedPasswordTextField().setDisable(item == null);
        this.getMaxAgeTextField().setDisable(item == null);
        this.getDelayTextField().setDisable(item == null);
        if (item != null) {
            this.getHostTextField().setText(((BroadcastConfiguration)item).getHost());
            this.getPortTextField().set(((BroadcastConfiguration)item).getPort());
            this.getMaskedPasswordTextField().setText(((BroadcastConfiguration)item).getPassword());
            this.getMaxAgeTextField().set((int)(((BroadcastConfiguration)item).getMaximumRecordingAge() / 1000L));
            this.getDelayTextField().set((int)(((BroadcastConfiguration)item).getDelay() / 1000L));
        } else {
            this.getHostTextField().setText(null);
            this.getPortTextField().set(0);
            this.getMaskedPasswordTextField().setText(null);
            this.getMaxAgeTextField().set(0);
            this.getDelayTextField().set(0);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void save() {
        BroadcastConfiguration configuration = (BroadcastConfiguration)this.getItem();
        if (configuration != null) {
            configuration.setHost(this.getHostTextField().getText());
            configuration.setPort(this.getPortTextField().get());
            configuration.setPassword(this.getMaskedPasswordTextField().getText());
            configuration.setDelay(this.getDelayTextField().get() * 1000);
            configuration.setMaximumRecordingAge(this.getMaxAgeTextField().get() * 1000);
        }
        super.save();
    }

    @Override
    protected abstract GridPane getEditorPane();

    protected TextField getHostTextField() {
        if (this.mHostTextField == null) {
            this.mHostTextField = new TextField();
            this.mHostTextField.setDisable(true);
            this.mHostTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mHostTextField;
    }

    protected TextField getUnMaskedPasswordTextField() {
        if (this.mUnMaskedPasswordTextField == null) {
            this.mUnMaskedPasswordTextField = new TextField();
            this.mUnMaskedPasswordTextField.setDisable(true);
            this.mUnMaskedPasswordTextField.visibleProperty().bind((ObservableValue)this.getShowPasswordCheckBox().selectedProperty());
            this.mUnMaskedPasswordTextField.textProperty().bindBidirectional((Property)this.getMaskedPasswordTextField().textProperty());
        }
        return this.mUnMaskedPasswordTextField;
    }

    protected PasswordField getMaskedPasswordTextField() {
        if (this.mMaskedPasswordTextField == null) {
            this.mMaskedPasswordTextField = new PasswordField();
            this.mMaskedPasswordTextField.setDisable(true);
            this.mMaskedPasswordTextField.visibleProperty().bind((ObservableValue)this.getShowPasswordCheckBox().selectedProperty().not());
            this.mMaskedPasswordTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMaskedPasswordTextField;
    }

    protected CheckBox getShowPasswordCheckBox() {
        if (this.mShowPasswordCheckBox == null) {
            this.mShowPasswordCheckBox = new CheckBox("Show");
        }
        return this.mShowPasswordCheckBox;
    }

    protected IntegerTextField getPortTextField() {
        if (this.mPortTextField == null) {
            this.mPortTextField = new IntegerTextField();
            this.mPortTextField.setDisable(true);
            this.mPortTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mPortTextField;
    }

    protected IntegerTextField getDelayTextField() {
        if (this.mDelayTextField == null) {
            this.mDelayTextField = new IntegerTextField();
            this.mDelayTextField.setDisable(true);
            this.mDelayTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mDelayTextField;
    }

    protected IntegerTextField getMaxAgeTextField() {
        if (this.mMaxAgeTextField == null) {
            this.mMaxAgeTextField = new IntegerTextField();
            this.mMaxAgeTextField.setDisable(true);
            this.mMaxAgeTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMaxAgeTextField;
    }
}

