/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.source;

import java.text.DecimalFormat;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequencyField
extends TextField {
    private static final Logger mLog = LoggerFactory.getLogger(FrequencyField.class);
    private DecimalFormat mDecimalFormat = new DecimalFormat("0.000000");
    private static final double CONVERT_HZ_TO_MHZ = 1.0E-6;
    private static final double CONVERT_MHZ_TO_HZ = 1000000.0;
    private static final String INTEGER_REGEX = "[1-9]\\d{0,3}";
    private static final String FRACTIONAL_REGEX = "[1-9]\\d{0,3}\\.\\d{0,6}";

    public FrequencyField() {
        UnaryOperator filter = change -> {
            String update = change.getControlNewText();
            if (update.matches(INTEGER_REGEX) || update.matches(FRACTIONAL_REGEX) || update.isEmpty()) {
                return change;
            }
            return null;
        };
        TextFormatter formatter = new TextFormatter((StringConverter)new DoubleStringConverter(), null, filter);
        this.setTextFormatter(formatter);
    }

    public void set(long frequency) {
        if (frequency < 0L || frequency > 9999999999L) {
            throw new IllegalArgumentException("Frequency [" + frequency + "] must be in range 0 <> 9,999,999,999");
        }
        if (frequency == 0L) {
            this.setText("");
        } else {
            this.setText(this.mDecimalFormat.format((double)frequency * 1.0E-6));
        }
    }

    public long get() {
        String raw = this.getText();
        if (raw != null) {
            try {
                double mhz = Double.parseDouble(raw);
                return (long)(mhz * 1000000.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }
}

