/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.record;

import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;

public class RecordConfigurationEditor
extends Editor<RecordConfiguration> {
    private List<RecorderControl> mControls = new ArrayList<RecorderControl>();

    public RecordConfigurationEditor(Collection<RecorderType> types) {
        for (RecorderType type : types) {
            RecorderControl control = new RecorderControl(type);
            this.mControls.add(control);
            this.getChildren().add((Object)control);
        }
    }

    @Override
    public void setItem(RecordConfiguration item) {
        if (item == null) {
            item = new RecordConfiguration();
        }
        super.setItem(item);
        for (RecorderControl control : this.mControls) {
            control.getToggleSwitch().setDisable(false);
            control.getToggleSwitch().setSelected(item.getRecorders().contains((Object)control.getRecorderType()));
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        RecordConfiguration config = (RecordConfiguration)this.getItem();
        if (config == null) {
            config = new RecordConfiguration();
        }
        config.clearRecorders();
        for (RecorderControl control : this.mControls) {
            if (!control.getToggleSwitch().isSelected()) continue;
            config.addRecorder(control.getRecorderType());
        }
        this.setItem(config);
    }

    @Override
    public void dispose() {
    }

    public class RecorderControl
    extends GridPane {
        private RecorderType mRecorderType;
        private ToggleSwitch mToggleSwitch;

        public RecorderControl(RecorderType type) {
            this.mRecorderType = type;
            this.setPadding(new Insets(5.0, 5.0, 5.0, 0.0));
            this.setHgap(10.0);
            GridPane.setConstraints((Node)this.getToggleSwitch(), (int)0, (int)0);
            this.getChildren().add((Object)this.getToggleSwitch());
            Label label = new Label(this.mRecorderType.getDisplayString());
            GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)label, (int)1, (int)0);
            this.getChildren().add((Object)label);
        }

        private ToggleSwitch getToggleSwitch() {
            if (this.mToggleSwitch == null) {
                this.mToggleSwitch = new ToggleSwitch();
                this.mToggleSwitch.setDisable(true);
                this.mToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> RecordConfigurationEditor.this.modifiedProperty().set(true));
            }
            return this.mToggleSwitch;
        }

        public RecorderType getRecorderType() {
            return this.mRecorderType;
        }
    }
}

