/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.EnrichedSite;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.gui.playlist.radioreference.SiteEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.Flavor;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.rrapi.type.Type;
import io.github.dsheirer.rrapi.type.Voice;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSiteSelectionEditor
extends GridPane {
    private static final Logger mLog = LoggerFactory.getLogger(SystemSiteSelectionEditor.class);
    private UserPreferences mUserPreferences;
    private PlaylistManager mPlaylistManager;
    private ProgressIndicator mProgressIndicator;
    private Label mPlaceholderLabel;
    private Label mProtocolLabel;
    private Label mFlavorLabel;
    private Label mVoiceLabel;
    private TableView<EnrichedSite> mSiteTableView;
    private SiteEditor mSiteEditor;
    private RadioReferenceDecoder mRadioReferenceDecoder;
    private System mCurrentSystem;
    private SystemInformation mCurrentSystemInformation;

    public SystemSiteSelectionEditor(UserPreferences userPreferences, PlaylistManager playlistManager) {
        this.mUserPreferences = userPreferences;
        this.mPlaylistManager = playlistManager;
        this.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.setHgap(10.0);
        this.setVgap(10.0);
        int row = 0;
        Label typeLabel = new Label("Protocol:");
        GridPane.setConstraints((Node)typeLabel, (int)0, (int)row);
        GridPane.setHalignment((Node)typeLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)typeLabel);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)1, (int)row);
        GridPane.setHgrow((Node)this.getProtocolLabel(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getProtocolLabel());
        Label voiceLabel = new Label("Voice:");
        GridPane.setConstraints((Node)voiceLabel, (int)2, (int)row);
        GridPane.setHalignment((Node)voiceLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)voiceLabel);
        GridPane.setConstraints((Node)this.getVoiceLabel(), (int)3, (int)row);
        GridPane.setHgrow((Node)this.getVoiceLabel(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getVoiceLabel());
        GridPane.setConstraints(this.getSiteTableView(), (int)0, (int)(++row), (int)4, (int)1);
        this.getChildren().add(this.getSiteTableView());
        GridPane.setConstraints((Node)this.getSiteEditor(), (int)0, (int)(++row), (int)4, (int)1);
        GridPane.setHgrow((Node)this.getSiteEditor(), (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.getSiteEditor(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getSiteEditor());
    }

    public void setSystem(System system, List<EnrichedSite> sites, RadioReferenceDecoder decoder, SystemInformation systemInformation) {
        this.mCurrentSystem = system;
        this.mCurrentSystemInformation = systemInformation;
        this.mRadioReferenceDecoder = decoder;
        Flavor flavor = decoder.getFlavor(system);
        Type type = decoder.getType(system);
        String protocol = (type != null ? type.getName() : "Unknown") + (String)(flavor != null ? " " + flavor.getName() : "");
        this.getProtocolLabel().setText(protocol);
        this.getFlavorLabel().setText(flavor != null ? flavor.getName() : null);
        Voice voice = decoder.getVoice(system);
        this.getVoiceLabel().setText(voice != null ? voice.getName() : null);
        this.getSiteTableView().getItems().addAll(sites);
        this.setLoading(false);
    }

    public void clear() {
        this.getProtocolLabel().setText(null);
        this.getFlavorLabel().setText(null);
        this.getVoiceLabel().setText(null);
        this.getSiteTableView().getItems().clear();
    }

    public void clearAndSetLoading() {
        this.clear();
        this.setLoading(true);
    }

    private SiteEditor getSiteEditor() {
        if (this.mSiteEditor == null) {
            this.mSiteEditor = new SiteEditor(this.mUserPreferences, this.mPlaylistManager);
        }
        return this.mSiteEditor;
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private Label getFlavorLabel() {
        if (this.mFlavorLabel == null) {
            this.mFlavorLabel = new Label();
        }
        return this.mFlavorLabel;
    }

    private Label getVoiceLabel() {
        if (this.mVoiceLabel == null) {
            this.mVoiceLabel = new Label();
        }
        return this.mVoiceLabel;
    }

    private ProgressIndicator getProgressIndicator() {
        if (this.mProgressIndicator == null) {
            this.mProgressIndicator = new ProgressIndicator();
            this.mProgressIndicator.setProgress(-1.0);
        }
        return this.mProgressIndicator;
    }

    private Label getPlaceholderLabel() {
        if (this.mPlaceholderLabel == null) {
            this.mPlaceholderLabel = new Label("Select a system, or there are no sites available for currently selected system");
        }
        return this.mPlaceholderLabel;
    }

    private TableView<EnrichedSite> getSiteTableView() {
        if (this.mSiteTableView == null) {
            this.mSiteTableView = new TableView();
            this.mSiteTableView.setPlaceholder((Node)this.getPlaceholderLabel());
            TableColumn numberColumn = new TableColumn();
            numberColumn.setText("Site");
            numberColumn.setCellValueFactory((Callback)new PropertyValueFactory("siteNumber"));
            numberColumn.setPrefWidth(75.0);
            TableColumn rfssColumn = new TableColumn();
            rfssColumn.setText("RFSS");
            rfssColumn.setCellValueFactory((Callback)new PropertyValueFactory("rfss"));
            rfssColumn.setPrefWidth(60.0);
            TableColumn countyColumn = new TableColumn();
            countyColumn.setText("County");
            countyColumn.setCellValueFactory((Callback)new PropertyValueFactory("countyName"));
            countyColumn.setPrefWidth(125.0);
            TableColumn descriptionColumn = new TableColumn();
            descriptionColumn.setText("Name");
            descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("description"));
            descriptionColumn.setPrefWidth(400.0);
            this.mSiteTableView.getColumns().addAll((Object[])new TableColumn[]{numberColumn, rfssColumn, countyColumn, descriptionColumn});
            this.mSiteTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            this.mSiteTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, selected) -> this.getSiteEditor().setSite((EnrichedSite)selected, this.mCurrentSystem, this.mCurrentSystemInformation, this.mRadioReferenceDecoder));
        }
        return this.mSiteTableView;
    }

    private void setLoading(boolean loading) {
        this.getSiteTableView().setPlaceholder((Node)(loading ? this.getProgressIndicator() : this.getPlaceholderLabel()));
    }
}

