/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.EnrichedSite;
import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceUnavailableAlert;
import io.github.dsheirer.gui.playlist.radioreference.SystemSiteSelectionEditor;
import io.github.dsheirer.gui.playlist.radioreference.SystemTalkgroupSelectionEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.type.CountyInfo;
import io.github.dsheirer.rrapi.type.Flavor;
import io.github.dsheirer.rrapi.type.Site;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.rrapi.type.Type;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(SystemEditor.class);
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private PlaylistManager mPlaylistManager;
    private Level mLevel;
    private ComboBox<System> mSystemComboBox;
    private IntegerProperty mSystemCountProperty = new SimpleIntegerProperty();
    private TabPane mTabPane;
    private Tab mSystemTab;
    private Tab mTalkgroupTab;
    private SystemSiteSelectionEditor mSystemSiteSelectionEditor;
    private SystemTalkgroupSelectionEditor mSystemTalkgroupSelectionEditor;
    private RadioReferenceDecoder mRadioReferenceDecoder;

    public SystemEditor(UserPreferences userPreferences, RadioReference radioReference, PlaylistManager playlistManager, Level level) {
        this.mUserPreferences = userPreferences;
        this.mRadioReference = radioReference;
        this.mPlaylistManager = playlistManager;
        this.mLevel = level;
        this.mSystemCountProperty.bind((ObservableValue)Bindings.size((ObservableList)this.getSystemComboBox().getItems()));
        this.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        HBox systemBox = new HBox();
        HBox.setHgrow(this.getSystemComboBox(), (Priority)Priority.ALWAYS);
        systemBox.setAlignment(Pos.CENTER_LEFT);
        systemBox.setSpacing(5.0);
        systemBox.setMaxWidth(Double.MAX_VALUE);
        systemBox.getChildren().addAll((Object[])new Node[]{new Label("System"), this.getSystemComboBox()});
        VBox.setVgrow((Node)this.getTabPane(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{systemBox, this.getTabPane()});
    }

    public IntegerProperty systemCountProperty() {
        return this.mSystemCountProperty;
    }

    public void clear() {
        this.getSystemComboBox().getItems().clear();
        this.getSystemSiteSelectionEditor().clear();
        this.getSystemTalkgroupSelectionEditor().clear();
    }

    public void setSystems(List<System> systems) {
        this.clear();
        if (systems != null && !systems.isEmpty()) {
            Collections.sort(systems, new SystemComparator(this));
            this.getSystemComboBox().getItems().addAll(systems);
            int preferredSystemId = this.mUserPreferences.getRadioReferencePreference().getPreferredSystemId(this.mLevel);
            for (System system : this.getSystemComboBox().getItems()) {
                if (system.getSystemId() != preferredSystemId) continue;
                this.getSystemComboBox().getSelectionModel().select((Object)system);
                return;
            }
        }
    }

    private TabPane getTabPane() {
        if (this.mTabPane == null) {
            this.mTabPane = new TabPane();
            this.mTabPane.setMaxHeight(Double.MAX_VALUE);
            this.mTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            this.mTabPane.getTabs().addAll((Object[])new Tab[]{this.getSystemTab(), this.getTalkgroupTab()});
        }
        return this.mTabPane;
    }

    private SystemSiteSelectionEditor getSystemSiteSelectionEditor() {
        if (this.mSystemSiteSelectionEditor == null) {
            this.mSystemSiteSelectionEditor = new SystemSiteSelectionEditor(this.mUserPreferences, this.mPlaylistManager);
        }
        return this.mSystemSiteSelectionEditor;
    }

    private Tab getSystemTab() {
        if (this.mSystemTab == null) {
            this.mSystemTab = new Tab("System View");
            this.mSystemTab.setContent((Node)this.getSystemSiteSelectionEditor());
        }
        return this.mSystemTab;
    }

    private SystemTalkgroupSelectionEditor getSystemTalkgroupSelectionEditor() {
        if (this.mSystemTalkgroupSelectionEditor == null) {
            this.mSystemTalkgroupSelectionEditor = new SystemTalkgroupSelectionEditor(this.mUserPreferences, this.mPlaylistManager);
        }
        return this.mSystemTalkgroupSelectionEditor;
    }

    private Tab getTalkgroupTab() {
        if (this.mTalkgroupTab == null) {
            this.mTalkgroupTab = new Tab("Talkgroup View");
            this.mTalkgroupTab.setContent((Node)this.getSystemTalkgroupSelectionEditor());
        }
        return this.mTalkgroupTab;
    }

    private ComboBox<System> getSystemComboBox() {
        if (this.mSystemComboBox == null) {
            this.mSystemComboBox = new ComboBox();
            this.mSystemComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mSystemComboBox.setCellFactory(param -> new SystemListCell());
            this.mSystemComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setSystem((System)newValue));
        }
        return this.mSystemComboBox;
    }

    private boolean isSupported(System system) {
        return this.mRadioReferenceDecoder != null && this.mRadioReferenceDecoder.hasSupportedProtocol(system);
    }

    private String getType(System system) {
        if (this.mRadioReferenceDecoder == null) {
            try {
                this.initRadioReferenceDecoder();
            }
            catch (Throwable t) {
                mLog.error("Error retrieving system information", t);
            }
        }
        if (this.mRadioReferenceDecoder != null) {
            Type type = this.mRadioReferenceDecoder.getType(system);
            Flavor flavor = this.mRadioReferenceDecoder.getFlavor(system);
            if (type != null) {
                if (flavor != null) {
                    return type.getName() + " " + flavor.getName();
                }
                return type.getName();
            }
        }
        return "Unknown";
    }

    private void setSystem(System system) {
        if (system != null) {
            this.getSystemSiteSelectionEditor().clearAndSetLoading();
            this.getSystemTalkgroupSelectionEditor().clearAndSetLoading();
            this.mUserPreferences.getRadioReferencePreference().setPreferredSystemId(system.getSystemId(), this.mLevel);
            ThreadPool.CACHED.execute(() -> {
                try {
                    if (this.mRadioReferenceDecoder == null) {
                        this.initRadioReferenceDecoder();
                    }
                    SystemInformation systemInformation = this.mRadioReference.getService().getSystemInformation(system.getSystemId());
                    List sites = this.mRadioReference.getService().getSites(system.getSystemId());
                    ArrayList<EnrichedSite> enrichedSites = new ArrayList<EnrichedSite>();
                    for (Site site : sites) {
                        CountyInfo countyInfo = null;
                        int countyId = site.getCountyId();
                        if (countyId > 0 && countyId != 99999) {
                            countyInfo = this.mRadioReference.getService().getCountyInfo(site.getCountyId());
                        }
                        enrichedSites.add(new EnrichedSite(site, countyInfo));
                    }
                    Platform.runLater(() -> this.getSystemSiteSelectionEditor().setSystem(system, enrichedSites, this.mRadioReferenceDecoder, systemInformation));
                    List talkgroups = this.mRadioReference.getService().getTalkgroups(system.getSystemId());
                    List categories = this.mRadioReference.getService().getTalkgroupCategories(system.getSystemId());
                    Platform.runLater(() -> this.getSystemTalkgroupSelectionEditor().setSystem(system, talkgroups, categories, this.mRadioReferenceDecoder));
                }
                catch (Throwable t) {
                    mLog.error("Error retrieving system information", t);
                    Platform.runLater(() -> {
                        this.getSystemTalkgroupSelectionEditor().setSystem(null, Collections.emptyList(), Collections.emptyList(), this.mRadioReferenceDecoder);
                        this.getSystemSiteSelectionEditor().setSystem(null, Collections.emptyList(), this.mRadioReferenceDecoder, null);
                        new RadioReferenceUnavailableAlert((Node)this.getSystemComboBox()).showAndWait();
                    });
                }
            });
        } else {
            this.getSystemSiteSelectionEditor().clear();
            this.getSystemTalkgroupSelectionEditor().clear();
        }
    }

    private void initRadioReferenceDecoder() throws RadioReferenceException {
        Map typeMap = this.mRadioReference.getService().getTypesMap();
        Map flavorMap = this.mRadioReference.getService().getFlavorsMap();
        Map voiceMap = this.mRadioReference.getService().getVoicesMap();
        Map tagMap = this.mRadioReference.getService().getTagsMap();
        this.mRadioReferenceDecoder = new RadioReferenceDecoder(this.mUserPreferences, typeMap, flavorMap, voiceMap, tagMap);
    }

    public class SystemComparator
    implements Comparator<System> {
        public SystemComparator(SystemEditor this$0) {
        }

        @Override
        public int compare(System o1, System o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return 1;
            }
            if (o2.getName() == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public class SystemListCell
    extends ListCell<System> {
        private HBox mHBox = new HBox();
        private Label mName;
        private Label mProtocol;
        private IconNode mIconNode;

        public SystemListCell() {
            this.mHBox.setSpacing(15.0);
            this.mHBox.setPadding(new Insets(0.0, 15.0, 0.0, 0.0));
            this.mHBox.setMaxWidth(Double.MAX_VALUE);
            this.mName = new Label();
            this.mName.setMaxWidth(Double.MAX_VALUE);
            this.mName.setAlignment(Pos.CENTER_LEFT);
            this.mProtocol = new Label();
            this.mProtocol.setMaxWidth(Double.MAX_VALUE);
            this.mProtocol.setAlignment(Pos.CENTER_RIGHT);
            this.mProtocol.setContentDisplay(ContentDisplay.RIGHT);
            HBox.setHgrow((Node)this.mName, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.mProtocol, (Priority)Priority.ALWAYS);
            this.mHBox.getChildren().addAll((Object[])new Node[]{this.mName, this.mProtocol});
        }

        protected void updateItem(System item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            if (empty || item == null) {
                this.setGraphic(null);
                this.mName.setText(null);
                this.mProtocol.setText(null);
            } else {
                this.mName.setText(item.getName());
                this.mProtocol.setText(SystemEditor.this.getType(item));
                if (SystemEditor.this.isSupported(item)) {
                    this.mIconNode = new IconNode((IconCode)FontAwesome.CHECK);
                    this.mIconNode.setFill((Paint)Color.GREEN);
                } else {
                    this.mIconNode = new IconNode((IconCode)FontAwesome.BAN);
                    this.mIconNode.setFill((Paint)Color.RED);
                }
                this.mProtocol.setGraphic((Node)this.mIconNode);
                this.setGraphic((Node)this.mHBox);
            }
        }
    }
}

