/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.control.MaxLengthUnaryOperator;
import io.github.dsheirer.gui.playlist.channel.ViewChannelRequest;
import io.github.dsheirer.gui.playlist.radioreference.EnrichedSite;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceDecoder;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.dmr.DecodeConfigDMR;
import io.github.dsheirer.module.decode.dmr.channel.TimeslotFrequency;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.type.RadioNetwork;
import io.github.dsheirer.rrapi.type.Site;
import io.github.dsheirer.rrapi.type.SiteFrequency;
import io.github.dsheirer.rrapi.type.System;
import io.github.dsheirer.rrapi.type.SystemInformation;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.animation.RotateTransition;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.control.SegmentedButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteEditor
extends GridPane {
    private static final Logger mLog = LoggerFactory.getLogger(SiteEditor.class);
    private static final String ALTERNATE_CONTROL_CHANNEL = "a";
    private static final String PRIMARY_CONTROL_CHANNEL = "d";
    private static final String TOGGLE_BUTTON_CONTROL = "Control";
    private static final String TOGGLE_BUTTON_P25_VOICE = "All P25 Voice";
    private UserPreferences mUserPreferences;
    private PlaylistManager mPlaylistManager;
    private TableView<SiteFrequency> mSiteFrequencyTableView;
    private TableColumn<SiteFrequency, String> mTypeColumn;
    private SegmentedButton mFrequenciesSegmentedButton;
    private ToggleButton mControlToggleButton;
    private ToggleButton mControlAndAltToggleButton;
    private ToggleButton mSelectedToggleButton;
    private ToggleButton mAllToggleButton;
    private SegmentedButton mConfigurationsSegmentedButton;
    private ToggleButton mSingleToggleButton;
    private ToggleButton mForEachToggleButton;
    private Button mCreateChannelConfigurationButton;
    private TextField mSystemTextField;
    private TextField mSiteTextField;
    private TextField mNameTextField;
    private CheckBox mGoToChannelEditorCheckBox;
    private Label mProtocolNotSupportedLabel;
    private RadioReferenceDecoder mRadioReferenceDecoder;
    private EnrichedSite mCurrentSite;
    private System mCurrentSystem;
    private SystemInformation mCurrentSystemInformation;
    private ComboBox mAliasListNameComboBox;
    private Button mNewAliasListButton;

    public SiteEditor(UserPreferences userPreferences, PlaylistManager playlistManager) {
        this.mUserPreferences = userPreferences;
        this.mPlaylistManager = playlistManager;
        this.setMaxHeight(Double.MAX_VALUE);
        this.setHgap(5.0);
        this.setVgap(5.0);
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPercentWidth(40.0);
        ColumnConstraints column2 = new ColumnConstraints();
        ColumnConstraints column3 = new ColumnConstraints();
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        int row = 0;
        Label siteFrequencies = new Label("Frequencies");
        GridPane.setConstraints((Node)siteFrequencies, (int)0, (int)row);
        this.getChildren().add((Object)siteFrequencies);
        Label createChannelLabel = new Label("Create Channel Configuration(s)");
        GridPane.setConstraints((Node)createChannelLabel, (int)2, (int)row);
        GridPane.setHalignment((Node)createChannelLabel, (HPos)HPos.LEFT);
        this.getChildren().add((Object)createChannelLabel);
        GridPane.setConstraints(this.getSiteFrequencyTableView(), (int)0, (int)(++row), (int)1, (int)10);
        GridPane.setHgrow(this.getSiteFrequencyTableView(), (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.getSiteFrequencyTableView(), (Priority)Priority.ALWAYS);
        this.getChildren().add(this.getSiteFrequencyTableView());
        Label frequenciesLabel = new Label("Frequencies:");
        GridPane.setConstraints((Node)frequenciesLabel, (int)1, (int)row);
        GridPane.setHalignment((Node)frequenciesLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)frequenciesLabel);
        GridPane.setConstraints((Node)this.getFrequenciesSegmentedButton(), (int)2, (int)row);
        this.getChildren().add((Object)this.getFrequenciesSegmentedButton());
        Label configurationsLabel = new Label("Configurations:");
        GridPane.setConstraints((Node)configurationsLabel, (int)1, (int)(++row));
        GridPane.setHalignment((Node)configurationsLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)configurationsLabel);
        GridPane.setConstraints((Node)this.getConfigurationsSegmentedButton(), (int)2, (int)row);
        this.getChildren().add((Object)this.getConfigurationsSegmentedButton());
        Label systemLabel = new Label("System");
        GridPane.setConstraints((Node)systemLabel, (int)1, (int)(++row));
        GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)systemLabel);
        GridPane.setConstraints((Node)this.getSystemTextField(), (int)2, (int)row);
        GridPane.setHgrow((Node)this.getSystemTextField(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getSystemTextField());
        Label siteLabel = new Label("Site");
        GridPane.setConstraints((Node)siteLabel, (int)1, (int)(++row));
        GridPane.setHalignment((Node)siteLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)siteLabel);
        GridPane.setConstraints((Node)this.getSiteTextField(), (int)2, (int)row);
        GridPane.setHgrow((Node)this.getSiteTextField(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getSiteTextField());
        Label nameLabel = new Label("Name");
        GridPane.setConstraints((Node)nameLabel, (int)1, (int)(++row));
        GridPane.setHalignment((Node)nameLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)nameLabel);
        GridPane.setConstraints((Node)this.getNameTextField(), (int)2, (int)row);
        GridPane.setHgrow((Node)this.getNameTextField(), (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.getNameTextField());
        Label aliasListLabel = new Label("Alias List");
        GridPane.setConstraints((Node)aliasListLabel, (int)1, (int)(++row));
        GridPane.setHalignment((Node)aliasListLabel, (HPos)HPos.RIGHT);
        this.getChildren().add((Object)aliasListLabel);
        GridPane.setConstraints(this.getAliasListNameComboBox(), (int)2, (int)row);
        GridPane.setHgrow(this.getAliasListNameComboBox(), (Priority)Priority.ALWAYS);
        this.getChildren().add(this.getAliasListNameComboBox());
        GridPane.setConstraints((Node)this.getNewAliasListButton(), (int)2, (int)(++row));
        this.getChildren().add((Object)this.getNewAliasListButton());
        HBox createBox = new HBox();
        createBox.setAlignment(Pos.CENTER_LEFT);
        createBox.setSpacing(10.0);
        createBox.getChildren().addAll((Object[])new Node[]{this.getCreateChannelConfigurationButton(), this.getGoToChannelEditorCheckBox()});
        GridPane.setConstraints((Node)createBox, (int)2, (int)(++row + 1));
        this.getChildren().addAll((Object[])new Node[]{createBox});
        GridPane.setConstraints((Node)this.getProtocolNotSupportedLabel(), (int)2, (int)row);
        this.getChildren().add((Object)this.getProtocolNotSupportedLabel());
    }

    private DecodeConfiguration getDecodeConfiguration(DecoderType decoderType, Site site, SystemInformation systemInformation) {
        if (decoderType == null) {
            return null;
        }
        switch (decoderType) {
            case DMR: {
                DecodeConfigDMR dmr = new DecodeConfigDMR();
                List<TimeslotFrequency> timeslotFrequencies = this.mRadioReferenceDecoder.getTimeslotFrequencies(systemInformation, site);
                dmr.setTimeslotMap(timeslotFrequencies);
                return dmr;
            }
            case P25_PHASE1: {
                DecodeConfiguration p1config = DecoderFactory.getDecodeConfiguration(decoderType);
                if (this.mRadioReferenceDecoder.isLSM(site) && p1config instanceof DecodeConfigP25Phase1) {
                    ((DecodeConfigP25Phase1)p1config).setModulation(P25P1Decoder.Modulation.CQPSK);
                }
                return p1config;
            }
            case P25_PHASE2: {
                DecodeConfigP25Phase2 config = new DecodeConfigP25Phase2();
                int nac = 0;
                if (site != null && site.getNac() != null) {
                    try {
                        nac = Integer.parseInt(site.getNac(), 16);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int wacn = 0;
                int system = 0;
                if (systemInformation != null && systemInformation.getRadioNetworks() != null && !systemInformation.getRadioNetworks().isEmpty()) {
                    RadioNetwork radioNetwork = (RadioNetwork)systemInformation.getRadioNetworks().get(0);
                    if (radioNetwork.getWacn() != null) {
                        try {
                            wacn = Integer.parseInt(radioNetwork.getWacn(), 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (radioNetwork.getSystemId() != null) {
                        try {
                            system = Integer.parseInt(radioNetwork.getSystemId(), 16);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                config.setScrambleParameters(new ScrambleParameters(wacn, system, nac));
                return config;
            }
        }
        return DecoderFactory.getDecodeConfiguration(decoderType);
    }

    public void setSite(EnrichedSite site, System system, SystemInformation systemInformation, RadioReferenceDecoder decoder) {
        this.mCurrentSite = site;
        this.mCurrentSystem = system;
        this.mCurrentSystemInformation = systemInformation;
        this.mRadioReferenceDecoder = decoder;
        this.getSiteFrequencyTableView().getItems().clear();
        boolean disable = site == null || site.getSite().getSiteFrequencies().isEmpty();
        boolean supported = decoder.hasSupportedProtocol(system);
        this.getFrequenciesSegmentedButton().setDisable(disable || !supported);
        this.getConfigurationsSegmentedButton().setDisable(disable || !supported);
        this.getSystemTextField().setDisable(disable || !supported);
        this.getSiteTextField().setDisable(disable || !supported);
        this.getNameTextField().setDisable(disable || !supported);
        this.getCreateChannelConfigurationButton().setDisable(disable || !supported);
        this.getGoToChannelEditorCheckBox().setDisable(disable || !supported);
        this.getAliasListNameComboBox().setDisable(disable || !supported);
        this.getNewAliasListButton().setDisable(disable || !supported);
        this.getCreateChannelConfigurationButton().setVisible(false);
        this.getGoToChannelEditorCheckBox().setVisible(false);
        this.getProtocolNotSupportedLabel().setVisible(false);
        if (site != null) {
            List siteFrequencies = site.getSite().getSiteFrequencies();
            for (SiteFrequency siteFrequency : siteFrequencies) {
                if (!(siteFrequency.getFrequency() > 0.01)) continue;
                this.getSiteFrequencyTableView().getItems().add((Object)siteFrequency);
            }
            this.mSiteFrequencyTableView.getSortOrder().clear();
            this.mTypeColumn.setSortType(TableColumn.SortType.DESCENDING);
            this.mSiteFrequencyTableView.getSortOrder().addAll((Object[])new TableColumn[]{this.mTypeColumn});
            this.getSiteFrequencyTableView().sort();
            if (!supported) {
                this.getProtocolNotSupportedLabel().setVisible(true);
            } else {
                this.getCreateChannelConfigurationButton().setVisible(true);
                this.getGoToChannelEditorCheckBox().setVisible(true);
                this.getSystemTextField().setText(system.getName());
                this.getSiteTextField().setText(this.mCurrentSite.getCountyName());
                this.getNameTextField().setText(TOGGLE_BUTTON_CONTROL);
                if (!siteFrequencies.isEmpty()) {
                    boolean hasControl = SiteEditor.hasControl(siteFrequencies);
                    boolean hasAlternate = SiteEditor.hasAlternate(siteFrequencies);
                    boolean p25Hybrid = decoder.isHybridMotorolaP25(system);
                    boolean ltr = this.mRadioReferenceDecoder.isLTR(system);
                    if (ltr) {
                        this.getControlToggleButton().setDisable(true);
                        this.getControlToggleButton().setText(TOGGLE_BUTTON_CONTROL);
                        this.getControlToggleButton().setSelected(false);
                        this.getControlAndAltToggleButton().setDisable(true);
                        this.getControlAndAltToggleButton().setSelected(false);
                        this.getSelectedToggleButton().setDisable(false);
                        this.getSelectedToggleButton().setSelected(false);
                        this.getAllToggleButton().setDisable(false);
                        this.getAllToggleButton().setSelected(true);
                        this.getSingleToggleButton().setDisable(true);
                        this.getSingleToggleButton().setSelected(false);
                        this.getForEachToggleButton().setDisable(false);
                        this.getForEachToggleButton().setSelected(true);
                    } else if (p25Hybrid) {
                        this.getControlToggleButton().setDisable(false);
                        this.getControlToggleButton().setText(TOGGLE_BUTTON_P25_VOICE);
                        this.getControlToggleButton().setSelected(true);
                        this.getControlAndAltToggleButton().setDisable(true);
                        this.getControlAndAltToggleButton().setSelected(false);
                        this.getSelectedToggleButton().setDisable(false);
                        this.getSelectedToggleButton().setSelected(false);
                        this.getAllToggleButton().setDisable(true);
                        this.getAllToggleButton().setSelected(false);
                    } else {
                        this.getControlToggleButton().setDisable(!hasControl);
                        this.getControlToggleButton().setText(TOGGLE_BUTTON_CONTROL);
                        this.getControlAndAltToggleButton().setDisable(!hasAlternate);
                        this.getSelectedToggleButton().setDisable(false);
                        this.getAllToggleButton().setDisable(false);
                        if (hasControl) {
                            this.getControlToggleButton().setSelected(true);
                            this.getControlAndAltToggleButton().setSelected(false);
                            this.getSelectedToggleButton().setSelected(false);
                            this.getAllToggleButton().setSelected(false);
                        } else if (hasAlternate) {
                            this.getControlToggleButton().setSelected(false);
                            this.getControlAndAltToggleButton().setSelected(true);
                            this.getSelectedToggleButton().setSelected(false);
                            this.getAllToggleButton().setSelected(false);
                        } else {
                            this.getControlToggleButton().setSelected(false);
                            this.getControlAndAltToggleButton().setSelected(false);
                            this.getSelectedToggleButton().setSelected(false);
                            this.getAllToggleButton().setSelected(true);
                        }
                        this.getSingleToggleButton().setDisable(false);
                        this.getSingleToggleButton().setSelected(true);
                        this.getForEachToggleButton().setDisable(false);
                        this.getForEachToggleButton().setSelected(false);
                    }
                }
            }
        } else {
            this.getSystemTextField().setText(null);
            this.getSiteTextField().setText(null);
            this.getNameTextField().setText(null);
        }
    }

    private Channel getChannelTemplate() {
        Channel channel = new Channel();
        channel.setName(this.getNameTextField().getText());
        channel.setSite(this.getSiteTextField().getText());
        channel.setSystem(this.getSystemTextField().getText());
        channel.setAliasListName((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem());
        return channel;
    }

    private void createHybridP25VoiceChannels() {
        Channel gotoChannel = null;
        for (SiteFrequency siteFrequency : this.getSiteFrequencyTableView().getItems()) {
            if (SiteEditor.isControl(siteFrequency) || !(siteFrequency.getFrequency() > 0.01)) continue;
            Channel channel = this.getChannelTemplate();
            channel.setName("LCN " + siteFrequency.getLogicalChannelNumber());
            DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
            channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
            SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
            sourceConfigTuner.setFrequency(SiteEditor.getFrequency(siteFrequency));
            channel.setSourceConfiguration(sourceConfigTuner);
            if (gotoChannel == null) {
                gotoChannel = channel;
            }
            this.mPlaylistManager.getChannelModel().addChannel(channel);
        }
        if (this.getGoToChannelEditorCheckBox().isSelected() && gotoChannel != null) {
            MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(gotoChannel));
        }
    }

    private void createControlChannel() {
        ArrayList<SiteFrequency> controls = new ArrayList<SiteFrequency>();
        for (SiteFrequency siteFrequency : this.getSiteFrequencyTableView().getItems()) {
            if (!SiteEditor.isControl(siteFrequency) || !(siteFrequency.getFrequency() > 0.01)) continue;
            controls.add(siteFrequency);
        }
        if (controls.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.ERROR, "Site Has No Control Channel(s)", new ButtonType[]{ButtonType.OK});
            alert.setTitle("Create Channel Configuration");
            alert.setHeaderText("Can't Create Channel Configuration");
            alert.initOwner(this.getCreateChannelConfigurationButton().getScene().getWindow());
            alert.showAndWait();
            return;
        }
        if (this.mRadioReferenceDecoder.hasSupportedProtocol(this.mCurrentSystem)) {
            Channel channel = this.getChannelTemplate();
            DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
            if (decoderType == DecoderType.P25_PHASE2) {
                decoderType = DecoderType.P25_PHASE1;
            }
            channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
            if (controls.size() == 1) {
                SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
                sourceConfigTuner.setFrequency((long)(((SiteFrequency)controls.get(0)).getFrequency() * 1000000.0));
                channel.setSourceConfiguration(sourceConfigTuner);
            } else {
                SourceConfigTunerMultipleFrequency sourceConfig = new SourceConfigTunerMultipleFrequency();
                for (SiteFrequency control : controls) {
                    sourceConfig.addFrequency((long)(control.getFrequency() * 1000000.0));
                }
                channel.setSourceConfiguration(sourceConfig);
            }
            this.mPlaylistManager.getChannelModel().addChannel(channel);
            if (this.getGoToChannelEditorCheckBox().isSelected()) {
                MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel));
            }
        }
    }

    private void createControlAndAlternatesChannel() {
        ArrayList<SiteFrequency> siteFrequencies = new ArrayList<SiteFrequency>();
        for (SiteFrequency siteFrequency : this.getSiteFrequencyTableView().getItems()) {
            if (!SiteEditor.isControl(siteFrequency) || !(siteFrequency.getFrequency() > 0.01)) continue;
            siteFrequencies.add(siteFrequency);
        }
        for (SiteFrequency siteFrequency : this.getSiteFrequencyTableView().getItems()) {
            if (!SiteEditor.isAlternate(siteFrequency) || !(siteFrequency.getFrequency() > 0.01)) continue;
            siteFrequencies.add(siteFrequency);
        }
        if (siteFrequencies.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.ERROR, "Site Has No Control or Alternate Channel(s)", new ButtonType[]{ButtonType.OK});
            alert.setTitle("Create Channel Configuration");
            alert.setHeaderText("Can't Create Channel Configuration");
            alert.initOwner(this.getCreateChannelConfigurationButton().getScene().getWindow());
            alert.showAndWait();
            return;
        }
        if (this.mRadioReferenceDecoder.hasSupportedProtocol(this.mCurrentSystem)) {
            if (this.getSingleToggleButton().isSelected()) {
                Channel channel = this.getChannelTemplate();
                DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
                if (decoderType == DecoderType.P25_PHASE2) {
                    decoderType = DecoderType.P25_PHASE1;
                }
                channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
                if (siteFrequencies.size() == 1) {
                    SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
                    sourceConfigTuner.setFrequency(SiteEditor.getFrequency((SiteFrequency)siteFrequencies.get(0)));
                    channel.setSourceConfiguration(sourceConfigTuner);
                } else {
                    SourceConfigTunerMultipleFrequency sourceConfig = new SourceConfigTunerMultipleFrequency();
                    ArrayList<Long> frequencies = new ArrayList<Long>();
                    for (SiteFrequency siteFrequency : siteFrequencies) {
                        frequencies.add(SiteEditor.getFrequency(siteFrequency));
                    }
                    sourceConfig.setFrequencies(frequencies);
                    channel.setSourceConfiguration(sourceConfig);
                }
                this.mPlaylistManager.getChannelModel().addChannel(channel);
                if (this.getGoToChannelEditorCheckBox().isSelected()) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel));
                }
            } else {
                Channel gotoChannel = null;
                for (SiteFrequency siteFrequency : siteFrequencies) {
                    Channel channel = this.getChannelTemplate();
                    channel.setName("LCN " + siteFrequency.getLogicalChannelNumber());
                    DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
                    channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
                    SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
                    sourceConfigTuner.setFrequency(SiteEditor.getFrequency(siteFrequency));
                    channel.setSourceConfiguration(sourceConfigTuner);
                    if (gotoChannel == null) {
                        gotoChannel = channel;
                    }
                    this.mPlaylistManager.getChannelModel().addChannel(channel);
                }
                if (this.getGoToChannelEditorCheckBox().isSelected() && gotoChannel != null) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(gotoChannel));
                }
            }
        }
    }

    private void createChannels(boolean selectedOnly) {
        ArrayList siteFrequencies = new ArrayList(selectedOnly ? this.getSiteFrequencyTableView().getSelectionModel().getSelectedItems() : this.getSiteFrequencyTableView().getItems());
        Iterator it = siteFrequencies.iterator();
        while (it.hasNext()) {
            if (!(((SiteFrequency)it.next()).getFrequency() < 0.01)) continue;
            it.remove();
        }
        if (siteFrequencies.isEmpty()) {
            String context = selectedOnly ? "Please select frequencies" : "Site has no channel frequencies";
            Alert alert = new Alert(Alert.AlertType.ERROR, context, new ButtonType[]{ButtonType.OK});
            alert.setTitle("Create Channel Configuration");
            alert.setHeaderText("Can't Create Channel Configuration");
            alert.initOwner(this.getCreateChannelConfigurationButton().getScene().getWindow());
            alert.showAndWait();
            return;
        }
        if (this.mRadioReferenceDecoder.hasSupportedProtocol(this.mCurrentSystem)) {
            if (this.getSingleToggleButton().isSelected()) {
                Channel channel = this.getChannelTemplate();
                DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
                channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
                if (siteFrequencies.size() == 1) {
                    SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
                    sourceConfigTuner.setFrequency(SiteEditor.getFrequency((SiteFrequency)siteFrequencies.get(0)));
                    channel.setSourceConfiguration(sourceConfigTuner);
                } else {
                    SourceConfigTunerMultipleFrequency sourceConfig = new SourceConfigTunerMultipleFrequency();
                    ArrayList<Long> frequencies = new ArrayList<Long>();
                    for (SiteFrequency siteFrequency : siteFrequencies) {
                        frequencies.add(SiteEditor.getFrequency(siteFrequency));
                    }
                    sourceConfig.setFrequencies(frequencies);
                    channel.setSourceConfiguration(sourceConfig);
                }
                this.mPlaylistManager.getChannelModel().addChannel(channel);
                if (this.getGoToChannelEditorCheckBox().isSelected()) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(channel));
                }
            } else {
                Channel gotoChannel = null;
                for (SiteFrequency siteFrequency : siteFrequencies) {
                    Channel channel = this.getChannelTemplate();
                    channel.setName("LCN " + siteFrequency.getLogicalChannelNumber());
                    DecoderType decoderType = this.mRadioReferenceDecoder.getDecoderType(this.mCurrentSystem);
                    channel.setDecodeConfiguration(this.getDecodeConfiguration(decoderType, this.mCurrentSite.getSite(), this.mCurrentSystemInformation));
                    SourceConfigTuner sourceConfigTuner = new SourceConfigTuner();
                    sourceConfigTuner.setFrequency(SiteEditor.getFrequency(siteFrequency));
                    channel.setSourceConfiguration(sourceConfigTuner);
                    if (gotoChannel == null) {
                        gotoChannel = channel;
                    }
                    this.mPlaylistManager.getChannelModel().addChannel(channel);
                }
                if (this.getGoToChannelEditorCheckBox().isSelected() && gotoChannel != null) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewChannelRequest(gotoChannel));
                }
            }
        }
    }

    private static long getFrequency(SiteFrequency siteFrequency) {
        return (long)(siteFrequency.getFrequency() * 1000000.0);
    }

    private void flashAliasListComboBox() {
        RotateTransition rt = new RotateTransition(Duration.millis((double)150.0), this.getAliasListNameComboBox());
        rt.setByAngle(5.0);
        rt.setCycleCount(4);
        rt.setAutoReverse(true);
        rt.play();
    }

    private ComboBox<String> getAliasListNameComboBox() {
        if (this.mAliasListNameComboBox == null) {
            Predicate<String> filterPredicate = s -> !s.contentEquals("(No Alias List)");
            FilteredList filteredChannelList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasListNames(), filterPredicate);
            this.mAliasListNameComboBox = new ComboBox((ObservableList)filteredChannelList);
            this.mAliasListNameComboBox.setDisable(true);
            this.mAliasListNameComboBox.setMaxWidth(Double.MAX_VALUE);
            if (this.mAliasListNameComboBox.getItems().size() > 0) {
                this.mAliasListNameComboBox.getSelectionModel().select(0);
            } else {
                this.mAliasListNameComboBox.getSelectionModel().select(null);
            }
        }
        return this.mAliasListNameComboBox;
    }

    private Button getNewAliasListButton() {
        if (this.mNewAliasListButton == null) {
            this.mNewAliasListButton = new Button("New Alias List");
            this.mNewAliasListButton.setDisable(true);
            this.mNewAliasListButton.setOnAction(event -> {
                TextInputDialog dialog = new TextInputDialog();
                dialog.setTitle("Create New Alias List");
                dialog.setHeaderText("Please enter an alias list name (max 25 chars).");
                dialog.setContentText("Name:");
                dialog.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)new MaxLengthUnaryOperator(25)));
                Optional result = dialog.showAndWait();
                result.ifPresent(s -> {
                    String name = (String)result.get();
                    if (name != null && !name.isEmpty()) {
                        name = name.trim();
                        this.mPlaylistManager.getAliasModel().addAliasList(name);
                        this.getAliasListNameComboBox().getSelectionModel().select((Object)name);
                    }
                });
            });
        }
        return this.mNewAliasListButton;
    }

    private Label getProtocolNotSupportedLabel() {
        if (this.mProtocolNotSupportedLabel == null) {
            this.mProtocolNotSupportedLabel = new Label("Protocol Not Supported");
            this.mProtocolNotSupportedLabel.setVisible(false);
        }
        return this.mProtocolNotSupportedLabel;
    }

    private SegmentedButton getConfigurationsSegmentedButton() {
        if (this.mConfigurationsSegmentedButton == null) {
            this.mConfigurationsSegmentedButton = new SegmentedButton(new ToggleButton[]{this.getSingleToggleButton(), this.getForEachToggleButton()});
            this.mConfigurationsSegmentedButton.getStyleClass().add((Object)"dark");
            this.mConfigurationsSegmentedButton.setDisable(true);
            this.mConfigurationsSegmentedButton.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == null) {
                    oldValue.setSelected(true);
                } else {
                    this.getNameTextField().setDisable(this.getForEachToggleButton().isSelected());
                }
            });
        }
        return this.mConfigurationsSegmentedButton;
    }

    private ToggleButton getSingleToggleButton() {
        if (this.mSingleToggleButton == null) {
            this.mSingleToggleButton = new ToggleButton("Single");
        }
        return this.mSingleToggleButton;
    }

    private ToggleButton getForEachToggleButton() {
        if (this.mForEachToggleButton == null) {
            this.mForEachToggleButton = new ToggleButton("For Each Frequency");
        }
        return this.mForEachToggleButton;
    }

    private SegmentedButton getFrequenciesSegmentedButton() {
        if (this.mFrequenciesSegmentedButton == null) {
            this.mFrequenciesSegmentedButton = new SegmentedButton(new ToggleButton[]{this.getControlToggleButton(), this.getControlAndAltToggleButton(), this.getSelectedToggleButton(), this.getAllToggleButton()});
            this.mFrequenciesSegmentedButton.getStyleClass().add((Object)"dark");
            this.mFrequenciesSegmentedButton.setDisable(true);
            this.mFrequenciesSegmentedButton.getToggleGroup().selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == null) {
                    oldValue.setSelected(true);
                }
            });
        }
        return this.mFrequenciesSegmentedButton;
    }

    private ToggleButton getControlToggleButton() {
        if (this.mControlToggleButton == null) {
            this.mControlToggleButton = new ToggleButton(TOGGLE_BUTTON_CONTROL);
        }
        return this.mControlToggleButton;
    }

    private ToggleButton getControlAndAltToggleButton() {
        if (this.mControlAndAltToggleButton == null) {
            this.mControlAndAltToggleButton = new ToggleButton("Control & Alternates");
        }
        return this.mControlAndAltToggleButton;
    }

    private ToggleButton getSelectedToggleButton() {
        if (this.mSelectedToggleButton == null) {
            this.mSelectedToggleButton = new ToggleButton("Selected");
        }
        return this.mSelectedToggleButton;
    }

    private ToggleButton getAllToggleButton() {
        if (this.mAllToggleButton == null) {
            this.mAllToggleButton = new ToggleButton("All");
        }
        return this.mAllToggleButton;
    }

    private TextField getSystemTextField() {
        if (this.mSystemTextField == null) {
            this.mSystemTextField = new TextField();
            this.mSystemTextField.setDisable(true);
            this.mSystemTextField.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mSystemTextField;
    }

    private TextField getSiteTextField() {
        if (this.mSiteTextField == null) {
            this.mSiteTextField = new TextField();
            this.mSiteTextField.setDisable(true);
            this.mSiteTextField.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mSiteTextField;
    }

    private TextField getNameTextField() {
        if (this.mNameTextField == null) {
            this.mNameTextField = new TextField();
            this.mNameTextField.setDisable(true);
            this.mNameTextField.setMaxWidth(Double.MAX_VALUE);
        }
        return this.mNameTextField;
    }

    private TableView<SiteFrequency> getSiteFrequencyTableView() {
        if (this.mSiteFrequencyTableView == null) {
            this.mSiteFrequencyTableView = new TableView();
            this.mSiteFrequencyTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.mSiteFrequencyTableView.setPlaceholder((Node)new Label("Please select a site to view frequencies"));
            this.mTypeColumn = new TableColumn("Type");
            this.mTypeColumn.setPrefWidth(100.0);
            this.mTypeColumn.setCellValueFactory((Callback)new TypeCellValueFactory(this));
            TableColumn lcnColumn = new TableColumn("LCN");
            lcnColumn.setCellValueFactory((Callback)new PropertyValueFactory("logicalChannelNumber"));
            TableColumn frequencyColumn = new TableColumn("Frequency");
            frequencyColumn.setPrefWidth(100.0);
            frequencyColumn.setCellValueFactory((Callback)new FrequencyCellValueFactory(this));
            this.mSiteFrequencyTableView.getColumns().addAll((Object[])new TableColumn[]{this.mTypeColumn, lcnColumn, frequencyColumn});
        }
        return this.mSiteFrequencyTableView;
    }

    private Button getCreateChannelConfigurationButton() {
        if (this.mCreateChannelConfigurationButton == null) {
            this.mCreateChannelConfigurationButton = new Button("Create Channel Configuration");
            this.mCreateChannelConfigurationButton.setVisible(false);
            this.mCreateChannelConfigurationButton.setDisable(true);
            this.mCreateChannelConfigurationButton.setOnAction(event -> {
                if (this.mRadioReferenceDecoder == null) {
                    throw new IllegalStateException("Can't create channel configuration - radio reference decoder is null");
                }
                String aliasList = (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem();
                if (aliasList == null) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please select an Alias List", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Alias List Required");
                    alert.setHeaderText("Channel configuration requires an alias list");
                    alert.initOwner(this.getCreateChannelConfigurationButton().getScene().getWindow());
                    alert.showAndWait();
                    this.flashAliasListComboBox();
                } else if (this.getControlToggleButton().isSelected()) {
                    if (this.mRadioReferenceDecoder.isHybridMotorolaP25(this.mCurrentSystem)) {
                        this.createHybridP25VoiceChannels();
                    } else {
                        this.createControlChannel();
                    }
                } else if (this.getControlAndAltToggleButton().isSelected()) {
                    this.createControlAndAlternatesChannel();
                } else if (this.getSelectedToggleButton().isSelected()) {
                    this.createChannels(true);
                } else {
                    this.createChannels(false);
                }
            });
        }
        return this.mCreateChannelConfigurationButton;
    }

    private CheckBox getGoToChannelEditorCheckBox() {
        if (this.mGoToChannelEditorCheckBox == null) {
            this.mGoToChannelEditorCheckBox = new CheckBox("Go To Channel Editor");
            this.mGoToChannelEditorCheckBox.setDisable(true);
            this.mGoToChannelEditorCheckBox.setVisible(false);
            this.mGoToChannelEditorCheckBox.setSelected(this.mUserPreferences.getRadioReferencePreference().isCreateAndShowChannelEditor());
            this.mGoToChannelEditorCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.mUserPreferences.getRadioReferencePreference().setCreateAndShowChannelEditor((boolean)newValue));
        }
        return this.mGoToChannelEditorCheckBox;
    }

    public static boolean isControl(SiteFrequency siteFrequency) {
        return siteFrequency.getUse() != null && siteFrequency.getUse().contentEquals(PRIMARY_CONTROL_CHANNEL);
    }

    public static boolean isAlternate(SiteFrequency siteFrequency) {
        return siteFrequency.getUse() != null && siteFrequency.getUse().contentEquals(ALTERNATE_CONTROL_CHANNEL);
    }

    public static boolean hasControl(List<SiteFrequency> siteFrequencies) {
        for (SiteFrequency siteFrequency : siteFrequencies) {
            if (!SiteEditor.isControl(siteFrequency)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAlternate(List<SiteFrequency> siteFrequencies) {
        for (SiteFrequency siteFrequency : siteFrequencies) {
            if (!SiteEditor.isAlternate(siteFrequency)) continue;
            return true;
        }
        return false;
    }

    public class TypeCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<SiteFrequency, String>, ObservableValue<String>> {
        public TypeCellValueFactory(SiteEditor this$0) {
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<SiteFrequency, String> param) {
            String use = ((SiteFrequency)param.getValue()).getUse();
            if (use != null) {
                switch (use) {
                    case "d": {
                        return new ReadOnlyObjectWrapper((Object)SiteEditor.TOGGLE_BUTTON_CONTROL);
                    }
                    case "a": {
                        return new ReadOnlyObjectWrapper((Object)"Alt Control");
                    }
                }
            }
            return null;
        }
    }

    public class FrequencyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<SiteFrequency, String>, ObservableValue<String>> {
        private final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("0.00000");
        private SimpleStringProperty mFrequencyFormatted = new SimpleStringProperty();

        public FrequencyCellValueFactory(SiteEditor this$0) {
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<SiteFrequency, String> param) {
            this.mFrequencyFormatted.set(this.FREQUENCY_FORMATTER.format(((SiteFrequency)param.getValue()).getFrequency()));
            return this.mFrequencyFormatted;
        }
    }

    public class TypeComparator
    implements Comparator<SiteFrequency> {
        public TypeComparator(SiteEditor this$0) {
        }

        @Override
        public int compare(SiteFrequency o1, SiteFrequency o2) {
            if (o1.getUse() != null && o2.getUse() != null) {
                return o1.getUse().compareTo(o2.getUse());
            }
            if (o1.getUse() != null) {
                return -1;
            }
            if (o2.getUse() != null) {
                return 1;
            }
            return 0;
        }
    }

    public class SiteFrequencyListCell
    extends ListCell<SiteFrequency> {
        private final DecimalFormat FREQUENCY_FORMATTER = new DecimalFormat("0.00000");
        private HBox mHBox = new HBox();
        private Label mFrequency;
        private Label mType;

        public SiteFrequencyListCell(SiteEditor this$0) {
            this.mHBox.setMaxWidth(Double.MAX_VALUE);
            this.mFrequency = new Label();
            this.mFrequency.setMaxWidth(Double.MAX_VALUE);
            this.mFrequency.setAlignment(Pos.CENTER_LEFT);
            this.mType = new Label();
            this.mType.setMaxWidth(Double.MAX_VALUE);
            this.mType.setAlignment(Pos.CENTER_RIGHT);
            HBox.setHgrow((Node)this.mFrequency, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.mType, (Priority)Priority.ALWAYS);
            this.mHBox.getChildren().addAll((Object[])new Node[]{this.mFrequency, this.mType});
        }

        protected void updateItem(SiteFrequency item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setText(null);
            if (empty || item == null) {
                this.setGraphic(null);
            } else {
                String text = item.getLogicalChannelNumber() + ": " + this.FREQUENCY_FORMATTER.format(item.getFrequency());
                this.mFrequency.setText(text);
                String use = item.getUse();
                if (use == null || use.isEmpty()) {
                    this.mType.setText(null);
                } else if (use.equalsIgnoreCase(SiteEditor.ALTERNATE_CONTROL_CHANNEL)) {
                    this.mType.setText("Alt Control");
                } else if (use.equalsIgnoreCase(SiteEditor.PRIMARY_CONTROL_CHANNEL)) {
                    this.mType.setText(SiteEditor.TOGGLE_BUTTON_CONTROL);
                } else {
                    this.mType.setText(use);
                }
                this.setGraphic((Node)this.mHBox);
            }
        }
    }
}

