/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.response.Fault;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.service.radioreference.RadioReference;
import java.net.ConnectException;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDialog
extends Dialog<AuthorizationInformation> {
    private static final Logger mLog = LoggerFactory.getLogger(LoginDialog.class);
    private UserPreferences mUserPreferences;
    private TextField mUserNameText;
    private PasswordField mPasswordField;
    private TextField mPasswordText;
    private GridPane mGridPane;
    private CheckBox mShowPasswordCheckBox;
    private CheckBox mStoreLoginCheckBox;
    private Button mTestConnectionButton;
    private IconNode mTestPassIcon;
    private IconNode mTestFailIcon;
    private IconNode mTextExpiredIcon;

    public LoginDialog(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.setTitle("sdrtrunk - Radio Reference");
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContent((Node)this.getGridPane());
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data;
            ButtonBar.ButtonData buttonData = data = dialogButton == null ? null : dialogButton.getButtonData();
            if (data == null) {
                return null;
            }
            return this.getAuthorizationInformation();
        });
    }

    private AuthorizationInformation getAuthorizationInformation() {
        String password;
        boolean store = this.getStoreLoginCheckBox().isSelected();
        String username = this.getUserNameText().getText();
        String string = password = this.getPasswordField().isVisible() ? this.getPasswordField().getText() : this.getPasswordText().getText();
        if (store) {
            this.mUserPreferences.getRadioReferencePreference().setStoreCredentials(this.getStoreLoginCheckBox().isSelected());
            this.mUserPreferences.getRadioReferencePreference().setUserName(username);
            this.mUserPreferences.getRadioReferencePreference().setPassword(password);
        } else {
            this.mUserPreferences.getRadioReferencePreference().removeStoredCredentials();
        }
        return RadioReference.getAuthorizatonInformation(username, password);
    }

    private GridPane getGridPane() {
        if (this.mGridPane == null) {
            this.mGridPane = new GridPane();
            this.mGridPane.setPadding(new Insets(10.0, 10.0, 5.0, 10.0));
            this.mGridPane.setHgap(5.0);
            this.mGridPane.setVgap(5.0);
            Label userNameLabel = new Label("User Name:");
            GridPane.setHalignment((Node)userNameLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)userNameLabel, (int)0, (int)0);
            this.mGridPane.getChildren().add((Object)userNameLabel);
            GridPane.setHgrow((Node)this.getUserNameText(), (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)this.getUserNameText(), (int)1, (int)0);
            this.mGridPane.getChildren().add((Object)this.getUserNameText());
            Label passwordLabel = new Label("Password:");
            GridPane.setHalignment((Node)passwordLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)passwordLabel, (int)0, (int)1);
            this.mGridPane.getChildren().add((Object)passwordLabel);
            boolean show = this.mUserPreferences.getRadioReferencePreference().getShowPassword();
            this.getPasswordField().setVisible(!show);
            this.getPasswordText().setVisible(show);
            GridPane.setHgrow((Node)this.getPasswordText(), (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)this.getPasswordText(), (int)1, (int)1);
            this.mGridPane.getChildren().add((Object)this.getPasswordText());
            GridPane.setHgrow((Node)this.getPasswordField(), (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)this.getPasswordField(), (int)1, (int)1);
            this.mGridPane.getChildren().add((Object)this.getPasswordField());
            GridPane.setConstraints((Node)this.getShowPasswordCheckBox(), (int)2, (int)1);
            this.mGridPane.getChildren().add((Object)this.getShowPasswordCheckBox());
            GridPane.setConstraints((Node)this.getStoreLoginCheckBox(), (int)1, (int)2);
            this.mGridPane.getChildren().add((Object)this.getStoreLoginCheckBox());
            GridPane.setHalignment((Node)this.getTestConnectionButton(), (HPos)HPos.CENTER);
            GridPane.setConstraints((Node)this.getTestConnectionButton(), (int)1, (int)4);
            this.mGridPane.getChildren().add((Object)this.getTestConnectionButton());
            this.getTestPassIcon().setVisible(false);
            GridPane.setConstraints((Node)this.getTestPassIcon(), (int)2, (int)4);
            this.mGridPane.getChildren().add((Object)this.getTestPassIcon());
            this.getTestFailIcon().setVisible(false);
            GridPane.setConstraints((Node)this.getTestFailIcon(), (int)2, (int)4);
            this.mGridPane.getChildren().add((Object)this.getTestFailIcon());
            this.getTestExpiredIcon().setVisible(false);
            GridPane.setConstraints((Node)this.getTestExpiredIcon(), (int)2, (int)4);
            this.mGridPane.getChildren().add((Object)this.getTestExpiredIcon());
        }
        return this.mGridPane;
    }

    private TextField getUserNameText() {
        if (this.mUserNameText == null) {
            this.mUserNameText = new TextField();
            this.mUserNameText.setMaxWidth(Double.MAX_VALUE);
            String userName = this.mUserPreferences.getRadioReferencePreference().getUserName();
            this.mUserNameText.setText(userName);
        }
        return this.mUserNameText;
    }

    private PasswordField getPasswordField() {
        if (this.mPasswordField == null) {
            this.mPasswordField = new PasswordField();
            this.mPasswordField.setMaxWidth(Double.MAX_VALUE);
            String password = this.mUserPreferences.getRadioReferencePreference().getPassword();
            this.mPasswordField.setText(password);
        }
        return this.mPasswordField;
    }

    private TextField getPasswordText() {
        if (this.mPasswordText == null) {
            this.mPasswordText = new TextField();
            this.mPasswordText.setMaxWidth(Double.MAX_VALUE);
            String password = this.mUserPreferences.getRadioReferencePreference().getPassword();
            this.mPasswordText.setText(password);
        }
        return this.mPasswordText;
    }

    private CheckBox getShowPasswordCheckBox() {
        if (this.mShowPasswordCheckBox == null) {
            this.mShowPasswordCheckBox = new CheckBox("Show");
            this.mShowPasswordCheckBox.setSelected(this.mUserPreferences.getRadioReferencePreference().getShowPassword());
            this.mShowPasswordCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    boolean show = LoginDialog.this.mShowPasswordCheckBox.isSelected();
                    LoginDialog.this.getPasswordText().setVisible(show);
                    LoginDialog.this.getPasswordField().setVisible(!show);
                    if (show) {
                        LoginDialog.this.getPasswordText().setText(LoginDialog.this.getPasswordField().getText());
                    } else {
                        LoginDialog.this.getPasswordField().setText(LoginDialog.this.getPasswordText().getText());
                    }
                    LoginDialog.this.mUserPreferences.getRadioReferencePreference().setShowPassword(show);
                }
            });
        }
        return this.mShowPasswordCheckBox;
    }

    private CheckBox getStoreLoginCheckBox() {
        if (this.mStoreLoginCheckBox == null) {
            this.mStoreLoginCheckBox = new CheckBox("Store Login Credentials");
            this.mStoreLoginCheckBox.setSelected(this.mUserPreferences.getRadioReferencePreference().isStoreCredentials());
        }
        return this.mStoreLoginCheckBox;
    }

    private Button getTestConnectionButton() {
        if (this.mTestConnectionButton == null) {
            this.mTestConnectionButton = new Button("Test Connection");
            this.mTestConnectionButton.setMaxWidth(Double.MAX_VALUE);
            this.mTestConnectionButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    String password;
                    LoginDialog.this.getTestConnectionButton().setDisable(true);
                    LoginDialog.this.getTestPassIcon().setVisible(false);
                    LoginDialog.this.getTestFailIcon().setVisible(false);
                    LoginDialog.this.getTestExpiredIcon().setVisible(false);
                    final String userName = LoginDialog.this.getUserNameText().getText();
                    String string = password = LoginDialog.this.getPasswordField().isVisible() ? LoginDialog.this.getPasswordField().getText() : LoginDialog.this.getPasswordText().getText();
                    if (userName == null || userName.isEmpty()) {
                        Alert alert = new Alert(Alert.AlertType.ERROR, "Please provide a user name", new ButtonType[]{ButtonType.OK});
                        alert.setHeaderText("Invalid User Name");
                        alert.setTitle("Login Credentials Required");
                        alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                        alert.showAndWait();
                        LoginDialog.this.getTestConnectionButton().setDisable(false);
                        return;
                    }
                    if (password == null || password.isEmpty()) {
                        Alert alert = new Alert(Alert.AlertType.ERROR, "Please provide a password", new ButtonType[]{ButtonType.OK});
                        alert.setHeaderText("Invalid Password");
                        alert.setTitle("Login Credentials Required");
                        alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                        alert.showAndWait();
                        LoginDialog.this.getTestConnectionButton().setDisable(false);
                        return;
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean success = false;
                            try {
                                RadioReference.LoginStatus loginStatus = RadioReference.testConnectionWithExp(userName, password);
                                if (loginStatus == RadioReference.LoginStatus.VALID_PREMIUM) {
                                    LoginDialog.this.getTestPassIcon().setVisible(true);
                                    LoginDialog.this.getTestFailIcon().setVisible(false);
                                    LoginDialog.this.getTestExpiredIcon().setVisible(false);
                                } else if (loginStatus == RadioReference.LoginStatus.EXPIRED_PREMIUM) {
                                    LoginDialog.this.getTestPassIcon().setVisible(false);
                                    LoginDialog.this.getTestFailIcon().setVisible(false);
                                    LoginDialog.this.getTestExpiredIcon().setVisible(true);
                                    Alert alert = new Alert(Alert.AlertType.WARNING, "You do not have a valid Radio Reference Premium Subscription (it may have expired).", new ButtonType[]{ButtonType.OK});
                                    alert.setHeaderText("Expired Premium Account");
                                    alert.setTitle("Radio Reference Account issue");
                                    alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                                    alert.showAndWait();
                                } else if (loginStatus == RadioReference.LoginStatus.INVALID_LOGIN) {
                                    LoginDialog.this.getTestPassIcon().setVisible(false);
                                    LoginDialog.this.getTestFailIcon().setVisible(true);
                                    LoginDialog.this.getTestExpiredIcon().setVisible(false);
                                    Alert alert = new Alert(Alert.AlertType.ERROR, "Please verify username and password", new ButtonType[]{ButtonType.OK});
                                    alert.setHeaderText("Login Failed");
                                    alert.setTitle("Test Failed");
                                    alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                                    alert.showAndWait();
                                    mLog.error("Login failed. Invalid username or password.  Can't login to radioreference.com");
                                }
                            }
                            catch (RadioReferenceException rre) {
                                LoginDialog.this.getTestPassIcon().setVisible(false);
                                LoginDialog.this.getTestFailIcon().setVisible(true);
                                LoginDialog.this.getTestExpiredIcon().setVisible(false);
                                if (rre.getCause() instanceof ConnectException) {
                                    Alert alert = new Alert(Alert.AlertType.ERROR, "Please check network or radio reference availability", new ButtonType[]{ButtonType.OK});
                                    alert.setHeaderText("No Network Connection");
                                    alert.setTitle("Test Failed");
                                    alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                                    alert.showAndWait();
                                    mLog.error("No network connection to radioreference.com");
                                }
                                if (rre.hasFault()) {
                                    Fault fault = rre.getFault();
                                    Alert alert = new Alert(Alert.AlertType.ERROR, fault.getFaultString(), new ButtonType[]{ButtonType.OK});
                                    alert.setHeaderText(fault.getFaultCode());
                                    alert.setTitle("Test Failed");
                                    alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                                    alert.showAndWait();
                                    mLog.error("Test failed.  Fault [" + fault.toString() + "] Can't login to radioreference.com");
                                }
                                Alert alert = new Alert(Alert.AlertType.ERROR, "Error: " + rre.getMessage(), new ButtonType[]{ButtonType.OK});
                                alert.setHeaderText("Unknown Error");
                                alert.setTitle("Test Failed");
                                alert.initOwner(LoginDialog.this.getTestConnectionButton().getScene().getWindow());
                                alert.showAndWait();
                                mLog.error("Error testing connection to radioreference.com", (Throwable)rre);
                            }
                            LoginDialog.this.getTestConnectionButton().setDisable(false);
                        }
                    });
                }
            });
        }
        return this.mTestConnectionButton;
    }

    private IconNode getTestPassIcon() {
        if (this.mTestPassIcon == null) {
            this.mTestPassIcon = new IconNode((IconCode)FontAwesome.CHECK);
            this.mTestPassIcon.setIconSize((Number)32);
            this.mTestPassIcon.setFill((Paint)Color.GREEN);
        }
        return this.mTestPassIcon;
    }

    private IconNode getTestFailIcon() {
        if (this.mTestFailIcon == null) {
            this.mTestFailIcon = new IconNode((IconCode)FontAwesome.TIMES);
            this.mTestFailIcon.setIconSize((Number)32);
            this.mTestFailIcon.setFill((Paint)Color.RED);
        }
        return this.mTestFailIcon;
    }

    private IconNode getTestExpiredIcon() {
        if (this.mTextExpiredIcon == null) {
            this.mTextExpiredIcon = new IconNode((IconCode)FontAwesome.EXCLAMATION_TRIANGLE);
            this.mTextExpiredIcon.setIconSize((Number)32);
            this.mTextExpiredIcon.setFill((Paint)Color.ORANGERED);
        }
        return this.mTextExpiredIcon;
    }
}

